/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sirena2000.seatsMap;

import com.gridnine.xtrip.common.gds.helper.FlightHelper;
import com.gridnine.xtrip.common.gds.model.AircraftSeat;
import com.gridnine.xtrip.common.gds.model.AircraftSeatsMap;
import com.gridnine.xtrip.common.gds.model.Flight;
import com.gridnine.xtrip.common.gds.model.FlightSegment;
import com.gridnine.xtrip.common.gds.model.GdsTraveller;
import com.gridnine.xtrip.common.gds.model.TravellerAircraftSeatsMap;
import com.gridnine.xtrip.common.gds.sirena2000.SirenaHelper;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.gds.sirena2000.IBusGdsSirenaContextKeys;
import com.gridnine.xtrip.server.gds.sirena2000.model.AbstractPricingAnswer;
import com.gridnine.xtrip.server.gds.sirena2000.model.PricingVariantAnswer;
import com.gridnine.xtrip.server.gds.sirena2000.model.Svc;
import com.gridnine.xtrip.server.gds.sirena2000.seatsMap.SvcProperties;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;

public class GetSeatsPriceFromPricingVariantAnswer
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        FlightSegment segment = (FlightSegment)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.FLIGHT_SEGMENT);
        Flight flight = (Flight)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.FLIGHT);
        int flightIndex = FlightHelper.getSegments((Flight)flight).indexOf(segment);
        PricingVariantAnswer answer = (PricingVariantAnswer)ctx.getMandatoryObject((Enum)IBusGdsSirenaContextKeys.SIRENA_ANSWER);
        AircraftSeatsMap seatsMap = (AircraftSeatsMap)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.AIRCRAFT_SEATS_MAP);
        List gdsTravellers = (List)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.GDS_TRAVELLERS);
        HashMap<SvcProperties, Svc> svcPropertiesSvcMap = new HashMap<SvcProperties, Svc>(answer.getSvcs().getSvcs().size());
        for (Svc svc : answer.getSvcs().getSvcs()) {
            svcPropertiesSvcMap.put(new SvcProperties(svc.getRfisc(), svc.getServiceType(), svc.getSeatCharacteristics()), svc);
        }
        Map<GdsTraveller, Map<String, AbstractPricingAnswer.Variant.SvcPrices.Price>> pricesByGdsTravellers = this.getPricesByGdsTravellers(gdsTravellers, answer.getVariants().get(0).getSvcPrices().getPrices(), answer.getFlights().get(flightIndex).getId());
        for (TravellerAircraftSeatsMap travellerSeatMap : seatsMap.getSeatsMapsByTravellers()) {
            travellerSeatMap.getDecks().stream().flatMap(deck -> deck.getSeatsRows().stream()).flatMap(row -> row.getSeats().stream()).filter(seat -> !seat.isOccupied() && !seat.isNoSeat()).forEach(seat -> {
                BigDecimal price = this.findSeatPriceValue(pricesByGdsTravellers, (Map<SvcProperties, Svc>)svcPropertiesSvcMap, this.findGdsTravellerByTravellerUid(gdsTravellers, travellerSeatMap.getTraveller()), (AircraftSeat)seat);
                if (price != null) {
                    seat.setEquivalentAmount(price);
                } else {
                    seat.setOccupied(true);
                }
            });
        }
    }

    private GdsTraveller findGdsTravellerByTravellerUid(List<GdsTraveller> gdsTravellers, Traveller traveller) {
        for (GdsTraveller gdsTraveller : gdsTravellers) {
            if (!gdsTraveller.getTravellerUid().equals(traveller.getUid())) continue;
            return gdsTraveller;
        }
        throw Xeption.forDeveloper((String)"gdsTraveller not found", (Object[])new Object[0]);
    }

    private BigDecimal findSeatPriceValue(Map<GdsTraveller, Map<String, AbstractPricingAnswer.Variant.SvcPrices.Price>> pricesByGdsTraveller, Map<SvcProperties, Svc> svcPropertiesSvcMap, GdsTraveller gdsTraveller, AircraftSeat seat) {
        Map<String, AbstractPricingAnswer.Variant.SvcPrices.Price> svcIdPriceMap = pricesByGdsTraveller.get(gdsTraveller);
        Svc svc = svcPropertiesSvcMap.get(new SvcProperties(seat));
        if (svc == null || svcIdPriceMap == null) {
            return null;
        }
        Optional<AbstractPricingAnswer.Variant.SvcPrices.Price> price = Optional.ofNullable(svcIdPriceMap.get(svc.getId()));
        return price.map(value -> new BigDecimal(value.getTotal().getValue())).orElse(null);
    }

    private Map<GdsTraveller, Map<String, AbstractPricingAnswer.Variant.SvcPrices.Price>> getPricesByGdsTravellers(List<GdsTraveller> gdsTravellers, List<AbstractPricingAnswer.Variant.SvcPrices.Price> prices, String flightId) {
        Map travellerPrices;
        Map<String, List<AbstractPricingAnswer.Variant.SvcPrices.Price>> pricesByPassengerId = prices.stream().filter(price -> price.getFlightId().equals(flightId)).collect(Collectors.groupingBy(AbstractPricingAnswer.Variant.SvcPrices.Price::getPassengerId));
        HashMap<String, List<AbstractPricingAnswer.Variant.SvcPrices.Price>> pricesByPassengerTypeCode = new HashMap<String, List<AbstractPricingAnswer.Variant.SvcPrices.Price>>();
        for (String passengerId : pricesByPassengerId.keySet()) {
            pricesByPassengerTypeCode.put(pricesByPassengerId.get(passengerId).get(0).getCode(), pricesByPassengerId.get(passengerId));
        }
        HashMap<GdsTraveller, Map<String, AbstractPricingAnswer.Variant.SvcPrices.Price>> result = new HashMap<GdsTraveller, Map<String, AbstractPricingAnswer.Variant.SvcPrices.Price>>();
        for (GdsTraveller gdsTraveller : gdsTravellers) {
            if (gdsTraveller.getGdsId() == null) continue;
            travellerPrices = pricesByPassengerId.remove(gdsTraveller.getGdsId()).stream().collect(Collectors.toMap(AbstractPricingAnswer.Variant.SvcPrices.Price::getSvcId, Function.identity()));
            result.put(gdsTraveller, travellerPrices);
        }
        for (GdsTraveller gdsTraveller : gdsTravellers) {
            if (gdsTraveller.getGdsId() != null) continue;
            travellerPrices = pricesByPassengerTypeCode.values().stream().filter(travPrices -> ((AbstractPricingAnswer.Variant.SvcPrices.Price)travPrices.get(0)).getCode().equals(SirenaHelper.getNativeCode((DictionaryReference)gdsTraveller.getPassengerType()))).flatMap(Collection::stream).collect(Collectors.toMap(AbstractPricingAnswer.Variant.SvcPrices.Price::getSvcId, Function.identity()));
            result.put(gdsTraveller, travellerPrices);
        }
        return result;
    }
}

