/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sirena2000.seatsMap;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.gds.model.GdsTraveller;
import com.gridnine.xtrip.common.gds.sirena2000.SirenaHelper;
import com.gridnine.xtrip.common.gds.sirena2000.SirenaRequest;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.profile.AirlineBonusCard;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.gds.sirena2000.IBusGdsSirenaContextKeys;
import com.gridnine.xtrip.server.gds.sirena2000.model.PricingVariantQuery;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.ArrayList;
import java.util.List;

public class PricingVariantAddBonusCardsProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) {
        List travellers = (List)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.TRAVELLERS);
        List gdsTravellers = (List)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.GDS_TRAVELLERS);
        SirenaRequest request = (SirenaRequest)ctx.getMandatoryObject((Enum)IBusGdsSirenaContextKeys.SIRENA_REQUEST);
        int travellerId = 0;
        ArrayList<PricingVariantQuery.SpecialServices.Ssrs.Ssr> ssrs = new ArrayList<PricingVariantQuery.SpecialServices.Ssrs.Ssr>();
        for (Traveller traveller : travellers) {
            if (traveller.getAirlineBonusCards().isEmpty()) continue;
            GdsTraveller gdsTraveller = this.findGdsTravellerByTravellerUid(gdsTravellers, traveller);
            gdsTraveller.setGdsId(String.valueOf(++travellerId));
            for (AirlineBonusCard bonusCard : traveller.getAirlineBonusCards()) {
                ssrs.add(this.buildSsr(bonusCard, travellerId));
            }
        }
        if (ssrs.isEmpty()) {
            return;
        }
        PricingVariantQuery.SpecialServices specialServices = new PricingVariantQuery.SpecialServices();
        specialServices.setSsrs(new PricingVariantQuery.SpecialServices.Ssrs());
        specialServices.getSsrs().getSsrs().addAll(ssrs);
        ((PricingVariantQuery)request.getQuery()).setSpecialServices(specialServices);
    }

    private GdsTraveller findGdsTravellerByTravellerUid(List<GdsTraveller> gdsTravellers, Traveller traveller) {
        for (GdsTraveller gdsTraveller : gdsTravellers) {
            if (!gdsTraveller.getTravellerUid().equals(traveller.getUid())) continue;
            return gdsTraveller;
        }
        throw Xeption.forDeveloper((String)"gdsTraveller not found", (Object[])new Object[0]);
    }

    private PricingVariantQuery.SpecialServices.Ssrs.Ssr buildSsr(AirlineBonusCard card, int travellerId) {
        PricingVariantQuery.SpecialServices.Ssrs.Ssr ssr = new PricingVariantQuery.SpecialServices.Ssrs.Ssr();
        ssr.setPassId(String.valueOf(travellerId));
        ssr.setText(SirenaHelper.getNativeCode((DictionaryReference)card.getAirline()) + card.getNumber());
        ssr.setType("\u0427\u041f\u0421\u0416");
        return ssr;
    }
}

