/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sirena2000.seatsMap;

import com.gridnine.xtrip.common.gds.model.AircraftSeat;
import com.gridnine.xtrip.common.gds.model.AircraftSeatsMap;
import com.gridnine.xtrip.common.gds.sirena2000.SirenaRequest;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.gds.sirena2000.IBusGdsSirenaContextKeys;
import com.gridnine.xtrip.server.gds.sirena2000.model.PricingVariantQuery;
import com.gridnine.xtrip.server.gds.sirena2000.model.Svc;
import com.gridnine.xtrip.server.gds.sirena2000.seatsMap.SvcProperties;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;

public class PricingVariantAddSvcProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        SirenaRequest request = (SirenaRequest)ctx.getMandatoryObject((Enum)IBusGdsSirenaContextKeys.SIRENA_REQUEST);
        AircraftSeatsMap seatsMap = (AircraftSeatsMap)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.AIRCRAFT_SEATS_MAP);
        List seats = seatsMap.getSeatsMapsByTravellers().stream().flatMap(travellerAircraftSeatsMap -> travellerAircraftSeatsMap.getDecks().stream()).flatMap(deck -> deck.getSeatsRows().stream()).flatMap(row -> row.getSeats().stream()).collect(Collectors.toList());
        HashSet<SvcProperties> seatsSvcProperties = new HashSet<SvcProperties>();
        for (AircraftSeat seat : seats) {
            SvcProperties svcProperties;
            if (seat.isOccupied() || seat.isNoSeat() || !seatsSvcProperties.add(svcProperties = new SvcProperties(seat))) continue;
            ((PricingVariantQuery)request.getQuery()).getAnswerParams().getSvcs().add(this.buildSvc(svcProperties));
        }
        ((PricingVariantQuery)request.getQuery()).getAnswerParams().setRegroup(Boolean.TRUE);
    }

    private Svc buildSvc(SvcProperties svcProperties) {
        Svc svc = new Svc();
        svc.setRfisc(svcProperties.getRfisc());
        svc.setServiceType(svcProperties.getServiceType());
        svc.setSeatCharacteristics(svcProperties.getSeatCharacteristics());
        return svc;
    }
}

