/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sirena2000.seatsMap;

import com.gridnine.xtrip.common.gds.model.FlightSegment;
import com.gridnine.xtrip.common.gds.sirena2000.AbstractSirenaQuery;
import com.gridnine.xtrip.common.gds.sirena2000.SirenaHelper;
import com.gridnine.xtrip.common.gds.sirena2000.SirenaRequest;
import com.gridnine.xtrip.common.model.dict.ClassOfService;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.gds.sirena2000.IBusGdsSirenaContextKeys;
import com.gridnine.xtrip.server.gds.sirena2000.model.SeatMapQuery;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import org.apache.commons.lang.time.FastDateFormat;

public class SeatMapRequestBuilder
extends BaseProcessor {
    private static final FastDateFormat DTF = FastDateFormat.getInstance((String)"dd.MM.yyyy");

    public void process(MessageContext ctx) throws Exception {
        FlightSegment segment = (FlightSegment)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.FLIGHT_SEGMENT);
        ctx.putObject((Enum)IBusGdsSirenaContextKeys.SIRENA_REQUEST, this.buildRequest(segment));
    }

    private SirenaRequest<SeatMapQuery> buildRequest(FlightSegment segment) {
        SirenaRequest request = new SirenaRequest();
        SeatMapQuery query = new SeatMapQuery();
        query.setDeparture(SirenaHelper.getNativeCode((DictionaryReference)segment.getLocationBegin()));
        query.setArrival(SirenaHelper.getNativeCode((DictionaryReference)segment.getLocationEnd()));
        query.setDate(DTF.format(segment.getDateBegin()));
        query.setCompany(SirenaHelper.getNativeCode((DictionaryReference)segment.getAirline()));
        query.setFlight(segment.getFlightNumber());
        query.setCabin(SirenaHelper.serviceClassToString((ClassOfService)segment.getServiceClass()));
        request.setQuery((AbstractSirenaQuery)query);
        request.setPrivileged(false);
        request.setSecure(false);
        return request;
    }
}

