/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sirena2000.seatsMap;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.gds.helper.FlightHelper;
import com.gridnine.xtrip.common.gds.model.AircraftDeck;
import com.gridnine.xtrip.common.gds.model.AircraftSeat;
import com.gridnine.xtrip.common.gds.model.AircraftSeatsMap;
import com.gridnine.xtrip.common.gds.model.AircraftSeatsRow;
import com.gridnine.xtrip.common.gds.model.Flight;
import com.gridnine.xtrip.common.gds.model.FlightSegment;
import com.gridnine.xtrip.common.gds.model.GdsTraveller;
import com.gridnine.xtrip.common.gds.model.TravellerAircraftSeatsMap;
import com.gridnine.xtrip.common.gds.sirena2000.SirenaCustomPropertiesHelper;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.dict.ClassOfService;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.gds.sirena2000.IBusGdsSirenaContextKeys;
import com.gridnine.xtrip.server.gds.sirena2000.SirenaServerHelper;
import com.gridnine.xtrip.server.gds.sirena2000.model.SeatMapAnswer;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;

public class SeatMapResponseParser
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        SeatMapAnswer answer = (SeatMapAnswer)ctx.getMandatoryObject((Enum)IBusGdsSirenaContextKeys.SIRENA_ANSWER);
        Flight flight = (Flight)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.FLIGHT);
        FlightSegment segment = (FlightSegment)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.FLIGHT_SEGMENT);
        List gdsTravellers = (List)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.GDS_TRAVELLERS);
        List travellers = (List)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.TRAVELLERS);
        AircraftSeatsMap seatsMap = new AircraftSeatsMap();
        seatsMap.setSegmentId(String.valueOf(this.getSegmentIndex(flight, segment)));
        HashMap<Traveller, GdsTraveller> travellerGdsTravellerMap = new HashMap<Traveller, GdsTraveller>();
        block0: for (Traveller traveller : travellers) {
            for (GdsTraveller gdsTraveller : gdsTravellers) {
                if (!gdsTraveller.getTravellerUid().equals(traveller.getUid())) continue;
                travellerGdsTravellerMap.put(traveller, gdsTraveller);
                continue block0;
            }
        }
        int infantTravellersCount = (int)gdsTravellers.stream().map(GdsTraveller::getPassengerType).filter(DictHelper::isInfantPassengerType).count();
        Set<String> deniedSeats = answer.getDenied() != null ? answer.getDenied().getSeats() : Collections.emptySet();
        Set<String> sbpresFilterSeatCharacteristics = answer.getSbpresFilter() != null ? answer.getSbpresFilter().getSeatCharacteristics() : Collections.emptySet();
        for (Traveller traveller : travellers) {
            GdsTraveller gdsTraveller = (GdsTraveller)travellerGdsTravellerMap.get(traveller);
            if (DictHelper.isInfantPassengerType((DictionaryReference)((GdsTraveller)travellerGdsTravellerMap.get(traveller)).getPassengerType())) continue;
            boolean travellerWithInfant = this.isTravellerWithInfant(gdsTraveller, infantTravellersCount--);
            TravellerAircraftSeatsMap travellerSeatsMap = new TravellerAircraftSeatsMap();
            travellerSeatsMap.setTraveller(traveller);
            for (SeatMapAnswer.Deck gdsDeck : answer.getDecks()) {
                travellerSeatsMap.getDecks().add(new AircraftDeckBuilder(flight, segment, gdsDeck, deniedSeats, gdsTraveller, sbpresFilterSeatCharacteristics, travellerWithInfant).build());
            }
            seatsMap.getSeatsMapsByTravellers().add(travellerSeatsMap);
        }
        ctx.putObject((Enum)IBusGdsContextKeys.AIRCRAFT_SEATS_MAP, (Object)seatsMap);
    }

    private int getSegmentIndex(Flight flight, FlightSegment segment) {
        List segments = FlightHelper.getSegments((Flight)flight);
        for (int idx = 0; idx < segments.size(); ++idx) {
            FlightSegment seg = (FlightSegment)segments.get(idx);
            if (!seg.getFlightNumber().equals(segment.getFlightNumber()) || !seg.getLocationBegin().equals((Object)segment.getLocationBegin()) || !seg.getLocationEnd().equals((Object)segment.getLocationEnd()) || !seg.getDateBegin().equals(segment.getDateBegin())) continue;
            return idx;
        }
        throw Xeption.forDeveloper((String)"segment index not found", (Object[])new Object[0]);
    }

    private boolean isTravellerWithInfant(GdsTraveller gdsTraveller, int remainInfantTravellerCounter) {
        return remainInfantTravellerCounter > 0 && DictHelper.isAdultPassengerType((DictionaryReference)gdsTraveller.getPassengerType());
    }

    private class AircraftDeckBuilder {
        private Flight flight;
        private FlightSegment segment;
        private SeatMapAnswer.Deck gdsDeck;
        private Set<String> deniedSeats;
        private GdsTraveller gdsTraveller;
        private Set<String> sbpresFilterSeatCharacteristics;
        private boolean travellerWithInfant;

        public AircraftDeckBuilder(Flight flight, FlightSegment segment, SeatMapAnswer.Deck gdsDeck, Set<String> deniedSeats, GdsTraveller gdsTraveller, Set<String> sbpresFilterSeatCharacteristics, boolean travellerWithInfant) {
            this.flight = flight;
            this.segment = segment;
            this.gdsDeck = gdsDeck;
            this.deniedSeats = deniedSeats;
            this.gdsTraveller = gdsTraveller;
            this.sbpresFilterSeatCharacteristics = sbpresFilterSeatCharacteristics;
            this.travellerWithInfant = travellerWithInfant;
        }

        private AircraftDeck build() {
            AircraftDeck aircraftDeck = new AircraftDeck();
            aircraftDeck.setLocation(SirenaServerHelper.code2AircraftDeckLocation(this.gdsDeck.getCode()));
            List gdsRows = this.gdsDeck.getCabines().stream().filter(cabine -> cabine.getCode().equals(this.classOfService2CabinCode(this.segment.getServiceClass()))).flatMap(cabin -> cabin.getRows().stream()).collect(Collectors.toList());
            for (SeatMapAnswer.Deck.Cabine.Row gdsRow : gdsRows) {
                aircraftDeck.getSeatsRows().add(this.convertGdsRow2AircraftSeatRow(gdsRow));
            }
            return aircraftDeck;
        }

        private AircraftSeatsRow convertGdsRow2AircraftSeatRow(SeatMapAnswer.Deck.Cabine.Row gdsSeatsRow) {
            AircraftSeatsRow seatsRow = new AircraftSeatsRow();
            seatsRow.setNumber(gdsSeatsRow.getNumber());
            for (int i = 0; i < gdsSeatsRow.getRowItems().size(); ++i) {
                if (!(gdsSeatsRow.getRowItems().get(i) instanceof SeatMapAnswer.Deck.Cabine.Row.Aisle)) continue;
                if (i > 0) {
                    SirenaServerHelper.addAisleToChairProps((SeatMapAnswer.Deck.Cabine.Row.Chair)gdsSeatsRow.getRowItems().get(i - 1));
                }
                if (i >= gdsSeatsRow.getRowItems().size() - 1) continue;
                SirenaServerHelper.addAisleToChairProps((SeatMapAnswer.Deck.Cabine.Row.Chair)gdsSeatsRow.getRowItems().get(i + 1));
            }
            for (SeatMapAnswer.Deck.Cabine.Row.RowItem rowItem : gdsSeatsRow.getRowItems()) {
                if (rowItem instanceof SeatMapAnswer.Deck.Cabine.Row.Aisle) continue;
                seatsRow.getSeats().add(this.convertChair2AircraftSeat((SeatMapAnswer.Deck.Cabine.Row.Chair)rowItem, gdsSeatsRow.getNumber()));
            }
            return seatsRow;
        }

        private AircraftSeat convertChair2AircraftSeat(SeatMapAnswer.Deck.Cabine.Row.Chair chair, int rowNumber) {
            AircraftSeat seat = new AircraftSeat();
            seat.setNumber(chair.getValue());
            seat.setGds(this.flight.getGds());
            Set<String> chairProps = this.getChairProps(chair);
            seat.getIndicators().addAll(chairProps.stream().map(SirenaServerHelper::gdsSeatProperty2SeatIndicator).filter(Objects::nonNull).collect(Collectors.toSet()));
            seat.setOccupied(this.isOccupiedSeat(chair, rowNumber, chairProps));
            if (seat.isOccupied()) {
                return seat;
            }
            this.fillSeatCustomProperties(seat, chair, chairProps);
            seat.getCharacteristics().addAll(DictHelper.getSeatCharacteristicsWithUniqueTranslation(chairProps, (GdsName)GdsName.SIRENA));
            return seat;
        }

        private boolean isOccupiedSeat(SeatMapAnswer.Deck.Cabine.Row.Chair chair, int rowNumber, Set<String> chairProps) {
            if (StringUtils.isEmpty((String)chair.getRfisc())) {
                return true;
            }
            if (!this.deniedSeats.isEmpty() && this.deniedSeats.contains(rowNumber + chair.getValue())) {
                return true;
            }
            if (this.chairPropsContainAnyOfTheProps(chairProps, "occupied", "blocked", "protected", "last_offer", "V")) {
                return true;
            }
            return !chairProps.contains("free");
        }

        private boolean seatIsNotSuitableForInfants(Set<String> chairProps) {
            return this.chairPropsContainAnyOfTheProps(chairProps, "only_adults", "1A");
        }

        private boolean seatIsNotSuitableForChildren(Set<String> chairProps) {
            return this.chairPropsContainAnyOfTheProps(chairProps, "IE", "only_adults");
        }

        private boolean chairPropsContainAnyOfTheProps(Set<String> chairProps, String ... props) {
            for (String prop : props) {
                if (!chairProps.contains(prop)) continue;
                return true;
            }
            return false;
        }

        private Set<String> getChairProps(SeatMapAnswer.Deck.Cabine.Row.Chair chair) {
            String[] props = (String[])ArrayUtils.addAll((Object[])chair.getProps().split(","), (Object[])chair.getOriginalProps().split(","));
            HashSet<String> result = new HashSet<String>(props.length);
            Collections.addAll(result, props);
            return result;
        }

        private void fillSeatCustomProperties(AircraftSeat seat, SeatMapAnswer.Deck.Cabine.Row.Chair chair, Set<String> props) {
            SirenaCustomPropertiesHelper.setSvcRfisc((AircraftSeat)seat, (String)chair.getRfisc());
            SirenaCustomPropertiesHelper.setSvcServiceType((AircraftSeat)seat, (String)"F");
            StringBuilder filteredPropsBuilder = new StringBuilder();
            for (String filterProp : this.sbpresFilterSeatCharacteristics) {
                if (!props.contains(filterProp)) continue;
                if (filteredPropsBuilder.length() == 0) {
                    filteredPropsBuilder.append(filterProp);
                    continue;
                }
                filteredPropsBuilder.append(',').append(filterProp);
            }
            String svcSeatCharacteristics = filteredPropsBuilder.toString();
            SirenaCustomPropertiesHelper.setSvcSeatCharacteristics((AircraftSeat)seat, (String)(svcSeatCharacteristics.isEmpty() ? null : svcSeatCharacteristics));
        }

        private String classOfService2CabinCode(ClassOfService classOfService) {
            switch (classOfService) {
                case ECONOMY: {
                    return "Y";
                }
                case BUSINESS: {
                    return "C";
                }
                case FIRST: {
                    return "F";
                }
            }
            throw Xeption.forDeveloper((String)"unexpected class of service {0}", (Object[])new Object[]{classOfService});
        }
    }
}

