/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sirena2000.selectFlight;

import com.gridnine.xtrip.common.gds.model.Flight;
import com.gridnine.xtrip.common.gds.model.FlightSegment;
import com.gridnine.xtrip.common.gds.model.FlightSegmentTariff;
import com.gridnine.xtrip.common.gds.sirena2000.SirenaHelper;
import com.gridnine.xtrip.common.gds.sirena2000.SirenaRequest;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.gds.sirena2000.IBusGdsSirenaContextKeys;
import com.gridnine.xtrip.server.gds.sirena2000.model.AbstractPricingQuery;
import com.gridnine.xtrip.server.gds.sirena2000.model.PricingVariantQuery;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import org.apache.commons.lang.time.FastDateFormat;

public class PricingVariantAddSegmentsProcessor
extends BaseProcessor {
    private static final FastDateFormat DTF = FastDateFormat.getInstance((String)"dd.MM.yy");

    public void process(MessageContext ctx) throws Exception {
        SirenaRequest request = (SirenaRequest)ctx.getMandatoryObject((Enum)IBusGdsSirenaContextKeys.SIRENA_REQUEST);
        Flight flight = (Flight)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.FLIGHT);
        int jointId = 0;
        for (FlightSegmentTariff fst : flight.getSegmentTariffs()) {
            for (FlightSegment seg : fst.getSegments()) {
                if (seg.isStarting()) {
                    ++jointId;
                }
                AbstractPricingQuery.Segment segment = new AbstractPricingQuery.Segment();
                segment.setDeparture(SirenaHelper.getNativeCode((DictionaryReference)seg.getLocationBegin()));
                segment.setArrival(SirenaHelper.getNativeCode((DictionaryReference)seg.getLocationEnd()));
                segment.setDate(DTF.format(seg.getDateBegin()));
                segment.setSubclass(seg.getBookingClass());
                segment.setCompany(SirenaHelper.getNativeCode((DictionaryReference)seg.getAirline()));
                segment.setNum(seg.getFlightNumber());
                segment.setJointId(Integer.toString(jointId));
                ((PricingVariantQuery)request.getQuery()).getSegments().add(segment);
            }
        }
    }
}

