/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sirena2000.selectFlight;

import com.gridnine.xtrip.common.gds.exceptions.SeatsNotConfirmedException;
import com.gridnine.xtrip.common.gds.helper.GdsDictHelper;
import com.gridnine.xtrip.common.gds.model.AncillaryFee;
import com.gridnine.xtrip.common.gds.model.AncillaryFeeDescription;
import com.gridnine.xtrip.common.gds.model.AncillaryFeeType;
import com.gridnine.xtrip.common.gds.model.FareInfo;
import com.gridnine.xtrip.common.gds.model.Flight;
import com.gridnine.xtrip.common.gds.model.FlightSegment;
import com.gridnine.xtrip.common.gds.model.FlightSegmentTariff;
import com.gridnine.xtrip.common.gds.sirena2000.SirenaHelper;
import com.gridnine.xtrip.common.model.booking.PassengerType;
import com.gridnine.xtrip.common.model.booking.air.LuggageInfo;
import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.util.EnumUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.gds.sirena2000.IBusGdsSirenaContextKeys;
import com.gridnine.xtrip.server.gds.sirena2000.model.AbstractPricingAnswer;
import com.gridnine.xtrip.server.gds.sirena2000.model.PricingVariantAnswer;
import com.gridnine.xtrip.server.gds.sirena2000.model.Svc;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public class PricingVariantResponseParser
extends BaseProcessor {
    private static final String GDS_ID_SEPARATOR = "|";

    private static DateFormat createDtf() {
        return new SimpleDateFormat("dd.MM.yy");
    }

    public void process(MessageContext ctx) {
        String key;
        Flight flight = (Flight)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.FLIGHT);
        HashMap luggageInfos = new HashMap();
        PricingVariantAnswer answer = (PricingVariantAnswer)ctx.getMandatoryObject((Enum)IBusGdsSirenaContextKeys.SIRENA_ANSWER);
        if (answer.getVariants() == null || answer.getVariants().isEmpty()) {
            throw new SeatsNotConfirmedException();
        }
        for (AbstractPricingAnswer.Variant.Flight vfl : answer.getVariants().get(0).getFlights()) {
            String flightNum = vfl.getNum();
            String flightDate = vfl.getDeptdate();
            key = flightNum + flightDate;
            for (AbstractPricingAnswer.Variant.Flight.Price price : vfl.getPrices()) {
                DictionaryReference pt;
                HashMap<DictionaryReference, LuggageInfo> luggageInfosForSegment = (HashMap<DictionaryReference, LuggageInfo>)luggageInfos.get(key);
                if (luggageInfosForSegment == null) {
                    luggageInfosForSegment = new HashMap<DictionaryReference, LuggageInfo>();
                }
                if (luggageInfosForSegment.get(pt = SirenaHelper.resolveNativeCode(PassengerType.class, (String)price.getCode())) == null) {
                    luggageInfosForSegment.put(pt, AirProductHelper.parseLuggageInfo((String)price.getBaggage()));
                }
                luggageInfos.put(key, luggageInfosForSegment);
            }
        }
        this.parseAncillaryFees(answer, flight);
        for (FlightSegmentTariff fst : flight.getSegmentTariffs()) {
            for (FlightSegment fs : fst.getSegments()) {
                key = fs.getFlightNumber() + PricingVariantResponseParser.createDtf().format(fs.getDateBegin());
                HashMap luggageInfosForSegment = (HashMap)luggageInfos.get(key);
                if (luggageInfosForSegment == null) continue;
                for (FareInfo fi : fs.getFareInfos()) {
                    if (luggageInfosForSegment.get(fi.getPassengerType()) == null) continue;
                    fi.setLuggageInfo((LuggageInfo)luggageInfosForSegment.get(fi.getPassengerType()));
                }
            }
        }
    }

    private void parseAncillaryFees(PricingVariantAnswer answer, Flight flight) {
        flight.getAncillaryFees().clear();
        int segIdx = 0;
        List<AncillaryFee> currentLegAncFees = new ArrayList<AncillaryFee>();
        for (AbstractPricingAnswer.Variant.Flight vfl : answer.getVariants().get(0).getFlights()) {
            if (vfl.getSvcs() == null) {
                ++segIdx;
                continue;
            }
            if (vfl.getOSegmentPartNum() == 0) {
                currentLegAncFees = this.getAncillaryFees(vfl, flight, segIdx++);
                flight.getAncillaryFees().addAll(currentLegAncFees);
                continue;
            }
            List<AncillaryFee> newAncFees = this.getOrUpdateAncillaryFees(vfl, flight, currentLegAncFees, segIdx++);
            currentLegAncFees.addAll(newAncFees);
            flight.getAncillaryFees().addAll(newAncFees);
        }
        flight.getAncillaryFees().forEach(this::updateGdsId);
    }

    private void updateGdsId(AncillaryFee ancillaryFee) {
        ancillaryFee.setGdsId(ancillaryFee.getGdsId() + GDS_ID_SEPARATOR + TextUtil.join((String)"-", (Iterable)ancillaryFee.getSegmentNumbers()));
    }

    private List<AncillaryFee> getOrUpdateAncillaryFees(AbstractPricingAnswer.Variant.Flight vfl, Flight flight, List<AncillaryFee> currentLegAncFees, int segIdx) {
        ArrayList<AncillaryFee> newAncFees = new ArrayList<AncillaryFee>();
        List<Svc> svcs = PricingVariantResponseParser.getUniqueSvcsForAllPassengerTypes(PricingVariantResponseParser.getPassengerType2SvcsMap(vfl));
        for (Svc svc : svcs) {
            if ("BG".equals(svc.getGroup()) && ("is_bagnorm".equals(svc.getPrices().get(0).getReason()) || "is_free".equals(svc.getPrices().get(0).getReason()))) continue;
            HashSet<String> processedTypes = new HashSet<String>();
            for (AbstractPricingAnswer.Variant.Flight.Price price : svc.getPrices()) {
                AncillaryFee ancillaryFee;
                if (!processedTypes.add(price.getCode())) continue;
                String svcGdsId = this.getGdsId(svc, price);
                Optional<AncillaryFee> ancillaryFeeOpt = currentLegAncFees.stream().filter(fees -> fees.getGdsId().equals(svcGdsId)).findFirst();
                if (price.getDocId() != null && ancillaryFeeOpt.isPresent()) {
                    ancillaryFee = ancillaryFeeOpt.get();
                    ancillaryFee.setEquivalentAmount(ancillaryFee.getEquivalentAmount().add(new BigDecimal(price.getFare().getValue())));
                    ancillaryFee.getSegmentNumbers().add(segIdx);
                    continue;
                }
                ancillaryFee = this.createAncillaryFee(svc, price, segIdx, flight.getGds());
                if (ancillaryFee == null) continue;
                newAncFees.add(ancillaryFee);
            }
        }
        return newAncFees;
    }

    private List<AncillaryFee> getAncillaryFees(AbstractPricingAnswer.Variant.Flight vfl, Flight flight, int segIdx) {
        ArrayList<AncillaryFee> ancillaryFees = new ArrayList<AncillaryFee>();
        List<Svc> svcs = PricingVariantResponseParser.getUniqueSvcsForAllPassengerTypes(PricingVariantResponseParser.getPassengerType2SvcsMap(vfl));
        for (Svc svc : svcs) {
            if ("BG".equals(svc.getGroup()) && ("is_bagnorm".equals(svc.getPrices().get(0).getReason()) || "is_free".equals(svc.getPrices().get(0).getReason()))) continue;
            HashSet<String> processedTypes = new HashSet<String>();
            for (AbstractPricingAnswer.Variant.Flight.Price price : svc.getPrices()) {
                AncillaryFee ancillaryFee;
                if (!processedTypes.add(price.getCode()) || (ancillaryFee = this.createAncillaryFee(svc, price, segIdx, flight.getGds())) == null) continue;
                ancillaryFees.add(ancillaryFee);
            }
        }
        return ancillaryFees;
    }

    private static List<Svc> getUniqueSvcsForAllPassengerTypes(Map<DictionaryReference<PassengerType>, List<Svc>> passengerType2SvcsMap) {
        ArrayList<Svc> uniqueSvcsForAllPassengerTypes = new ArrayList<Svc>();
        for (List<Svc> svcs : passengerType2SvcsMap.values()) {
            uniqueSvcsForAllPassengerTypes.addAll(svcs);
        }
        return uniqueSvcsForAllPassengerTypes;
    }

    private static Map<DictionaryReference<PassengerType>, List<Svc>> getPassengerType2SvcsMap(AbstractPricingAnswer.Variant.Flight vfl) {
        HashMap passengerId2Svcs = new HashMap();
        List<Svc> svcs = vfl.getSvcs();
        List passIds = vfl.getSvcs().stream().flatMap(svc -> svc.getPrices().stream().map(AbstractPricingAnswer.Variant.Flight.Price::getPassengerId)).distinct().collect(Collectors.toList());
        for (String passId : passIds) {
            List svcsForPassId = svcs.stream().filter(svc -> passId.equals(svc.getPrices().get(0).getPassengerId())).collect(Collectors.toList());
            passengerId2Svcs.put(passId, svcsForPassId);
        }
        Map<String, DictionaryReference<PassengerType>> passengerId2PassengerTypeMap = PricingVariantResponseParser.getPassengerId2PassengerTypeMap(vfl);
        HashMap<DictionaryReference<PassengerType>, List<Svc>> passengerType2Svcs = new HashMap<DictionaryReference<PassengerType>, List<Svc>>();
        for (String passId : passengerId2Svcs.keySet()) {
            DictionaryReference<PassengerType> passengerType = passengerId2PassengerTypeMap.get(passId);
            passengerType2Svcs.put(passengerType, (List<Svc>)passengerId2Svcs.get(passId));
        }
        return passengerType2Svcs;
    }

    private static Map<String, DictionaryReference<PassengerType>> getPassengerId2PassengerTypeMap(AbstractPricingAnswer.Variant.Flight vfl) {
        HashMap<String, DictionaryReference<PassengerType>> passengerId2PassengerType = new HashMap<String, DictionaryReference<PassengerType>>();
        for (AbstractPricingAnswer.Variant.Flight.Price price : vfl.getPrices()) {
            DictionaryReference passengerTypeDictionaryReference = SirenaHelper.resolveNativeCode(PassengerType.class, (String)price.getCode());
            passengerId2PassengerType.put(price.getPassengerId(), (DictionaryReference<PassengerType>)passengerTypeDictionaryReference);
        }
        return passengerId2PassengerType;
    }

    private AncillaryFee createAncillaryFee(Svc svc, AbstractPricingAnswer.Variant.Flight.Price price, int segIdx, GdsName gdsName) {
        AncillaryFeeType ancillaryFeeType = GdsDictHelper.parseAncillaryFeeType((String)svc.getGroup());
        if (ancillaryFeeType == null) {
            return null;
        }
        if (ancillaryFeeType == AncillaryFeeType.PREFERRED_SEATING) {
            return null;
        }
        AncillaryFee ancillaryFee = new AncillaryFee();
        ancillaryFee.setType(ancillaryFeeType);
        ancillaryFee.setGdsDescription(svc.getName());
        DictionaryReference passTypeDict = SirenaHelper.resolveNativeCode(PassengerType.class, (String)price.getCode());
        ancillaryFee.setPassengerType(passTypeDict);
        ancillaryFee.setEquivalentAmount(new BigDecimal(price.getFare().getValue()));
        ancillaryFee.getSegmentNumbers().add(segIdx);
        ancillaryFee.setGdsId(this.getGdsId(svc, price));
        ancillaryFee.setDescription(this.getAncillaryFeeDescription(ancillaryFee, gdsName));
        PassengerType passType = (PassengerType)DictHelper.resolve((DictionaryReference)passTypeDict);
        if (passType == null) {
            this.log.warn(String.format("passType is empty or incorrect for svc %s-%s", svc.getRfic(), svc.getRfisc()));
            return null;
        }
        if (passType.isWithoutSeat()) {
            return null;
        }
        return ancillaryFee;
    }

    private String getGdsId(Svc svc, AbstractPricingAnswer.Variant.Flight.Price price) {
        return String.join((CharSequence)GDS_ID_SEPARATOR, svc.getRfisc(), svc.getRfic(), svc.getEmd(), svc.getServiceType(), price.getDocId() != null ? price.getDocId() : "");
    }

    private DictionaryReference<AncillaryFeeDescription> getAncillaryFeeDescription(AncillaryFee ancillaryFee, GdsName gdsName) {
        AncillaryFeeDescription ancillaryFeeDescription;
        AncillaryFeeType ancillaryFeeType = ancillaryFee.getType();
        String[] gdsId = ancillaryFee.getGdsId() == null ? new String[]{} : ancillaryFee.getGdsId().split("\\|");
        String ancillaryFeeKey = ancillaryFee.getGdsDescription();
        if (AncillaryFeeType.BAGGAGE.equals((Object)ancillaryFeeType) && gdsId.length > 1) {
            ancillaryFeeKey = PricingVariantResponseParser.buildAncillaryFeeKey(gdsId[0], gdsId[1]);
        }
        if ((ancillaryFeeDescription = GdsDictHelper.findAncillaryFeeDescriptionByServiceCode((AncillaryFeeType)ancillaryFeeType, (String)ancillaryFeeKey, (GdsName)gdsName)) == null) {
            this.log.error(String.format("AncillaryFeeDescription is null for code = %s, type = %s", ancillaryFee.getGdsId(), EnumUtil.nameOf((Enum)ancillaryFeeType)));
        }
        return DictHelper.toReference((BaseDictionary)ancillaryFeeDescription);
    }

    public static String buildAncillaryFeeKey(String rfiscCode, String serviceType) {
        return String.join((CharSequence)"/", serviceType, rfiscCode);
    }
}

