/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sirena2000.splitReservation;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.gds.sirena2000.AbstractSirenaQuery;
import com.gridnine.xtrip.common.gds.sirena2000.SirenaHelper;
import com.gridnine.xtrip.common.gds.sirena2000.SirenaRequest;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.gds.sirena2000.IBusGdsSirenaContextKeys;
import com.gridnine.xtrip.server.gds.sirena2000.model.DivideOrderQuery;
import com.gridnine.xtrip.server.gds.sirena2000.model.OrderAnswer;
import com.gridnine.xtrip.server.gds.sirena2000.model.Pnr;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

public class DivideOrderQueryBuilder
extends BaseProcessor {
    public void process(MessageContext ctx) {
        Reservation reservation = (Reservation)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION);
        Collection productUidsToSplit = (Collection)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.PRODUCT_UIDS_TO_SPLIT);
        OrderAnswer orderAnswer = (OrderAnswer)ctx.getMandatoryObject((Enum)IBusGdsSirenaContextKeys.SIRENA_ANSWER);
        SirenaRequest<DivideOrderQuery> request = this.buildRequest(reservation, productUidsToSplit, orderAnswer);
        ctx.putObject((Enum)IBusGdsSirenaContextKeys.SIRENA_REQUEST, request);
    }

    private SirenaRequest<DivideOrderQuery> buildRequest(Reservation reservation, Collection<String> productUidsToSplit, OrderAnswer orderAnswer) {
        SirenaRequest request = new SirenaRequest();
        request.setQuery((AbstractSirenaQuery)this.buildQuery(reservation, productUidsToSplit, orderAnswer));
        request.setSecure(false);
        request.setPrivileged(true);
        return request;
    }

    private DivideOrderQuery buildQuery(Reservation reservation, Collection<String> productUidsToSplit, OrderAnswer orderAnswer) {
        DivideOrderQuery query = new DivideOrderQuery();
        query.setRegnum(SirenaHelper.getRecordLocator((Reservation)reservation));
        query.setSurname(SirenaHelper.getSurname((Reservation)reservation));
        List products = reservation.getProducts().stream().filter(bp -> productUidsToSplit.contains(bp.getUid())).filter(bp -> bp instanceof Product).map(bp -> (Product)bp).filter(p -> p.getProductCategory() == ProductCategory.AIR).collect(Collectors.toList());
        for (Product product : products) {
            DivideOrderQuery.Passenger passenger = new DivideOrderQuery.Passenger();
            Pnr.Passengers.Passenger orderPassenger = orderAnswer.getPnr().getPassengers().getPassengers().stream().filter(p -> p.getId().equals(product.getGdsId())).findAny().orElseThrow(() -> Xeption.forDeveloper((String)"passenger not found for gds id {0}", (Object[])new Object[]{product.getGdsId()}));
            passenger.setName(orderPassenger.getName());
            passenger.setSurname(orderPassenger.getSurname());
            query.getPassengers().add(passenger);
        }
        return query;
    }
}

