/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sirena2000.ssr;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.gds.sirena2000.SirenaHelper;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.SpecialServiceRequest;
import com.gridnine.xtrip.common.model.booking.air.Segment;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.SpecialServiceRequestDict;
import com.gridnine.xtrip.common.model.dict.SpecialServiceRequestStatus;
import com.gridnine.xtrip.server.gds.helper.GDSHelper;
import com.gridnine.xtrip.server.gds.sirena2000.IBusGdsSirenaContextKeys;
import com.gridnine.xtrip.server.gds.sirena2000.model.OrderAnswer;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Collection;
import java.util.Date;
import org.apache.commons.lang.StringUtils;

public class UpdateSsrsProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        OrderAnswer answer = (OrderAnswer)ctx.getMandatoryObject((Enum)IBusGdsSirenaContextKeys.SIRENA_ANSWER);
        if (answer.getSpecialServices() != null && answer.getSpecialServices().getSsrs() != null) {
            Reservation reservation = (Reservation)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION);
            for (OrderAnswer.SpecialServices.Ssr ssr : answer.getSpecialServices().getSsrs()) {
                if (StringUtils.isBlank((String)ssr.getPassId()) || StringUtils.isBlank((String)ssr.getSegId())) continue;
                Collection products = GDSHelper.findProductsByGdsId((Reservation)reservation, (String)ssr.getPassId());
                Segment segment = (Segment)GDSHelper.findProductAndSegmentBySegmentGdsId((Collection)products, (String)ssr.getSegId()).getSecond();
                DictionaryReference ssrDictRef = SirenaHelper.resolveNativeCode(SpecialServiceRequestDict.class, (String)ssr.getType(), (boolean)false, (boolean)false);
                if (ssrDictRef == null) continue;
                SpecialServiceRequest request = UpdateSsrsProcessor.findSsr(segment, (DictionaryReference<SpecialServiceRequestDict>)ssrDictRef);
                if (request == null) {
                    request = new SpecialServiceRequest();
                    request.setRequestDate(new Date());
                    request.setType(ssrDictRef);
                    segment.getSsrs().add(request);
                }
                request.setRequestFreeText(ssr.getText());
                if ("HK".equals(ssr.getStatus())) {
                    request.setStatus(SpecialServiceRequestStatus.CONFIRMED);
                    continue;
                }
                if ("TT".equals(ssr.getStatus()) || "\u0422\u0422".equals(ssr.getStatus())) {
                    request.setStatus(SpecialServiceRequestStatus.PENDING);
                    continue;
                }
                request.setStatus(SpecialServiceRequestStatus.REJECTED);
            }
        }
    }

    private static SpecialServiceRequest findSsr(Segment s, DictionaryReference<SpecialServiceRequestDict> type) {
        for (SpecialServiceRequest ssr : s.getSsrs()) {
            if (!type.equals((Object)ssr.getType())) continue;
            return ssr;
        }
        return null;
    }
}

