/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sirena2000.ssrClientCode;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.gds.sirena2000.SirenaRequest;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.gds.sirena2000.IBusGdsSirenaContextKeys;
import com.gridnine.xtrip.server.gds.sirena2000.SirenaServerHelper;
import com.gridnine.xtrip.server.gds.sirena2000.model.BookingQuery;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;

public class BookingQueryAddSsrClientCodeProcessor
extends BaseProcessor {
    private static final String SSR_TYPE = "\u041f\u0420\u041e\u0427";
    private static final String SSR_TEXT_PREFIX = "\u0420\u041c\u0420\u041a\u041d\u041a";

    public void process(MessageContext ctx) throws Exception {
        SirenaRequest request = (SirenaRequest)ctx.getMandatoryObject((Enum)IBusGdsSirenaContextKeys.SIRENA_REQUEST);
        SalesContext salesContext = (SalesContext)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.SALES_CONTEXT);
        Organization client = this.getClient(salesContext);
        String clientCode = client.getCode();
        if (TextUtil.nonBlank((String)clientCode)) {
            BookingQuery query = (BookingQuery)request.getQuery();
            SirenaServerHelper.addSsrSectionIfMissing(query);
            BookingQuery.SpecialServices.Ssrs.Ssr ssr = this.buildSsr(clientCode);
            query.getSpecialServices().getSsrs().getSsrs().add(ssr);
        }
    }

    private Organization getClient(SalesContext salesContext) {
        EntityReference clientRef = salesContext.getClient();
        EntityContainer clientEtc = EntityStorage.get().resolve(clientRef);
        return (Organization)clientEtc.getEntity();
    }

    private BookingQuery.SpecialServices.Ssrs.Ssr buildSsr(String clientCode) {
        BookingQuery.SpecialServices.Ssrs.Ssr ssr = new BookingQuery.SpecialServices.Ssrs.Ssr();
        ssr.setType(SSR_TYPE);
        ssr.setText(SSR_TEXT_PREFIX + clientCode);
        return ssr;
    }
}

