/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sirena2000.storage;

import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.db.storage.model.BaseAssetData;
import com.gridnine.xtrip.server.gds.sirena2000.storage.SSLSessionEntryAsset;
import java.util.Date;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Lob;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.hibernate.annotations.Index;

@Entity
public class SSLSessionEntryAssetData
extends BaseAssetData<SSLSessionEntryAsset> {
    @Temporal(value=TemporalType.TIMESTAMP)
    @Index(name="SSLSessionEntryAssetData_modified")
    private Date modified;
    @Lob
    @Column(length=0x40000000)
    private byte[] clientKey;
    @Lob
    @Column(length=0x40000000)
    private byte[] serverKey;
    @Column(nullable=false)
    @Index(name="SSLSessionEntryAssetData_clientId")
    private String clientId;
    @Column(nullable=false)
    private int sessionId;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Index(name="SSLSessionEntryAssetData_expireDate")
    private Date expireDate;

    public Date getModified() {
        return this.modified;
    }

    public void setModified(Date date) {
        this.modified = date;
    }

    public SSLSessionEntryAsset toAsset(Set<String> preferredProperties) throws Exception {
        SSLSessionEntryAsset asset = new SSLSessionEntryAsset();
        asset.setUid(this.getUid());
        asset.setClientId(this.clientId);
        asset.setClientKey(this.clientKey);
        asset.setServerKey(this.serverKey);
        asset.setExpireDate(this.expireDate);
        asset.setModified(MiscUtil.cloneDate((Date)this.modified));
        asset.setSessionId(this.sessionId);
        return asset;
    }

    public void fromAsset(SSLSessionEntryAsset asset) throws Exception {
        this.setUid(asset.getUid());
        this.clientId = asset.getClientId();
        this.serverKey = asset.getServerKey();
        this.clientKey = asset.getClientKey();
        this.sessionId = asset.getSessionId();
        this.expireDate = asset.getExpireDate();
        this.modified = MiscUtil.cloneDate((Date)asset.getModified());
    }
}

