/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sirena2000.storage;

import com.gridnine.xtrip.common.model.BaseAsset;
import com.gridnine.xtrip.common.model.StorageException;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.search.SearchResult;
import com.gridnine.xtrip.server.db.storage.asset.LogicalAssetStorage;
import com.gridnine.xtrip.server.db.storage.common.LogicalSession;
import com.gridnine.xtrip.server.db.storage.common.LogicalStorageRegistry;
import com.gridnine.xtrip.server.db.storage.common.SessionsHelper;
import com.gridnine.xtrip.server.db.storage.model.PhysicalStorage;

public class SSLSessionEntryInfoAssetsStorage {
    private final LogicalAssetStorage assetStorage;
    private SessionsHelper sessionsHelper;

    public static SSLSessionEntryInfoAssetsStorage get() {
        return Holder.instance;
    }

    public void cancelUnitOfWork(LogicalSession s) {
        this.sessionsHelper.cancelUnitOfWork(s);
    }

    public LogicalSession beginUnitOfWork() {
        return this.sessionsHelper.beginUnitOfWork();
    }

    public void endUnitOfWork(LogicalSession s, boolean close) {
        this.sessionsHelper.endUnitOfWork(s, close);
    }

    private SSLSessionEntryInfoAssetsStorage() {
        LogicalStorageRegistry lsr = LogicalStorageRegistry.get();
        PhysicalStorage physicalStorage = lsr.getStorage("ssl-session-entry-info-storage");
        if (physicalStorage == null) {
            this.assetStorage = null;
            return;
        }
        try {
            physicalStorage.setupScheme(false);
        }
        catch (Exception e) {
            throw new StorageException((Throwable)e);
        }
        this.sessionsHelper = new SessionsHelper(physicalStorage);
        this.assetStorage = new LogicalAssetStorage(physicalStorage, this.sessionsHelper);
    }

    public boolean isAvailable() {
        return this.assetStorage != null;
    }

    public <A extends BaseAsset> void delete(A asset) throws StorageException {
        this.assetStorage.delete(asset, true);
    }

    public <A extends BaseAsset> A save(A asset) throws StorageException {
        this.assetStorage.save(asset, true);
        return asset;
    }

    public <A extends BaseAsset> SearchResult<A> search(Class<A> cls, SearchQuery query) throws StorageException {
        return this.assetStorage.search(cls, query);
    }

    private static final class Holder {
        public static SSLSessionEntryInfoAssetsStorage instance = new SSLSessionEntryInfoAssetsStorage();

        private Holder() {
        }
    }
}

