/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sirena2000.ticketAdditionalServices;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.gds.model.GDSParameters;
import com.gridnine.xtrip.common.gds.sirena2000.AbstractSirenaQuery;
import com.gridnine.xtrip.common.gds.sirena2000.SirenaHelper;
import com.gridnine.xtrip.common.gds.sirena2000.SirenaRequest;
import com.gridnine.xtrip.common.gds.sirena2000.model.SirenaGdsAccount;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.Fop;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.dict.MCOCategory;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.profile.Card;
import com.gridnine.xtrip.common.model.system.CardVendor;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.gds.sirena2000.IBusGdsSirenaContextKeys;
import com.gridnine.xtrip.server.gds.sirena2000.model.Regnum;
import com.gridnine.xtrip.server.gds.sirena2000.model.SvcEmdIssueConfirmQuery;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class AdditionalServicesTicketingConfirmRequestBuilder
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        Regnum regnum = (Regnum)ctx.getMandatoryObject((Enum)IBusGdsSirenaContextKeys.REGNUM);
        regnum.setVersion("ignore");
        Map.Entry additionalServices = (Map.Entry)ctx.getMandatoryObject((Enum)IBusGdsSirenaContextKeys.ADDITIONAL_SERVICES);
        Reservation reservation = (Reservation)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION);
        Fop fop = (Fop)ctx.getObject((Enum)IBusMidofficeContextKeys.FOP);
        EntityContainer accountCtr = (EntityContainer)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.GDS_ACCOUNT);
        GDSParameters gdsParameters = (GDSParameters)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.GDS_PARAMETERS);
        ctx.putObject((Enum)IBusGdsSirenaContextKeys.SIRENA_REQUEST, this.buildRequest(regnum, additionalServices, fop, (EntityContainer<SirenaGdsAccount>)accountCtr, gdsParameters, reservation));
    }

    private SirenaRequest<SvcEmdIssueConfirmQuery> buildRequest(Regnum regnum, Map.Entry<MCOCategory, Collection<Product>> additionalServices, Fop fop, EntityContainer<SirenaGdsAccount> accountCtr, GDSParameters gdsParameters, Reservation reservation) throws Exception {
        SirenaRequest request = new SirenaRequest();
        request.setQuery((AbstractSirenaQuery)this.buildQuery(regnum, additionalServices, fop, accountCtr, gdsParameters, reservation));
        request.setSecure(false);
        request.setPrivileged(false);
        return request;
    }

    private SvcEmdIssueConfirmQuery buildQuery(Regnum regnum, Map.Entry<MCOCategory, Collection<Product>> additionalServices, Fop fop, EntityContainer<SirenaGdsAccount> accountCtr, GDSParameters gdsParameters, Reservation reservation) throws Exception {
        SvcEmdIssueConfirmQuery query = new SvcEmdIssueConfirmQuery();
        Regnum queryRegnum = new Regnum();
        queryRegnum.setValue(regnum.getValue());
        queryRegnum.setVersion(regnum.getVersion());
        query.setRegnum(queryRegnum);
        if (fop != null) {
            SvcEmdIssueConfirmQuery.Paydoc paydoc;
            boolean hasCardNoVendor;
            boolean bl = hasCardNoVendor = fop.getCard() != null && fop.getCard().getVendor() == null;
            if (hasCardNoVendor) {
                ((SirenaGdsAccount)accountCtr.getEntity()).setFopCCreplacementCode("\u041f\u041f");
            }
            Object sirenaPaymentType = SirenaHelper.paymentType2str((SirenaGdsAccount)((SirenaGdsAccount)accountCtr.getEntity()), (PaymentType)fop.getType(), (boolean)SirenaHelper.isBsp((Reservation)reservation));
            if (!StringUtils.isBlank((String)gdsParameters.getFopReplacementCode())) {
                sirenaPaymentType = gdsParameters.getFopReplacementCode();
            }
            if ((paydoc = query.getPaydoc()) == null) {
                paydoc = new SvcEmdIssueConfirmQuery.Paydoc();
                query.setPaydoc(paydoc);
            }
            paydoc.setFormpay((String)sirenaPaymentType);
            Card card = fop.getCard();
            if (!"\u041f\u041f".equals(sirenaPaymentType) && card != null) {
                if (card.getVendor() != null) {
                    paydoc.setType(SirenaHelper.cardVendor2str((CardVendor)card.getVendor()));
                }
                if (!TextUtil.isBlank((String)card.getNumber())) {
                    paydoc.setNum(AdditionalServicesTicketingConfirmRequestBuilder.maskCardNumber(card.getVendor(), card.getNumber()));
                }
                if (card.getExpiration() != null) {
                    paydoc.setExpDate(new SimpleDateFormat("dd.MM.yy").format(card.getExpiration()));
                }
                paydoc.setHolder(card.getNameOnCard());
                paydoc.setAuthCode(card.getSecurityCode());
            } else if ("\u041f\u041a".equals(sirenaPaymentType)) {
                paydoc.setType(SirenaHelper.cardVendor2str((CardVendor)CardVendor.VISA));
            }
        }
        BigDecimal totalPrice = BigDecimal.ZERO;
        for (BaseProduct baseProduct : reservation.getProducts()) {
            Product product;
            if (!(baseProduct instanceof Product) || (product = (Product)baseProduct).getProductCategory() != ProductCategory.MCO || product.getMcoCategory() != additionalServices.getKey() || product.getStatus() != ProductStatus.BOOKING) continue;
            totalPrice = totalPrice.add(BookingHelper.calculateProductPrice((BaseProduct)product, (ContractType)ContractType.VENDOR).getTotal());
        }
        DecimalFormat df = new DecimalFormat("#0.00");
        DecimalFormatSymbols symbols = new DecimalFormatSymbols();
        symbols.setDecimalSeparator('.');
        df.setDecimalFormatSymbols(symbols);
        SvcEmdIssueConfirmQuery.Cost cost = new SvcEmdIssueConfirmQuery.Cost();
        cost.setValue(df.format(totalPrice));
        cost.setCurr(SirenaHelper.currency2native((String)DictHelper.getEquivCurrency()));
        query.setCost(cost);
        return query;
    }

    private static String maskCardNumber(CardVendor vendor, String number) {
        StringBuilder buf = new StringBuilder();
        block5: for (char ch : number.trim().toCharArray()) {
            if (Character.isDigit(ch)) {
                buf.append(ch);
                continue;
            }
            if (buf.length() > 0) {
                buf.append('0');
                continue;
            }
            switch (vendor) {
                case MASTERCARD: {
                    buf.append('5');
                    continue block5;
                }
                case VISA: {
                    buf.append('4');
                    continue block5;
                }
                case AMEX: {
                    buf.append('3');
                    continue block5;
                }
                default: {
                    buf.append('0');
                }
            }
        }
        return buf.toString();
    }
}

