/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sirena2000.ticketAdditionalServices;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.gds.model.GDSParameters;
import com.gridnine.xtrip.common.gds.sirena2000.AbstractSirenaQuery;
import com.gridnine.xtrip.common.gds.sirena2000.SirenaHelper;
import com.gridnine.xtrip.common.gds.sirena2000.SirenaRequest;
import com.gridnine.xtrip.common.gds.sirena2000.model.SirenaGdsAccount;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.booking.Fop;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.dict.MCOCategory;
import com.gridnine.xtrip.common.model.system.CardVendor;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.gds.sirena2000.IBusGdsSirenaContextKeys;
import com.gridnine.xtrip.server.gds.sirena2000.model.Regnum;
import com.gridnine.xtrip.server.gds.sirena2000.model.Svc;
import com.gridnine.xtrip.server.gds.sirena2000.model.SvcEmdIssueQueryQuery;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Collection;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class AdditionalServicesTicketingQueryRequestBuilder
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        Map.Entry additionalServices = (Map.Entry)ctx.getMandatoryObject((Enum)IBusGdsSirenaContextKeys.ADDITIONAL_SERVICES);
        Regnum regnum = (Regnum)ctx.getMandatoryObject((Enum)IBusGdsSirenaContextKeys.REGNUM);
        regnum.setVersion("ignore");
        Fop fop = (Fop)ctx.getObject((Enum)IBusMidofficeContextKeys.FOP);
        EntityContainer accountCtr = (EntityContainer)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.GDS_ACCOUNT);
        GDSParameters gdsParameters = (GDSParameters)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.GDS_PARAMETERS);
        Reservation reservation = (Reservation)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION);
        ctx.putObject((Enum)IBusGdsSirenaContextKeys.SIRENA_REQUEST, this.buildRequest(regnum, additionalServices, fop, (EntityContainer<SirenaGdsAccount>)accountCtr, gdsParameters, reservation));
    }

    private SirenaRequest<SvcEmdIssueQueryQuery> buildRequest(Regnum regnum, Map.Entry<MCOCategory, Collection<Product>> additionalServices, Fop fop, EntityContainer<SirenaGdsAccount> accountCtr, GDSParameters gdsParameters, Reservation reservation) {
        SirenaRequest request = new SirenaRequest();
        request.setQuery((AbstractSirenaQuery)this.buildQuery(regnum, additionalServices, fop, accountCtr, gdsParameters, reservation));
        request.setSecure(false);
        request.setPrivileged(false);
        return request;
    }

    private SvcEmdIssueQueryQuery buildQuery(Regnum regnum, Map.Entry<MCOCategory, Collection<Product>> additionalServices, Fop fop, EntityContainer<SirenaGdsAccount> accountCtr, GDSParameters gdsParameters, Reservation reservation) {
        SvcEmdIssueQueryQuery query = new SvcEmdIssueQueryQuery();
        Regnum queryRegnum = new Regnum();
        queryRegnum.setValue(regnum.getValue());
        queryRegnum.setVersion(regnum.getVersion());
        query.setRegnum(queryRegnum);
        MCOCategory mcoCategory = additionalServices.getKey();
        Collection<Product> mcoProducts = additionalServices.getValue();
        mcoProducts.forEach(mco -> {
            for (String gdsId : mco.getGdsId().split(",")) {
                Svc svc = new Svc();
                svc.setId(gdsId);
                query.getSvc().add(svc);
            }
        });
        if (fop != null) {
            boolean hasNoCardVendor;
            boolean bl = hasNoCardVendor = fop.getCard() != null && fop.getCard().getVendor() == null;
            if (hasNoCardVendor) {
                ((SirenaGdsAccount)accountCtr.getEntity()).setFopCCreplacementCode("\u041f\u041a");
            }
            String sirenaPaymentType = SirenaHelper.paymentType2str((SirenaGdsAccount)((SirenaGdsAccount)accountCtr.getEntity()), (PaymentType)fop.getType(), (boolean)SirenaHelper.isBsp((Reservation)reservation));
            if (!StringUtils.isBlank((String)gdsParameters.getFopReplacementCode())) {
                sirenaPaymentType = gdsParameters.getFopReplacementCode();
            }
            SvcEmdIssueQueryQuery.Paydoc paydoc = new SvcEmdIssueQueryQuery.Paydoc();
            paydoc.setFormpay(sirenaPaymentType);
            if (!"\u041f\u041f".equals(sirenaPaymentType) && fop.getCard() != null && fop.getCard().getVendor() != null) {
                paydoc.setType(SirenaHelper.cardVendor2str((CardVendor)fop.getCard().getVendor()));
            } else if ("\u041f\u041a".equals(sirenaPaymentType)) {
                paydoc.setType(SirenaHelper.cardVendor2str((CardVendor)CardVendor.VISA));
            }
            query.setPaydoc(paydoc);
        }
        return query;
    }
}

