/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sirena2000.ticketAdditionalServices;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.gds.helper.GDSHelper;
import com.gridnine.xtrip.server.gds.sirena2000.IBusGdsSirenaContextKeys;
import com.gridnine.xtrip.server.gds.sirena2000.model.PnrStatusAnswer;
import com.gridnine.xtrip.server.gds.sirena2000.model.Svc;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

public class CheckAdditionalServicesStatusProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        PnrStatusAnswer answer = (PnrStatusAnswer)ctx.getMandatoryObject((Enum)IBusGdsSirenaContextKeys.SIRENA_ANSWER);
        Reservation reservation = (Reservation)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION);
        List mcoProducts = GDSHelper.getMcoProductsStream((Collection)reservation.getProducts()).filter(p -> p.getStatus() == ProductStatus.BOOKING).collect(Collectors.toList());
        if (mcoProducts.isEmpty()) {
            return;
        }
        List<Svc> svcs = answer.getSvcs().getSvcs();
        List svcIds = svcs.stream().map(svc -> svc.getId()).collect(Collectors.toList());
        String[] mcoGdsIds = mcoProducts.stream().map(mco -> mco.getGdsId()).collect(Collectors.joining(",")).split(",");
        for (String gdsId : mcoGdsIds) {
            if (svcIds.contains(gdsId)) continue;
            throw Xeption.forDeveloper((String)"Status error: there are some mcoGdsId which absent in svc answer", (Object[])new Object[0]);
        }
        if (svcIds.size() != mcoGdsIds.length) {
            throw Xeption.forDeveloper((String)"Status error: there are some mcoGdsId which absent in svc answer", (Object[])new Object[0]);
        }
        for (Svc svc2 : svcs) {
            if (!TextUtil.isBlank((String)svc2.getStatus()) && svc2.getStatus().equals("HD")) continue;
            throw Xeption.forEndUser((String)"\u041e\u043f\u0435\u0440\u0430\u0446\u0438\u044f \u043d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u0430, \u0442\u0430\u043a \u043a\u0430\u043a \u0443\u0441\u043b\u0443\u0433\u0430 \u043d\u0435 \u043f\u043e\u0434\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u0430. \u041d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u043e \u043e\u0431\u0440\u0430\u0442\u0438\u0442\u044c\u0441\u044f \u0432 \u043a\u043e\u043b\u043b-\u0446\u0435\u043d\u0442\u0440 \u0437\u0430 \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u043e\u0439 \u0441\u0442\u0430\u0442\u0443\u0441\u0430 \u0443\u0441\u043b\u0443\u0433\u0438", (Object[])new Object[0]);
        }
    }
}

