/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sirena2000.ticketInfo;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.air.Commission;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.commission.CalculationType;
import com.gridnine.xtrip.common.model.booking.commission.FeeProperties;
import com.gridnine.xtrip.common.model.booking.commission.FeeType;
import com.gridnine.xtrip.common.model.booking.commission.Operation;
import com.gridnine.xtrip.common.model.booking.commission.ProductType;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.server.ibus.components.BaseAdvice;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class CorrectFeesOnSplitAdvice
extends BaseAdvice {
    private static final String STATE_KEY = CorrectFeesOnSplitAdvice.class.getName() + ".state";
    private static String FEE_CORRECTION_SPLIT_PROPERTIES = "ff66a18c-6959-11e3-acaa-d231feb1dc81";

    public void before(MessageContext ctx) throws Exception {
        Reservation reservation = (Reservation)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION);
        State state = new State(reservation);
        ctx.putObject(STATE_KEY, (Object)state);
    }

    public void after(MessageContext ctx) throws Exception {
        Reservation reservation = (Reservation)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION);
        State oldState = (State)ctx.getMandatoryObject(STATE_KEY);
        State newState = new State(reservation);
        if (newState.getProductCount() > oldState.getProductCount()) {
            int productsCount = reservation.getProducts().size();
            BigDecimal totalClientFeeDelta = newState.getFees().get(ContractType.CLIENT).subtract(oldState.getFees().get(ContractType.CLIENT));
            BigDecimal perProductClientFeeDelta = totalClientFeeDelta.divide(BigDecimal.valueOf(productsCount), 2, RoundingMode.DOWN);
            BigDecimal totalSubagentFeeDelta = newState.getFees().get(ContractType.SUBAGENCY).subtract(oldState.getFees().get(ContractType.SUBAGENCY));
            BigDecimal perProductSubagentFeeDelta = totalSubagentFeeDelta.divide(BigDecimal.valueOf(productsCount), 2, RoundingMode.DOWN);
            BigDecimal totalVendorFeeDelta = newState.getFees().get(ContractType.VENDOR).subtract(oldState.getFees().get(ContractType.VENDOR));
            BigDecimal perProductVendorFeeDelta = totalVendorFeeDelta.divide(BigDecimal.valueOf(productsCount), 2, RoundingMode.DOWN);
            EntityContainer<FeeProperties> feePropsCtr = this.getFeeProperties();
            Iterator iter = reservation.getProducts().iterator();
            while (iter.hasNext()) {
                BigDecimal value;
                Product p = (Product)iter.next();
                Commission comm = null;
                if (!totalClientFeeDelta.equals(BigDecimal.ZERO)) {
                    value = iter.hasNext() ? perProductClientFeeDelta : totalClientFeeDelta.subtract(perProductClientFeeDelta.multiply(BigDecimal.valueOf(productsCount - 1)));
                    comm = new Commission();
                    comm.setContractType(ContractType.CLIENT);
                    comm.setEquivalentAmount(value.negate());
                    comm.setCommissionProperties(feePropsCtr.toReference());
                    AirProductHelper.getClientContractRelation((Product)p).getCommissions().add(comm);
                }
                if (!totalVendorFeeDelta.equals(BigDecimal.ZERO)) {
                    value = iter.hasNext() ? perProductVendorFeeDelta : totalVendorFeeDelta.subtract(perProductVendorFeeDelta.multiply(BigDecimal.valueOf(productsCount - 1)));
                    comm = new Commission();
                    comm.setContractType(ContractType.VENDOR);
                    comm.setEquivalentAmount(value.negate());
                    comm.setCommissionProperties(feePropsCtr.toReference());
                    AirProductHelper.getVendorContractRelation((Product)p).getCommissions().add(comm);
                }
                if (totalSubagentFeeDelta.equals(BigDecimal.ZERO)) continue;
                value = iter.hasNext() ? perProductSubagentFeeDelta : totalSubagentFeeDelta.subtract(perProductSubagentFeeDelta.multiply(BigDecimal.valueOf(productsCount - 1)));
                comm = new Commission();
                comm.setContractType(ContractType.SUBAGENCY);
                comm.setEquivalentAmount(value.negate());
                comm.setCommissionProperties(feePropsCtr.toReference());
                AirProductHelper.getSubagentContractRelation((Product)p, (boolean)true).getCommissions().add(comm);
            }
        }
    }

    private EntityContainer<FeeProperties> getFeeProperties() {
        try {
            String uid = FEE_CORRECTION_SPLIT_PROPERTIES;
            EntityStorage entityCache = EntityStorage.get();
            EntityContainer ctr = entityCache.resolve(new EntityReference(uid, FeeProperties.class, null));
            if (ctr != null) {
                return ctr;
            }
            ctr = new EntityContainer(FeeProperties.class, uid);
            ((FeeProperties)ctr.getEntity()).setDisplayName("\u041a\u043e\u0440\u0440\u0435\u043a\u0442\u0438\u0440\u0443\u044e\u0449\u0438\u0439 \u0441\u0431\u043e\u0440 (\u0441\u043f\u043b\u0438\u0442)");
            ((FeeProperties)ctr.getEntity()).setType(FeeType.MANUALLY_CALCULATED);
            ((FeeProperties)ctr.getEntity()).setOperation(Operation.SELL);
            ((FeeProperties)ctr.getEntity()).setCalculationType(CalculationType.TICKET);
            ((FeeProperties)ctr.getEntity()).getProductTypes().addAll(Arrays.asList(ProductType.AIR_TICKET));
            return EntityStorage.get().save(ctr, true);
        }
        catch (Exception ex) {
            this.log.error("getFeeProperties failed", (Throwable)ex);
            return null;
        }
    }

    static class State {
        private final int productCount;
        private final Map<ContractType, BigDecimal> fees;

        State(Reservation reservation) {
            this.productCount = reservation.getProducts().size();
            this.fees = new HashMap<ContractType, BigDecimal>();
            BigDecimal clientFee = BigDecimal.ZERO;
            BigDecimal subagentFee = BigDecimal.ZERO;
            BigDecimal vendorFee = BigDecimal.ZERO;
            for (BaseProduct bp : reservation.getProducts()) {
                Product p = (Product)bp;
                clientFee = clientFee.add(GeneralProductHelper.calculateCommissions((BaseProduct)p, (ContractType)ContractType.CLIENT, (Set)GeneralProductHelper.feePropertyTypes));
                subagentFee = subagentFee.add(GeneralProductHelper.calculateCommissions((BaseProduct)p, (ContractType)ContractType.SUBAGENCY, (Set)GeneralProductHelper.feePropertyTypes));
                vendorFee = vendorFee.add(GeneralProductHelper.calculateCommissions((BaseProduct)p, (ContractType)ContractType.VENDOR, (Set)GeneralProductHelper.feePropertyTypes));
            }
            this.fees.put(ContractType.CLIENT, clientFee);
            this.fees.put(ContractType.SUBAGENCY, subagentFee);
            this.fees.put(ContractType.VENDOR, vendorFee);
        }

        int getProductCount() {
            return this.productCount;
        }

        Map<ContractType, BigDecimal> getFees() {
            return this.fees;
        }
    }
}

