/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sirena2000.ticketInfo;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.midoffice.helper.SalesContextHelper;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.NestedEntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.BlankType;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.CurrencyInfo;
import com.gridnine.xtrip.common.model.dict.CurrencyInfoReference;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.MoneyHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.profile.SalesPoint;
import com.gridnine.xtrip.common.model.profile.Validator;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.util.Streams;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.gds.helper.GDSHelper;
import com.gridnine.xtrip.server.gds.sirena2000.IBusGdsSirenaContextKeys;
import com.gridnine.xtrip.server.gds.sirena2000.model.PaymentExtAuthAnswer;
import com.gridnine.xtrip.server.gds.sirena2000.model.SirenaModelHelper;
import com.gridnine.xtrip.server.gds.sirena2000.model.Tickinfo;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.model.helpers.ProfileDao;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class TickinfoProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        Collection tickinfos = (Collection)ctx.getMandatoryObject((Enum)IBusGdsSirenaContextKeys.TICKINFOS);
        PaymentExtAuthAnswer.AgentComission agentComission = (PaymentExtAuthAnswer.AgentComission)ctx.getObject((Enum)IBusGdsSirenaContextKeys.AGENT_COMISSION);
        String pult = (String)ctx.getMandatoryObject((Enum)IBusGdsSirenaContextKeys.SIRENA_ANSWER_PULT);
        Tickinfo tickinfo = (Tickinfo)tickinfos.iterator().next();
        Reservation reservation = (Reservation)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION);
        Product ticket = this.findProduct(reservation, tickinfos);
        if (ticket == null) {
            ctx.addMessage(SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)"\u043f\u0440\u0438 \u043e\u0444\u043e\u0440\u043c\u043b\u0435\u043d\u0438\u0438 \u0431\u0438\u043b\u0435\u0442\u043e\u0432 \u0432 \u0441\u0438\u0441\u0442\u0435\u043c\u0435 \u0431\u0440\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u044b \u0434\u0430\u043d\u043d\u044b\u0435 \u0431\u0438\u043b\u0435\u0442\u0430 \u0441 \u043d\u043e\u043c\u0435\u0440\u043e\u043c {0}", (Object[])new Object[]{tickinfo.getTicknum()}));
            return;
        }
        ArrayList tickInfosStr = new ArrayList(tickinfos.size());
        tickinfos.stream().map(Tickinfo::toString).forEach(tickInfosStr::add);
        this.logDebug(ctx, reservation.getBookingFile().getNumber(), new Object[]{tickInfosStr, ticket.getSystemNumber()});
        this.updateTicket(ticket, agentComission, tickinfo, ctx, pult);
    }

    private void updateTicket(Product ticket, PaymentExtAuthAnswer.AgentComission agentComission, Tickinfo tickinfo, MessageContext ctx, String pult) {
        PaymentExtAuthAnswer.AgentComission.Comission comission;
        BlankType blankType;
        ticket.setStatus(ProductStatus.SELL);
        if (ticket.getIssueDate() == null) {
            ticket.setIssueDate(new Date());
        }
        ticket.setSystemNumber(tickinfo.getTicknum().substring(3));
        ticket.setCarrierNumber(tickinfo.getAccode());
        ticket.setPcc(pult.substring(0, 4));
        Airline carrier = DictHelper.findAirlineByAnyCode((String)ticket.getCarrierNumber());
        if (carrier != null) {
            ticket.setCarrier((DictionaryReference)carrier.toReference());
        }
        ticket.setEticket(tickinfo.getIsEtick().booleanValue());
        if (ticket.getBlankOwnerRef() != null && (blankType = BookingHelper.getBlankType((String)ticket.getSystemNumber(), (EntityReference)ticket.getBlankOwnerRef(), (ProductCategory)ProductCategory.AIR, (boolean)ticket.isEticket())) != null) {
            ticket.setBlankType((DictionaryReference)blankType.toReference());
        }
        if (ticket.getSalesPoint() == null) {
            try {
                List salespoints = ProfileDao.getSalesPointsByValidatorAndPcc(null, (String)ticket.getPcc());
                if (!salespoints.isEmpty()) {
                    EntityContainer ctr = (EntityContainer)salespoints.get(0);
                    ticket.setSalesPoint(ctr.toReference());
                    AirProductHelper.setSubagency((Product)ticket, (EntityReference)SalesContextHelper.getOnlineAgency((SalesPoint)((SalesPoint)ctr.getEntity())));
                    if (TextUtil.isBlank((String)ticket.getValidatorCode()) && !((SalesPoint)ctr.getEntity()).getValidators().isEmpty()) {
                        Validator validator = (Validator)((SalesPoint)ctr.getEntity()).getValidators().get(0);
                        ticket.setValidatorCode(validator.getNumber());
                        ticket.setValidatorRef(new NestedEntityReference(((EntityContainer)salespoints.get(0)).toReference(), validator.getUid(), Validator.class, validator.toString()));
                        AirProductHelper.setSupplier((Product)ticket, (EntityReference)validator.getSupplier());
                        AirProductHelper.setAgency((Product)ticket, (EntityReference)validator.getAgency());
                    }
                } else {
                    ctx.addMessage(SystemHelper.createMessage((MessageType)MessageType.WARNING, (String)"\u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430 \u0442\u043e\u0447\u043a\u0430 \u043f\u0440\u043e\u0434\u0430\u0436 \u0434\u043b\u044f \u0431\u0438\u043b\u0435\u0442\u0430 {0}", (Object[])new Object[]{ticket.getSystemNumber()}));
                }
            }
            catch (Exception e) {
                this.log.error("failed detecting validator for ticket " + ticket.getSystemNumber(), (Throwable)e);
                ctx.addMessage(SystemHelper.createMessage((MessageType)MessageType.WARNING, (String)"\u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0435\u043d\u0438\u0438 \u0432\u0430\u043b\u0438\u0434\u0430\u0442\u043e\u0440\u0430 \u0434\u043b\u044f \u0431\u0438\u043b\u0435\u0442\u0430 {0}", (Throwable)e, (Object[])new Object[]{ticket.getSystemNumber()}));
            }
        }
        if (agentComission != null && agentComission.getComissions() != null && (comission = (PaymentExtAuthAnswer.AgentComission.Comission)Streams.singleOrNull(agentComission.getComissions().stream().filter(c -> tickinfo.getTicknum().equals(c.getTicknum())))) != null) {
            if (comission.getPercent() != null) {
                BigDecimal bspCommissionValue;
                double bspCommissionRate = Double.parseDouble(comission.getPercent());
                ticket.setBspCommissionRate(Double.valueOf(bspCommissionRate));
                BigDecimal equivalentFare = AirProductHelper.getEquivalentFare((Product)ticket);
                if (equivalentFare != null) {
                    int scale = TickinfoProcessor.getDecimalPlaces(ticket.getGdsCurrency(), 2);
                    bspCommissionValue = equivalentFare.multiply(BigDecimal.valueOf(bspCommissionRate)).divide(BigDecimal.valueOf(100L), scale, RoundingMode.HALF_UP);
                } else {
                    bspCommissionValue = BigDecimal.ZERO;
                }
                ticket.setBspCommissionValue(MoneyHelper.buildMoney((BigDecimal)bspCommissionValue, (String)ticket.getGdsCurrency()));
            } else if (comission.getSum() != null) {
                BigDecimal bspCommissionValue = new BigDecimal(comission.getSum());
                ticket.setBspCommissionValue(MoneyHelper.buildMoney((BigDecimal)bspCommissionValue, (String)ticket.getGdsCurrency()));
            }
        }
    }

    private static Integer getDecimalPlaces(String currencyCode, Integer defaultValue) {
        if ("RUB".equals(currencyCode)) {
            return 2;
        }
        CurrencyInfo curInfo = (CurrencyInfo)DictionaryCache.get().resolveReference((DictionaryReference)new CurrencyInfoReference(currencyCode));
        if (curInfo != null && curInfo.getIataDecimalPlaces() != null) {
            return curInfo.getIataDecimalPlaces();
        }
        return defaultValue;
    }

    private Product findProduct(Reservation reservation, Collection<Tickinfo> tickinfos) {
        if (tickinfos.stream().anyMatch(tickinfo -> TextUtil.nonBlank((String)tickinfo.getSvcId()))) {
            String svcGdsId = "";
            for (Tickinfo tickinfo2 : tickinfos) {
                svcGdsId = TextUtil.isBlank((String)svcGdsId) ? tickinfo2.getSvcId() : svcGdsId + "," + tickinfo2.getSvcId();
            }
            Product productByGdsId = null;
            for (Product product : GDSHelper.getMcoProducts((Reservation)reservation)) {
                if (!svcGdsId.equals(product.getGdsId())) continue;
                productByGdsId = product;
                break;
            }
            if (productByGdsId == null) {
                throw Xeption.forDeveloper((String)"No one mco product was found", (Object[])new Object[0]);
            }
            return productByGdsId;
        }
        return SirenaModelHelper.findProduct(reservation, tickinfos);
    }
}

