/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sirena2000.ticketReservation;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.system.ContentType;
import com.gridnine.xtrip.common.model.system.Document;
import com.gridnine.xtrip.common.model.system.DocumentType;
import com.gridnine.xtrip.common.util.Base64;
import com.gridnine.xtrip.server.gds.helper.GDSHelper;
import com.gridnine.xtrip.server.gds.sirena2000.IBusGdsSirenaContextKeys;
import com.gridnine.xtrip.server.gds.sirena2000.model.GetItinReceiptsAnswer;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;

public class GetItinReceiptsAnswerParser
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        Reservation reservation = (Reservation)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION);
        EntityContainer bfCtr = (EntityContainer)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.BOOKING_FILE);
        GetItinReceiptsAnswer answer = (GetItinReceiptsAnswer)ctx.getMandatoryObject((Enum)IBusGdsSirenaContextKeys.SIRENA_ANSWER);
        byte[] pdfContent = Base64.decode((String)answer.getReceipts());
        Document doc = new Document();
        doc.setType(DocumentType.SPECIAL_TRAVELDOCUMENT);
        doc.setContent(pdfContent);
        doc.setContentType(ContentType.PDF);
        doc.setCreated(new Date());
        boolean isSeveralTravellers = ((BookingFile)bfCtr.getEntity()).getTravellers().size() > 1;
        boolean isContainingEMD = GDSHelper.getMcoProductsStream((Collection)reservation.getProducts()).findAny().isPresent();
        this.setNameAndTitle(doc, isSeveralTravellers, isContainingEMD);
        doc.setNavigationKey(reservation.getUid());
        doc.setOwner(bfCtr.toReference());
        HashSet<Document> documents = (HashSet<Document>)ctx.getObject((Enum)IBusMidofficeContextKeys.BOOKING_FILE_DOCUMENTS);
        if (documents == null) {
            documents = new HashSet<Document>();
            ctx.putObject((Enum)IBusMidofficeContextKeys.BOOKING_FILE_DOCUMENTS, documents);
        }
        documents.add(doc);
    }

    private void setNameAndTitle(Document doc, boolean isSeveralTravellers, boolean isContainingEMD) {
        String travelDoc = "\u041c\u0430\u0440\u0448\u0440\u0443\u0442\u043d\u0430\u044f \u043a\u0432\u0438\u0442\u0430\u043d\u0446\u0438\u044f";
        String travelDocs = "\u041c\u0430\u0440\u0448\u0440\u0443\u0442\u043d\u044b\u0435 \u043a\u0432\u0438\u0442\u0430\u043d\u0446\u0438\u0438";
        String emd = " \u0438 \u042d\u041c\u0414";
        String forAllPassengers = " \u0434\u043b\u044f \u0432\u0441\u0435\u0445 \u043f\u0430\u0441\u0441\u0430\u0436\u0438\u0440\u043e\u0432";
        String pdf = ".pdf";
        if (isSeveralTravellers) {
            if (isContainingEMD) {
                doc.setTitle(travelDocs + emd + forAllPassengers + pdf);
                doc.setName(travelDocs + emd + forAllPassengers + pdf);
            } else {
                doc.setTitle(travelDocs + forAllPassengers + pdf);
                doc.setName(travelDocs + forAllPassengers + pdf);
            }
        } else if (isContainingEMD) {
            doc.setTitle(travelDoc + emd + pdf);
            doc.setName(travelDoc + emd + pdf);
        } else {
            doc.setTitle(travelDoc + pdf);
            doc.setName(travelDoc + pdf);
        }
    }
}

