/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sirena2000.voidAncillaryFees;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.gds.sirena2000.AbstractSirenaQuery;
import com.gridnine.xtrip.common.gds.sirena2000.SirenaRequest;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.server.gds.sirena2000.IBusGdsSirenaContextKeys;
import com.gridnine.xtrip.server.gds.sirena2000.model.OrderAnswer;
import com.gridnine.xtrip.server.gds.sirena2000.model.Regnum;
import com.gridnine.xtrip.server.gds.sirena2000.model.Svc;
import com.gridnine.xtrip.server.gds.sirena2000.model.SvcEmdVoidQuery;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Arrays;
import java.util.Collection;

public class SvcEmdVoidRequestBuilder
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        OrderAnswer answer = (OrderAnswer)ctx.getMandatoryObject((Enum)IBusGdsSirenaContextKeys.SIRENA_ANSWER);
        Collection products = (Collection)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.BASE_PRODUCTS);
        ctx.putObject((Enum)IBusGdsSirenaContextKeys.SIRENA_REQUEST, this.buildRequest(answer, products));
    }

    private SirenaRequest<SvcEmdVoidQuery> buildRequest(OrderAnswer answer, Collection<Product> products) {
        SirenaRequest request = new SirenaRequest();
        request.setQuery((AbstractSirenaQuery)this.buildQuery(answer, products));
        request.setPrivileged(false);
        request.setSecure(false);
        return request;
    }

    private SvcEmdVoidQuery buildQuery(OrderAnswer orderAnswer, Collection<Product> products) {
        String[] gdsIds;
        SvcEmdVoidQuery query = new SvcEmdVoidQuery();
        Regnum regnum = new Regnum();
        regnum.setValue(orderAnswer.getPnr().getRegnum());
        regnum.setVersion(orderAnswer.getPnr().getVersion());
        query.setRegnum(regnum);
        for (String id : gdsIds = (String[])products.stream().map(Product::getGdsId).flatMap(ids -> Arrays.stream(ids.split(","))).toArray(String[]::new)) {
            Svc svc = new Svc();
            svc.setId(id);
            query.getSvc().add(svc);
        }
        return query;
    }
}

