/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.hotels2;

import com.gridnine.xtrip.common.hotels2.model.HotelsAggregatorGdsAccount;
import com.gridnine.xtrip.common.meta.MetaRegistry;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProduct;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.BookingStreamHelper;
import com.gridnine.xtrip.common.model.helpers.HotelProductHelper;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.XSerializable;
import com.gridnine.xtrip.common.xml.XUtil;
import com.gridnine.xtrip.server.gds.test.GDSTestBase;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.URLDecoder;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.Unmarshaller;

public class HotelsTestBase
extends GDSTestBase {
    protected void configureMetaregistry(MetaRegistry metaRegistry) throws Exception {
        super.configureMetaregistry(metaRegistry);
        this.registerModel(metaRegistry, "com/gridnine/xtrip/common/hotels2/model-basic-hotels2.xml");
        this.registerModel(metaRegistry, "com/gridnine/xtrip/common/hotels2/model-hotels2.xml");
    }

    protected void writeResult(List<? extends XSerializable> objects, String fileName) throws Exception {
        String path = ((Object)((Object)this)).getClass().getResource("").getPath().replace("/classes/", "/source-test/");
        path = URLDecoder.decode(path, "utf-8");
        File file = new File(path + fileName);
        try (FileOutputStream fos = new FileOutputStream(file);){
            XUtil.serialize(objects, (OutputStream)fos);
        }
    }

    protected void writeResult(XSerializable object, String fileName) throws Exception {
        String path = ((Object)((Object)this)).getClass().getResource("").getPath().replace("/classes/", "/source-test/");
        path = URLDecoder.decode(path, "utf-8");
        File file = new File(path + fileName);
        try (FileOutputStream fos = new FileOutputStream(file);){
            XUtil.serialize((XSerializable)object, (OutputStream)fos);
        }
    }

    protected <T> T getResponseFromFile(String fileName, Class<T> responseClass) throws Exception {
        JAXBContext jaxbContext = JAXBContext.newInstance((String)responseClass.getPackage().getName());
        Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
        InputStreamReader rdr = new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream(fileName));
        return (T)((JAXBElement)unmarshaller.unmarshal((Reader)rdr)).getValue();
    }

    protected EntityContainer<HotelsAggregatorGdsAccount> createGdsAccount() {
        return this.createGdsAccount(null);
    }

    protected EntityContainer<HotelsAggregatorGdsAccount> createGdsAccount(String gdsAccountCtrUid) {
        HotelsAggregatorGdsAccount account = new HotelsAggregatorGdsAccount();
        account.setGds(GdsName.HOTEL_AGGREGATOR);
        EntityContainer result = EntityContainer.create((BaseEntity)account);
        result.setUid((String)MiscUtil.guarded((Object)gdsAccountCtrUid, (Object)"HotelsAggregatorGdsAccount-UID"));
        EntityStorage.get().save(result, false);
        return result;
    }

    protected SalesContext createSalesContext() {
        SalesContext result = new SalesContext();
        return result;
    }

    protected void clearSomeFields(BookingFile booking) {
        booking.getReservations().forEach(this::clearSomeFields);
    }

    protected void clearSomeFields(Reservation reservation) {
        reservation.setResDate(null);
        BookingStreamHelper.getProductsStream((Reservation)reservation, HotelProduct.class).forEach(hp -> {
            HotelProductHelper.getContractRelations((HotelProduct)hp).clear();
            hp.getTravellersPassengerTypes().forEach(tpt -> tpt.setTravellerUid(null));
            hp.getRooms().forEach(r -> r.getRoomTravellersUids().clear());
            if (hp.getStatus() == ProductStatus.REFUND) {
                hp.setIssueDate(null);
            }
        });
    }
}

