/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.hotels2.ibus;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.hotels.web.ws.AuthMethod;
import com.gridnine.hotels.web.ws.HotelsCredentials;
import com.gridnine.hotels.web.ws.InvocationContext;
import com.gridnine.hotels.web.ws.ReservationsWebServiceService;
import com.gridnine.xtrip.common.hotels2.HotelAggregatorSettings;
import com.gridnine.xtrip.common.hotels2.model.HotelsAggregatorGdsAccount;
import com.gridnine.xtrip.common.l10n.model.LocaleManager;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.util.DesUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.hotels2.ibus.HotelsAggregatorRequestData;
import com.gridnine.xtrip.server.hotels2.ibus.IBusHotelsContextKeys;
import com.gridnine.xtrip.server.hotels2.ibus.helpers.HotelsHelper;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.jaxws.IBusWsContextKeys;
import com.gridnine.xtrip.server.jaxws.WsRequest;

public class HotelsAggregatorWsRequestBuilder
extends BaseProcessor {
    private static final String ALLOWED = "allowed";
    private static final String DENIED = "denied";
    private static final String RESTRICTED = "restricted";

    public void process(MessageContext ctx) throws Exception {
        EntityContainer<HotelAggregatorSettings> settingsCtr = (EntityContainer<HotelAggregatorSettings>)ctx.getObject((Enum)IBusHotelsContextKeys.HOTELS_AGGREGATOR_SETTINGS);
        if (settingsCtr == null) {
            settingsCtr = HotelsHelper.getHotelAggregatorSettings();
        }
        HotelAggregatorSettings settings = (HotelAggregatorSettings)settingsCtr.getEntity();
        this.checkSettings(settings);
        EntityContainer accountCtr = (EntityContainer)ctx.getObject((Enum)IBusMidofficeContextKeys.GDS_ACCOUNT);
        HotelsAggregatorRequestData requestData = (HotelsAggregatorRequestData)ctx.getMandatoryObject((Enum)IBusHotelsContextKeys.HOTELS_AGGREGATOR_REQUEST_DATA);
        this.setAuthData(requestData, settings, (EntityContainer<HotelsAggregatorGdsAccount>)accountCtr);
        WsRequest request = new WsRequest();
        request.setEndpointAddress(settings.getUrl());
        requestData.getRequest().forEach(arg_0 -> ((WsRequest)request).setPayload(arg_0));
        request.setServiceClass(ReservationsWebServiceService.class);
        request.setMethodName(requestData.getMethod());
        if (settings.getRequestTimeout() != null) {
            request.setRequestTimeout(settings.getRequestTimeout());
        }
        ctx.putObject((Enum)IBusWsContextKeys.WS_REQUEST, (Object)request);
    }

    private void checkSettings(HotelAggregatorSettings settings) {
        if (!settings.isEnabled()) {
            throw Xeption.forAdmin((String)"\u041e\u0442\u0435\u043b\u044c\u043d\u044b\u0439 \u0430\u0433\u0440\u0435\u0433\u0430\u0442\u043e\u0440 \u043e\u0442\u043a\u043b\u044e\u0447\u0435\u043d (\u0441\u043c. \u041d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0438 \u043e\u0442\u0435\u043b\u044c\u043d\u043e\u0433\u043e \u0430\u0433\u0440\u0435\u0433\u0430\u0442\u043e\u0440\u0430)", (Object[])new Object[0]);
        }
        if (TextUtil.isBlank((String)settings.getUrl())) {
            throw Xeption.forAdmin((String)"\u0412 \u043d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0430\u0445 \u043e\u0442\u0435\u043b\u044c\u043d\u043e\u0433\u043e \u0430\u0433\u0440\u0435\u0433\u0430\u0442\u043e\u0440\u0430 \u043d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d Url", (Object[])new Object[0]);
        }
        if (TextUtil.isBlank((String)settings.getUser())) {
            throw Xeption.forAdmin((String)"\u0412 \u043d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0430\u0445 \u043e\u0442\u0435\u043b\u044c\u043d\u043e\u0433\u043e \u0430\u0433\u0440\u0435\u0433\u0430\u0442\u043e\u0440\u0430 \u043d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c", (Object[])new Object[0]);
        }
        if (TextUtil.isBlank((String)settings.getPassword())) {
            throw Xeption.forAdmin((String)"\u0412 \u043d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0430\u0445 \u043e\u0442\u0435\u043b\u044c\u043d\u043e\u0433\u043e \u0430\u0433\u0440\u0435\u0433\u0430\u0442\u043e\u0440\u0430 \u043d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d \u043f\u0430\u0440\u043e\u043b\u044c", (Object[])new Object[0]);
        }
    }

    private void setAuthData(HotelsAggregatorRequestData requestData, HotelAggregatorSettings settings, EntityContainer<HotelsAggregatorGdsAccount> accountCtr) throws Exception {
        if (requestData.getHotelsRequest() != null) {
            requestData.getHotelsRequest().setCredentials(this.buildCredentials(settings));
            return;
        }
        InvocationContext invocationContext = requestData.getInvocationContext();
        if (invocationContext != null) {
            invocationContext.setLoginName(settings.getUser());
            invocationContext.setPassword(settings.getPassword());
            if (TextUtil.nonBlank((String)settings.getSecret())) {
                invocationContext.setAuthMethod(AuthMethod.V_0);
                invocationContext.setAuthToken(this.buildAuthToken(settings));
            }
            invocationContext.setLocale(LocaleManager.get().getCurrentLocale().toString());
            if (accountCtr != null) {
                invocationContext.setPcc(((HotelsAggregatorGdsAccount)accountCtr.getEntity()).getPcc());
            }
        }
    }

    private HotelsCredentials buildCredentials(HotelAggregatorSettings settings) {
        HotelsCredentials result = new HotelsCredentials();
        result.setLogin(settings.getUser());
        result.setPassword(settings.getPassword());
        return result;
    }

    private String buildAuthToken(HotelAggregatorSettings settings) throws Exception {
        String accessLevel = ALLOWED;
        char[] psw = settings.getSecret().toCharArray();
        String str = System.currentTimeMillis() + ";" + settings.getUser() + ";" + accessLevel;
        String result = DesUtil.encrypt((char[])psw, (String)str);
        return result;
    }
}

