/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.hotels2.ibus;

import com.gridnine.hotels.web.ws.GetHotelFolderInfoResponse;
import com.gridnine.hotels.web.ws.HotelsResponse;
import com.gridnine.hotels.web.ws.Message;
import com.gridnine.hotels.web.ws.PricingItem;
import com.gridnine.hotels.web.ws.PricingResult;
import com.gridnine.hotels.web.ws.PricingResultItem;
import com.gridnine.hotels.web.ws.ReservationPricing;
import com.gridnine.hotels.web.ws.ReservationResult;
import com.gridnine.hotels.web.ws.ReservationStatus;
import com.gridnine.hotels.web.ws.ResponseWithErrorWS;
import com.gridnine.hotels.web.ws.Status;
import com.gridnine.xtrip.common.hotels2.exception.NotSaveImportedBookingException;
import com.gridnine.xtrip.common.hotels2.exception.RateIsUnavailableException;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.hotels2.ibus.IBusHotelsContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.jaxws.IBusWsContextKeys;
import com.gridnine.xtrip.server.jaxws.WsResponse;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class HotelsAggregatorWsResponseParser
extends BaseProcessor {
    private static final String RATE_IS_UNAVAILABLE = "RATE_IS_UNAVAILABLE";
    private static final String UNKNOWN_HOTEL_CODE = "UNKNOWN_HOTEL_CODE";
    private static final String ORDER_NOT_FOUND = "ORDER_NOT_FOUND";
    private static final String ORDER_ACCESS_DENIED = "ORDER_ACCESS_DENIED";

    public void process(MessageContext ctx) throws Exception {
        WsResponse response = (WsResponse)ctx.getMandatoryObject((Enum)IBusWsContextKeys.WS_RESPONSE);
        this.checkResponse(response.getPayload());
        ctx.putObject((Enum)IBusHotelsContextKeys.HOTELS_AGGREGATOR_RESPONSE, response.getPayload());
    }

    private void checkResponse(Object response) {
        if (response instanceof Collection) {
            Collection items = (Collection)response;
            items.forEach(this::checkResponse);
        } else if (response instanceof PricingResult) {
            PricingResult pr = (PricingResult)response;
            this.checkPricingErrors(pr.getErrors());
            this.checkHotelsResponse((ResponseWithErrorWS)pr);
            for (PricingResultItem pricingResultItem : pr.getPricingResultItem()) {
                for (PricingItem pricingItem : pricingResultItem.getPricingItem()) {
                    if (pricingItem.getErrors() == null) continue;
                    this.checkPricingErrors(pricingItem.getErrors());
                    this.checkHotelsResponse(pricingItem.getErrors());
                }
                this.checkReservationResultResponse(pricingResultItem.getReservationResult());
            }
        } else if (response instanceof ReservationPricing) {
            ReservationPricing pricingResultItem = (ReservationPricing)response;
            this.checkHotelsResponse((ResponseWithErrorWS)pricingResultItem);
            this.checkReservationResultResponse(pricingResultItem.getReservationResult());
        } else if (response instanceof HotelsResponse) {
            this.checkHotelsResponse((HotelsResponse)((GetHotelFolderInfoResponse)response));
        } else if (response instanceof ResponseWithErrorWS) {
            this.checkHotelsResponse((ResponseWithErrorWS)response);
        } else if (response instanceof ReservationResult) {
            this.checkReservationResultResponse((ReservationResult)response);
        }
    }

    private void checkHotelsResponse(HotelsResponse response) {
        if (response == null) {
            return;
        }
        if (response.getStatus() != Status.SUCCESS) {
            throw Xeption.forDeveloper((String)"Invalid status: {0}\n{1}", (Object[])new Object[]{response.getStatus().name(), this.toText(response.getErrors())});
        }
    }

    private void checkReservationResultResponse(ReservationResult rr) {
        if (null == rr) {
            return;
        }
        if (ORDER_NOT_FOUND.equals(rr.getErrorType())) {
            throw NotSaveImportedBookingException.forEndUser((String)"\u0417\u0430\u043a\u0430\u0437 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u0432 \u043e\u0442\u0435\u043b\u044c\u043d\u043e\u043c \u0430\u0433\u0440\u0435\u0433\u0430\u0442\u043e\u0440\u0435.", (Object[])new Object[0]);
        }
        if (ORDER_ACCESS_DENIED.equals(rr.getErrorType())) {
            throw NotSaveImportedBookingException.forEndUser((String)"\u041f\u043e\u043b\u0443\u0447\u0435\u043d \u043e\u0442\u0432\u0435\u0442 \u043e\u0442 \u043f\u043e\u0441\u0442\u0430\u0432\u0449\u0438\u043a\u0430 \"\u0414\u0435\u0439\u0441\u0442\u0432\u0438\u0435 \u0437\u0430\u043f\u0440\u0435\u0449\u0435\u043d\u043e\".", (Object[])new Object[0]);
        }
        this.checkPricingError(rr.getErrorType());
        if (TextUtil.nonBlank((String)rr.getErrorTextToDisplay()) || TextUtil.nonBlank((String)rr.getErrorType()) || TextUtil.nonBlank((String)rr.getErrorText())) {
            throw Xeption.forDeveloper((String)"Invalid response: \n{0}: {1}", (Object[])new Object[]{rr.getErrorType(), MiscUtil.guarded((Object)rr.getErrorTextToDisplay(), (Object)rr.getErrorText())});
        }
        if (rr.getStatusInfo() != null && rr.getStatusInfo().getStatus() == ReservationStatus.ERROR) {
            throw Xeption.forDeveloper((String)"Invalid response: status == ERROR", (Object[])new Object[0]);
        }
    }

    private void checkHotelsResponse(ResponseWithErrorWS response) {
        if (response == null || response.getErrors() == null) {
            return;
        }
        if (CollectionUtil.isNotEmpty((Collection)response.getErrors().getErrors())) {
            throw Xeption.forDeveloper((String)"Invalid response: \n{0}", (Object[])new Object[]{this.toText(response.getErrors().getErrors())});
        }
    }

    private void checkHotelsResponse(PricingItem.Errors errors) {
        if (errors == null) {
            return;
        }
        if (CollectionUtil.isNotEmpty((Collection)errors.getError())) {
            throw Xeption.forDeveloper((String)"Invalid response: \n{0}", (Object[])new Object[]{this.toText(errors.getError())});
        }
    }

    private void checkPricingErrors(PricingItem.Errors errors) {
        if (errors != null && CollectionUtil.isNotEmpty((Collection)errors.getError())) {
            errors.getError().stream().map(Message::getCode).forEach(this::checkPricingError);
            this.checkPricingError(this.toText(errors.getError()));
        }
    }

    private void checkPricingErrors(ResponseWithErrorWS.Errors errors) {
        if (errors != null && CollectionUtil.isNotEmpty((Collection)errors.getErrors())) {
            errors.getErrors().stream().map(Message::getCode).forEach(this::checkPricingError);
            this.checkPricingError(this.toText(errors.getErrors()));
        }
    }

    private void checkPricingError(String error) {
        if (error != null && (RATE_IS_UNAVAILABLE.equals(error) || UNKNOWN_HOTEL_CODE.equals(error))) {
            throw RateIsUnavailableException.forEndUser((String)L10nResourcesManager.getStr((String)"HOTELS2_RATE_IS_UNAVAILABLE", (Object[])new Object[0]), (Object[])new Object[0]);
        }
    }

    private String toText(HotelsResponse.Errors errors) {
        if (errors == null || CollectionUtil.isEmpty((Collection)errors.getError())) {
            return null;
        }
        return errors.getError().stream().filter(Objects::nonNull).map(err -> err.getCode() + ": " + err.getMessage()).collect(Collectors.joining("\n"));
    }

    private String toText(List<Message> errors) {
        return errors.stream().filter(Objects::nonNull).map(err -> err.getCode() + ": " + err.getMessage()).collect(Collectors.joining("\n"));
    }
}

