/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.hotels2.ibus;

import com.gridnine.xtrip.common.hotels2.model.HotelsAggregatorGdsAccount;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProvider;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.TripartiteContract;
import com.gridnine.xtrip.common.model.profile.TripartiteContractIndex;
import com.gridnine.xtrip.common.model.rules.standard.Targets;
import com.gridnine.xtrip.common.model.rules.tripartite.HotelTripartiteContractActionSet;
import com.gridnine.xtrip.common.rules.RuleEngine;
import com.gridnine.xtrip.common.rules.RuleSet;
import com.gridnine.xtrip.common.rules.RuleSettings;
import com.gridnine.xtrip.common.rules.elements.DebugInfo;
import com.gridnine.xtrip.common.rules.elements.RuleProxy;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.model.handlers.HotelPropertySet;
import com.gridnine.xtrip.server.model.helpers.TripartiteHelper;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HotelsTripartiteContractRulesHelper {
    private static final Logger log = LoggerFactory.getLogger(HotelsTripartiteContractRulesHelper.class);

    public static List<EntityContainer<TripartiteContract>> collectContracts(EntityReference<Organization> agencyRef, HotelProvider provider, EntityReference<Organization> clientRef) {
        ArrayList<EntityContainer<TripartiteContract>> result = new ArrayList<EntityContainer<TripartiteContract>>();
        SearchQuery query = TripartiteHelper.initMainQueryForTripartite(agencyRef, clientRef);
        query.getCriteria().getCriterions().add(SearchCriterion.contains((String)TripartiteContractIndex.Property.vendorHotelsProviders.name(), (Object)provider));
        Date current = new Date();
        query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)TripartiteContractIndex.Property.firstStartDate.name(), null), SearchCriterion.le((String)TripartiteContractIndex.Property.firstStartDate.name(), (Object)current)}));
        query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)TripartiteContractIndex.Property.lastEndDate.name(), null), SearchCriterion.ge((String)TripartiteContractIndex.Property.lastEndDate.name(), (Object)current)}));
        List indexes = EntityStorage.get().search(TripartiteContractIndex.class, query).getData();
        for (TripartiteContractIndex idx : indexes) {
            result.add((EntityContainer<TripartiteContract>)EntityStorage.get().resolve(idx.getSource()));
        }
        result.sort((o1, o2) -> MiscUtil.compare((Date)TripartiteHelper.findContractIssueDate((EntityContainer)o1), (Date)TripartiteHelper.findContractIssueDate((EntityContainer)o2), (boolean)false));
        return result;
    }

    public static HotelTripartiteContractActionSet applyTripartiteRules(EntityContainer<TripartiteContract> contractCtr, EntityContainer<HotelsAggregatorGdsAccount> accountCtr) throws Exception {
        Date date = new Date();
        RuleProxy proxy = new RuleProxy();
        HotelPropertySet propertySet = new HotelPropertySet(proxy);
        propertySet.init(accountCtr.toReference());
        proxy.setPropertySet((Object)propertySet);
        proxy.setActionSet((Object)new HotelTripartiteContractActionSet());
        proxy.getTracer().setDisabled(false);
        proxy.getTracer().setDebugInfo(new DebugInfo());
        proxy.setProxyDate(date);
        proxy.setProxyType(Targets.HOTELS_FOREIGN.getId());
        ArrayList<RuleProxy> proxyList = new ArrayList<RuleProxy>();
        proxyList.add(proxy);
        RuleSet rules = ((TripartiteContract)contractCtr.getEntity()).getRuleSet();
        RuleEngine.applyRules(proxyList, (RuleSet)rules);
        proxy.getTracer().traceLogic(String.format("contract applied: contract = %s", contractCtr.toReference()));
        HashSet appliedRules = new HashSet(proxy.getAppliedRules());
        if (!appliedRules.isEmpty()) {
            proxy.getTracer().traceLogic(String.format("some rules applied: contract = %s", contractCtr.toReference()));
            for (String ruleUid : proxy.getAppliedRules()) {
                RuleSettings rule = (RuleSettings)CollectionUtil.find((Iterable)rules.getRules(), (String)ruleUid);
                if (rule != null) continue;
                log.error(String.format("unable to find rule with uid %s in contract %s", ruleUid, contractCtr));
                proxy.getTracer().traceWarn(String.format("unable to find rule: contract=%s, uid=%s", contractCtr.toReference(), ruleUid), null);
            }
            if (((HotelTripartiteContractActionSet)proxy.getActionSet()).getClientTariffCode() != null && !((HotelTripartiteContractActionSet)proxy.getActionSet()).getClientTariffCode().isEmpty()) {
                String logStr = String.format("\u0443\u0441\u0442\u0430\u043d\u0430\u0432\u043b\u0438\u0432\u0430\u0435\u043c \u043a\u043e\u0434 \u043a\u043b\u0438\u0435\u043d\u0442\u0441\u043a\u043e\u0433\u043e \u0442\u0430\u0440\u0438\u0444\u0430 \u0432 %s", ((HotelTripartiteContractActionSet)proxy.getActionSet()).getClientTariffCode());
                proxy.getTracer().traceLogic(logStr);
                log.debug(logStr);
            }
        }
        return (HotelTripartiteContractActionSet)proxy.getActionSet();
    }
}

