/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.hotels2.ibus.autocomplete;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.hotels.web.ws.AutocompleteParam;
import com.gridnine.hotels.web.ws.InvocationContext;
import com.gridnine.xtrip.common.hotels2.model.FindHotelsAutocompleteParameters;
import com.gridnine.xtrip.common.hotels2.model.HotelsAggregatorGdsAccount;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.hotels2.ibus.HotelsAggregatorRequestData;
import com.gridnine.xtrip.server.hotels2.ibus.IBusHotelsContextKeys;
import com.gridnine.xtrip.server.hotels2.ibus.helpers.HotelsBaseHelper;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Collections;
import java.util.List;

public class FindHotelsAutocompleteRequestBuilder
extends BaseProcessor {
    private static final String METHOD = "findHotelsAutocomplete";

    public void process(MessageContext ctx) throws Exception {
        FindHotelsAutocompleteParameters params = (FindHotelsAutocompleteParameters)ctx.getMandatoryObject((Enum)IBusHotelsContextKeys.HOTELS_AUTOCOMPLETE_PARAMS);
        List gdsAccounts = (List)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.APPLICABLE_GDS_ACCOUNTS);
        if (gdsAccounts.isEmpty()) {
            throw Xeption.forDeveloper((String)"No Applicable Gds Accounts", (Object[])new Object[0]);
        }
        ctx.putObject((Enum)IBusMidofficeContextKeys.GDS_ACCOUNT, gdsAccounts.get(0));
        ctx.putObject((Enum)IBusHotelsContextKeys.HOTELS_AGGREGATOR_REQUEST_DATA, (Object)this.buildRequestData(params, gdsAccounts));
    }

    private HotelsAggregatorRequestData buildRequestData(FindHotelsAutocompleteParameters params, List<EntityContainer<HotelsAggregatorGdsAccount>> gdsAccounts) {
        AutocompleteParam autocompleteParams = new AutocompleteParam();
        autocompleteParams.setContext(new InvocationContext());
        autocompleteParams.setSearch(params.getPattern());
        autocompleteParams.setSystemOnly(false);
        autocompleteParams.setPccFilter(HotelsBaseHelper.buildHotelsPccFilter(gdsAccounts));
        return new HotelsAggregatorRequestData(Collections.singletonList(autocompleteParams), METHOD, autocompleteParams.getContext());
    }
}

