/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.hotels2.ibus.autocomplete;

import com.gridnine.hotels.web.ws.CodeEntry;
import com.gridnine.hotels.web.ws.TranslationEntry;
import com.gridnine.xtrip.common.hotels2.model.FindHotelsAutocompleteParameters;
import com.gridnine.xtrip.common.model.dict.CodeSystem;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.GeoLocation;
import com.gridnine.xtrip.common.model.dict.LocationType;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.hotels2.ibus.IBusHotelsContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;

public class FindLocationsAutocompleteResponseParser
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        FindHotelsAutocompleteParameters params = (FindHotelsAutocompleteParameters)ctx.getMandatoryObject((Enum)IBusHotelsContextKeys.HOTELS_AUTOCOMPLETE_PARAMS);
        List locations = (List)ctx.getMandatoryObject((Enum)IBusHotelsContextKeys.HOTELS_AGGREGATOR_RESPONSE);
        ArrayList summaryList = new ArrayList();
        HashMap hotelAvailabilityMap = new HashMap();
        if (locations != null) {
            DictionaryCache dc = DictionaryCache.get();
            locations.stream().map(aggLoc -> {
                if (CollectionUtil.isEmpty((Collection)aggLoc.getCodes())) {
                    return null;
                }
                GeoLocation geoLocation = aggLoc.getCodes().stream().map(CodeEntry::getCode).filter(TextUtil::nonBlank).map(code -> DictHelper.findGeoLocationByCode((String)code, (LocationType)LocationType.CITY)).flatMap(Collection::stream).findFirst().orElse(null);
                if (geoLocation == null) {
                    return null;
                }
                if ((geoLocation.getLatitude() == 0.0 || geoLocation.getLongitude() == 0.0) && aggLoc.getLocation() != null && aggLoc.getLocation().getLatitude() != 0.0 && aggLoc.getLocation().getLongitude() != 0.0) {
                    geoLocation.setLatitude(aggLoc.getLocation().getLatitude());
                    geoLocation.setLongitude(aggLoc.getLocation().getLongitude());
                }
                String aggCityName = aggLoc.getTranslations().stream().map(TranslationEntry::getValue).findFirst().orElse(null);
                hotelAvailabilityMap.put(geoLocation, null);
                return new MiscUtil.Pair((Object)geoLocation, (Object)aggCityName);
            }).filter(Objects::nonNull).filter(pair -> ((GeoLocation)pair.getFirst()).getCodeVariants().get(CodeSystem.HOTEL_AGGREGATOR.name()) != null).distinct().limit(params.getLimit() != null ? (long)params.getLimit().intValue() : 20L).forEach(summaryList::add);
        }
        ctx.putObject((Enum)IBusHotelsContextKeys.HOTELS_CITIES_SUMMARY_LIST, summaryList);
        ctx.putObject((Enum)IBusHotelsContextKeys.HOTELS_CITIES_HOTEL_AVAILABILITY_MAP, hotelAvailabilityMap);
    }
}

