/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.hotels2.ibus.autocomplete;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.hotels2.model.FindHotelsAutocompleteParameters;
import com.gridnine.xtrip.common.hotels2.model.HotelSummary;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GeoLocation;
import com.gridnine.xtrip.common.model.dict.LocationType;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.profile.Address;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.OrganizationIndex;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.hotels2.ibus.IBusHotelsContextKeys;
import com.gridnine.xtrip.server.hotels2.ibus.helpers.HotelsDirectContractHelper;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;

public class GetDirectContractHotelsProvider
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        FindHotelsAutocompleteParameters params = (FindHotelsAutocompleteParameters)ctx.getMandatoryObject((Enum)IBusHotelsContextKeys.HOTELS_AUTOCOMPLETE_PARAMS);
        SalesContext salesContext = (SalesContext)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.SALES_CONTEXT);
        Set<EntityReference<Organization>> suppliers = HotelsDirectContractHelper.getDirectContractSuppliers(salesContext);
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)OrganizationIndex.Property.hotel.name(), (Object)true));
        if (TextUtil.nonBlank((String)params.getPattern())) {
            ArrayList<SearchCriterion> patternCriterions = new ArrayList<SearchCriterion>();
            patternCriterions.add(SearchCriterion.like((String)OrganizationIndex.Property.hotelName.name(), (String)("%" + params.getPattern() + "%")));
            DictionaryCache cache = DictionaryCache.get();
            HashSet<GeoLocation> cities = new HashSet<GeoLocation>();
            for (GeoLocation location : cache.getAll(GeoLocation.class).values()) {
                if (location.getType() != LocationType.CITY) continue;
                for (Locale locale : location.getTranslations().keySet()) {
                    if (!((String)location.getTranslations().get(locale)).toLowerCase().contains(params.getPattern().toLowerCase())) continue;
                    cities.add(location);
                }
            }
            if (!cities.isEmpty()) {
                patternCriterions.add(SearchCriterion.in((String)OrganizationIndex.Property.hotelCity.name(), (Object[])cities.stream().map(GeoLocation::toReference).toArray()));
            }
            query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])patternCriterions.toArray(new SearchCriterion[0])));
        }
        ArrayList summaryList = new ArrayList();
        HashMap hotelAvailabilityMap = new HashMap();
        List result = EntityStorage.get().search(OrganizationIndex.class, query).getData().stream().filter(ind -> suppliers.contains(ind.getSource())).map(this::convertToHotelSummary).peek(hs -> {
            GeoLocation gl = (GeoLocation)DictionaryCache.get().resolveReference(hs.getAddress().getCity());
            MiscUtil.Pair pair = new MiscUtil.Pair((Object)gl, null);
            if (!summaryList.contains(pair)) {
                summaryList.add(pair);
                hotelAvailabilityMap.put(gl, null);
            }
        }).collect(Collectors.toList());
        ctx.putObject((Enum)IBusHotelsContextKeys.HOTELS_HOTEL_SUMMARY_LIST, result);
        ctx.putObject((Enum)IBusHotelsContextKeys.HOTELS_CITIES_SUMMARY_LIST, summaryList);
        ctx.putObject((Enum)IBusHotelsContextKeys.HOTELS_CITIES_HOTEL_AVAILABILITY_MAP, hotelAvailabilityMap);
    }

    private HotelSummary convertToHotelSummary(OrganizationIndex index) {
        HotelSummary hotel = new HotelSummary();
        hotel.setName(StringUtils.trim((String)index.getHotelName()));
        hotel.setNumber(StringUtils.trim((String)index.getHotelNumber()));
        Address address = new Address();
        address.setCity(index.getHotelCity());
        address.setCountry((DictionaryReference)DictHelper.findCountry((String)index.getHotelCity().getCode()).toReference());
        hotel.setAddress(address);
        return hotel;
    }
}

