/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.hotels2.ibus.cancelBooking;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.hotels.web.ws.CancelReservationQuery;
import com.gridnine.hotels.web.ws.InvocationContext;
import com.gridnine.hotels.web.ws.ReservationID;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProduct;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.CommonReservationGdsNameInfoHelper;
import com.gridnine.xtrip.server.hotels2.ibus.HotelsAggregatorRequestData;
import com.gridnine.xtrip.server.hotels2.ibus.IBusHotelsContextKeys;
import com.gridnine.xtrip.server.hotels2.ibus.helpers.HotelsBaseHelper;
import com.gridnine.xtrip.server.hotels2.ibus.helpers.HotelsHelper;
import com.gridnine.xtrip.server.hotels2.ibus.helpers.HotelsReservationHelper;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.ArrayList;
import java.util.List;

public class CancelBookingRequestBuilder
extends BaseProcessor {
    private static final String METHOD = "cancelReservation";

    public void process(MessageContext ctx) throws Exception {
        Reservation reservation = (Reservation)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION);
        List products = (List)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.BASE_PRODUCTS);
        EntityContainer gdsAccount = EntityStorage.get().resolve(reservation.getGdsNameInfo().getOnlineGdsAccount());
        ArrayList<HotelProduct> list = new ArrayList<HotelProduct>();
        for (BaseProduct bp : reservation.getProducts()) {
            HotelProduct product = (HotelProduct)bp;
            if (!HotelsReservationHelper.isRefundAvailable(product)) {
                throw Xeption.forDeveloper((String)"\u0415\u0441\u0442\u044c \u043d\u0435 \u0432\u043e\u0437\u0432\u0440\u0430\u0449\u0430\u0435\u043c\u044b\u0439 \u043f\u0440\u043e\u0434\u0443\u043a\u0442", (Object[])new Object[0]);
            }
            if (!products.contains(product)) {
                throw Xeption.forDeveloper((String)"\u0427\u0430\u0441\u0442\u0438\u0447\u043d\u044b\u0439 \u0432\u043e\u0437\u0432\u0440\u0430\u0442 \u043d\u0435 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u0442\u0441\u044f", (Object[])new Object[0]);
            }
            list.add(product);
        }
        if (list.isEmpty()) {
            throw Xeption.forDeveloper((String)"\u0412 \u0431\u0440\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0438 {0} \u043d\u0435\u0447\u0435\u0433\u043e \u043e\u0442\u043c\u0435\u043d\u044f\u0442\u044c.", (Object[])new Object[]{CommonReservationGdsNameInfoHelper.getDisplayedRecordLocator((Reservation)reservation)});
        }
        CancelReservationQuery request = CancelBookingRequestBuilder.buildCancelReservationRequest(reservation, list);
        ctx.putObject((Enum)IBusMidofficeContextKeys.GDS_ACCOUNT, (Object)gdsAccount);
        ctx.putObject((Enum)IBusHotelsContextKeys.PRODUCT_LIST, list);
        InvocationContext context = new InvocationContext();
        ArrayList<Object> objects = new ArrayList<Object>();
        objects.add(context);
        objects.add(request);
        ctx.putObject((Enum)IBusHotelsContextKeys.HOTELS_AGGREGATOR_REQUEST_DATA, (Object)new HotelsAggregatorRequestData(objects, METHOD, context));
    }

    private static CancelReservationQuery buildCancelReservationRequest(Reservation reservation, List<HotelProduct> products) {
        ReservationID reservationID = HotelsHelper.buildReservationID(reservation, null);
        if (reservationID == null) {
            throw Xeption.forDeveloper((String)"invalid reservation identification data to cancel", (Object[])new Object[0]);
        }
        CancelReservationQuery query = new CancelReservationQuery();
        query.setProvider(HotelsBaseHelper.convertProviderToGds(((HotelProduct)products.stream().findFirst().orElseThrow(() -> Xeption.forDeveloper((String)"no products to cancel", (Object[])new Object[0]))).getProvider()));
        query.setReservationID(reservationID);
        return query;
    }
}

