/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.hotels2.ibus.cancelBooking;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.hotels.web.ws.ReservationItem;
import com.gridnine.hotels.web.ws.ReservationResult;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.PassengerType;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProduct;
import com.gridnine.xtrip.common.model.booking.xtriphotels.PassengerTypeReference;
import com.gridnine.xtrip.common.model.booking.xtriphotels.Room;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.helpers.HotelProductHelper;
import com.gridnine.xtrip.common.model.helpers.vat.hotel.HotelProductVatFiller;
import com.gridnine.xtrip.common.model.rules.standard.hotelProductSettings.HotelProductSettingsActionSet;
import com.gridnine.xtrip.common.rules.elements.RuleProxy;
import com.gridnine.xtrip.common.util.XCloneHelper;
import com.gridnine.xtrip.common.util.XCloneable;
import com.gridnine.xtrip.server.hotels2.ibus.IBusHotelsContextKeys;
import com.gridnine.xtrip.server.hotels2.ibus.helpers.HotelsHelper;
import com.gridnine.xtrip.server.hotels2.ibus.helpers.HotelsReservationHelper;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.model.handlers.rules.hotel.HotelRulesHelper;
import java.util.Date;
import java.util.List;
import java.util.Objects;

public class CancelBookingResultParser
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        EntityContainer bookingFileCtr = (EntityContainer)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.BOOKING_FILE);
        Reservation reservation = (Reservation)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION);
        SalesContext salesContext = (SalesContext)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.SALES_CONTEXT);
        List list = (List)ctx.getMandatoryObject((Enum)IBusHotelsContextKeys.PRODUCT_LIST);
        ReservationResult reservationResult = (ReservationResult)ctx.getMandatoryObject((Enum)IBusHotelsContextKeys.HOTELS_AGGREGATOR_RESPONSE);
        for (ReservationItem item : reservationResult.getReservationItems().getReservationItems()) {
            Room room;
            HotelProduct hp = HotelsHelper.createHotelProduct(salesContext);
            Integer standardCheckInTime = ((Room)hp.getRooms().get(0)).getStandardCheckInTime();
            Integer standardCheckOutTime = ((Room)hp.getRooms().get(0)).getStandardCheckOutTime();
            HotelsHelper.updateReservedHotelProduct(hp, item, reservationResult, null, HotelsHelper.convertTime(standardCheckInTime), HotelsHelper.convertTime(standardCheckOutTime), null, arg_0 -> ((MessageContext)ctx).addMessage(arg_0));
            Date originalDate = hp.getIssueDate();
            hp.setIssueDate(new Date());
            HotelProductHelper.setOnHold((HotelProduct)hp, (boolean)false);
            hp.setReservation(reservation);
            HotelProduct original = HotelsReservationHelper.findProduct(list, hp);
            if (original != null) {
                if (hp.getStatus() == original.getStatus()) continue;
                if (original.getStatus() == ProductStatus.REQUEST) {
                    HotelsHelper.updateReservedHotelProduct(original, item, reservationResult, null, HotelsHelper.convertTime(standardCheckInTime), HotelsHelper.convertTime(standardCheckOutTime), null, arg_0 -> ((MessageContext)ctx).addMessage(arg_0));
                    HotelsHelper.updateProductSystemNumber(original);
                    original.setStatus(ProductStatus.VOID_REQUEST);
                    original.setContractRulesApplied(false);
                    RuleProxy ruleProxy = HotelRulesHelper.applyHotelProductSettingsRules((HotelProduct)original);
                    HotelsHelper.fillContractData(original, (HotelProductSettingsActionSet)ruleProxy.getActionSet());
                } else {
                    original.setHotelAggrStatus(hp.getHotelAggrStatus());
                    original.setProviderStatusInfo(hp.getProviderStatusInfo());
                    hp.setCurrencyRateDate(original.currencyRateDate());
                    room = (Room)hp.getRooms().get(0);
                    for (Traveller t : original.getTravellers()) {
                        Traveller traveller = (Traveller)XCloneHelper.clone((XCloneable)t);
                        hp.getTravellers().add(traveller);
                        room.getRoomTravellersUids().add(traveller.getUid());
                        PassengerTypeReference ptr = new PassengerTypeReference();
                        ptr.setTravellerUid(traveller.getUid());
                        DictionaryReference<PassengerType> passengerType = hp.getTravellersPassengerTypes().stream().filter(p -> Objects.equals(p.getTravellerUid(), t.getUid())).map(PassengerTypeReference::getPassengerType).findFirst().orElse(null);
                        ptr.setPassengerType(passengerType != null ? passengerType : HotelsReservationHelper.getTravellerPassengerType(traveller));
                        hp.getTravellersPassengerTypes().add(ptr);
                    }
                    HotelProductHelper.setSupplier((HotelProduct)hp, (EntityReference)HotelProductHelper.getSupplier((HotelProduct)original));
                    hp.setBlankOwnerRef(original.getBlankOwnerRef());
                    original.setNextProduct(hp);
                    hp.setPreviousProduct(original);
                    reservation.getProducts().add(hp);
                }
                HotelProductHelper.updateFops((HotelProduct)hp);
                HotelProductVatFiller.updateVat((HotelProduct)hp);
                HotelProductHelper.setOnHold((HotelProduct)original, (boolean)false);
            } else if (hp.getStatus() == ProductStatus.REFUND) {
                room = (Room)hp.getRooms().get(0);
                HotelsHelper.setTravellers(hp, room, item, null);
                ((BookingFile)bookingFileCtr.getEntity()).getTravellers().addAll(hp.getTravellers());
                RuleProxy ruleProxy = HotelRulesHelper.applyHotelProductSettingsRules((HotelProduct)hp);
                HotelsHelper.fillContractData(hp, (HotelProductSettingsActionSet)ruleProxy.getActionSet());
                HotelProduct sell = new HotelProduct();
                HotelProductHelper.copy((HotelProduct)hp, (HotelProduct)sell, (boolean)false);
                sell.setStatus(ProductStatus.SELL);
                sell.setForcedRefund(false);
                sell.getPenalties().clear();
                sell.setIssueDate(originalDate);
                sell.setNextProduct(hp);
                hp.setPreviousProduct(sell);
                HotelProductVatFiller.updateVat((HotelProduct)sell);
                HotelProductHelper.updateFops((HotelProduct)sell);
                reservation.getProducts().add(sell);
                HotelsHelper.updateProductSystemNumber(sell);
                reservation.getProducts().add(hp);
            }
            if (hp.getStatus() == ProductStatus.REFUND && hp.getPreviousProduct() != null) {
                hp.setSystemNumber(hp.getPreviousProduct().getSystemNumber());
            } else {
                HotelsHelper.updateProductSystemNumber(hp);
            }
            ctx.putObject((Enum)IBusHotelsContextKeys.HOTELS_RESERVATION_CHANGED, (Object)Boolean.TRUE);
        }
    }
}

