/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.hotels2.ibus.cancelBooking;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.midoffice.model.GdsProductRefexFinanceDetails;
import com.gridnine.xtrip.common.midoffice.model.UnsellFinanceDetails;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProduct;
import com.gridnine.xtrip.common.model.helpers.HotelProductHelper;
import com.gridnine.xtrip.server.hotels2.ibus.helpers.PenaltyHelper;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;

public class FakeUnsellHotelReservationProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        Reservation reservation = (Reservation)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION);
        Map unsellRequest = (Map)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.UNSELL_REQUEST);
        UnsellFinanceDetails unsellDetails = (UnsellFinanceDetails)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.UNSELL_FINANCE_DETAILS);
        this.unsell(reservation, unsellRequest, unsellDetails);
    }

    private void unsell(Reservation reservation, Map<String, ProductStatus> unsellRequest, UnsellFinanceDetails unsellDetails) throws Exception {
        for (BaseProduct bp : new ArrayList(reservation.getProducts())) {
            if (unsellRequest.get(bp.getUid()) != ProductStatus.REFUND) continue;
            HotelProduct product = (HotelProduct)bp;
            GdsProductRefexFinanceDetails gdsRefexDetails = (GdsProductRefexFinanceDetails)unsellDetails.getGdsDetails().get((Object)bp.getUid());
            if (gdsRefexDetails == null) {
                throw Xeption.forDeveloper((String)"no refund details found for hotelProduct {0}", (Object[])new Object[]{product.getSystemNumber()});
            }
            HotelProduct refund = HotelProductHelper.clone((HotelProduct)product, (boolean)true);
            product.setNextProduct(refund);
            refund.setPreviousProduct(product);
            refund.setStatus(ProductStatus.REFUND);
            refund.setIssueDate(new Date());
            BigDecimal penalty = gdsRefexDetails.getPenalty();
            if (penalty != null) {
                refund.getPenalties().add(PenaltyHelper.createPenalty(null, penalty));
            }
            refund.setCurrencyRateDate(product.currencyRateDate());
        }
    }
}

