/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.hotels2.ibus.cancelBooking;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.midoffice.model.GdsProductRefexFinanceDetails;
import com.gridnine.xtrip.common.midoffice.model.UnsellFinanceDetails;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProduct;
import com.gridnine.xtrip.common.model.booking.xtriphotels.Penalty;
import com.gridnine.xtrip.common.model.helpers.BookingStreamHelper;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.hotels2.ibus.helpers.PenaltyHelper;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Map;

public class FillHotelUnsellFinanceDetailsProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) {
        Reservation reservation = (Reservation)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION);
        Map refexRequest = (Map)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.UNSELL_REQUEST);
        UnsellFinanceDetails unsellFinanceDetails = (UnsellFinanceDetails)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.UNSELL_FINANCE_DETAILS);
        for (String productUid : refexRequest.keySet()) {
            HotelProduct hotelProduct = BookingStreamHelper.getProductsStream((Reservation)reservation, HotelProduct.class).filter(hp -> MiscUtil.equals((Object)hp.getUid(), (Object)productUid)).findFirst().orElseThrow(() -> Xeption.forDeveloper((String)"can't find hotelProduct by uid {0}", (Object[])new Object[]{productUid}));
            GdsProductRefexFinanceDetails gdsDetails = new GdsProductRefexFinanceDetails();
            gdsDetails.setPossible(true);
            Penalty penaltyFromPolicy = PenaltyHelper.createPenaltyFromPolicy(hotelProduct);
            gdsDetails.setPenalty(penaltyFromPolicy.getEquivalentAmount());
            unsellFinanceDetails.getGdsDetails().put((Object)productUid, (Object)gdsDetails);
        }
    }
}

