/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.hotels2.ibus.createIntentionReservations;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.hotels.web.ws.HotelCard;
import com.gridnine.hotels.web.ws.PricingResult;
import com.gridnine.hotels.web.ws.PricingResultItem;
import com.gridnine.hotels.web.ws.ReservationItem;
import com.gridnine.xtrip.common.hotels2.model.CreateIntentionReservationParameters;
import com.gridnine.xtrip.common.hotels2.model.CreateIntentionReservationResult;
import com.gridnine.xtrip.common.hotels2.model.HotelOffer;
import com.gridnine.xtrip.common.hotels2.model.HotelsAggregatorGdsAccount;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.RecordLocatorType;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.ReservationType;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProduct;
import com.gridnine.xtrip.common.model.booking.xtriphotels.MainHotelProductIndex;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.helpers.CommonReservationGdsNameInfoHelper;
import com.gridnine.xtrip.common.model.helpers.SearchQueryHelper;
import com.gridnine.xtrip.server.db.storage.model.sn.SequenceNumberHelper;
import com.gridnine.xtrip.server.hotels2.ibus.IBusHotelsContextKeys;
import com.gridnine.xtrip.server.hotels2.ibus.helpers.HotelsHelper;
import com.gridnine.xtrip.server.hotels2.ibus.helpers.HotelsReservationHelper;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Date;
import java.util.List;

public class CreateIntentionReservationsResultParser
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        CreateIntentionReservationParameters params = (CreateIntentionReservationParameters)ctx.getMandatoryObject((Enum)IBusHotelsContextKeys.HOTELS_CREATE_INTENTION_RESERVATION_PARAMS);
        PricingResult response = (PricingResult)ctx.getMandatoryObject((Enum)IBusHotelsContextKeys.HOTELS_AGGREGATOR_RESPONSE);
        EntityContainer gdsAccount = (EntityContainer)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.GDS_ACCOUNT);
        SalesContext salesContext = (SalesContext)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.SALES_CONTEXT);
        HotelsHelper.checkRoomsAvailability(response.getPricingResultItem());
        CreateIntentionReservationResult result = new CreateIntentionReservationResult();
        EntityReference gdsAccountRef = gdsAccount.toReference();
        List offers = params.getOffers();
        HotelOffer first = offers.stream().findFirst().orElse(null);
        if (first != null && first.getSubagency() != null) {
            salesContext.setSubagency(first.getSubagency());
        }
        for (PricingResultItem pri : response.getPricingResultItem()) {
            Reservation reservation = HotelsHelper.buildReservation((EntityReference<HotelsAggregatorGdsAccount>)gdsAccountRef, salesContext, pri.getReservationResult(), pri.getPricingItem(), offers, arg_0 -> ((MessageContext)ctx).addMessage(arg_0), (arg_0, arg_1) -> ((MessageContext)ctx).putObject(arg_0, arg_1));
            reservation.setType(ReservationType.IBE);
            HotelsReservationHelper.updateTimeLimit(reservation);
            Date now = new Date();
            reservation.getProducts().stream().filter(p -> p instanceof HotelProduct).map(HotelProduct.class::cast).forEach(p -> {
                p.setStatus(ProductStatus.INTENTION);
                p.setIssueDate(now);
            });
            if (!params.isDontGenerateRecordLocator()) {
                String number = SequenceNumberHelper.generateNumber((String)"hotels-reservation", MainHotelProductIndex.class, SearchQueryHelper::getRecordLocatorSearchCriterionForMainHotelProductIndex, (String)"H", null);
                CommonReservationGdsNameInfoHelper.setRecordLocator((Reservation)reservation, (GdsName)GdsName.IBE, (RecordLocatorType)RecordLocatorType.DEFAULT, (String)number);
            }
            reservation.setNotes(params.getComments());
            result.getReservations().add(reservation);
        }
        ctx.putObject((Enum)IBusHotelsContextKeys.HOTELS_CREATE_INTENTION_RESERVATION_RESULT, (Object)result);
        HotelCard responseHotelCard = ((ReservationItem)((PricingResultItem)response.getPricingResultItem().get(0)).getReservationResult().getReservationItems().getReservationItems().get(0)).getHotelCard();
        ctx.putObject((Enum)IBusHotelsContextKeys.HOTELS_HOTEL_CARD, (Object)HotelsHelper.convertHotelCard(responseHotelCard));
    }
}

