/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.hotels2.ibus.createReservation;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.hotels.web.ws.AgencyInfo;
import com.gridnine.hotels.web.ws.AgentInfo;
import com.gridnine.hotels.web.ws.CreateReservationQuery;
import com.gridnine.hotels.web.ws.CreditCardInfo;
import com.gridnine.hotels.web.ws.CreditCardTypeWS;
import com.gridnine.hotels.web.ws.CustomerInfo;
import com.gridnine.hotels.web.ws.InvocationContext;
import com.gridnine.hotels.web.ws.PayerInfo;
import com.gridnine.xtrip.common.hotels2.rules.HotelsParametersActions;
import com.gridnine.xtrip.common.hotels2.rules.HotelsParametersProperties;
import com.gridnine.xtrip.common.hotels2.rules.HotelsTargets;
import com.gridnine.xtrip.common.l10n.messages.L10n;
import com.gridnine.xtrip.common.l10n.model.L10nString;
import com.gridnine.xtrip.common.l10n.model.L10nStringHelper;
import com.gridnine.xtrip.common.l10n.model.LocaleHelper;
import com.gridnine.xtrip.common.meta.MetaRegistryHelper;
import com.gridnine.xtrip.common.midoffice.helper.SalesContextHandler;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.Customer;
import com.gridnine.xtrip.common.model.booking.GeneralProductFop;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProduct;
import com.gridnine.xtrip.common.model.cir.CirHelper;
import com.gridnine.xtrip.common.model.dict.AddressType;
import com.gridnine.xtrip.common.model.dict.CommunicationType;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.LegalForm;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.profile.Address;
import com.gridnine.xtrip.common.model.profile.Card;
import com.gridnine.xtrip.common.model.profile.Communication;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.OrganizationIndex;
import com.gridnine.xtrip.common.model.profile.PCIDSSServerExchangeSettings;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.standard.helpers.MessagesHelper;
import com.gridnine.xtrip.common.model.system.CardVendor;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.rules.RuleEngine;
import com.gridnine.xtrip.common.rules.RuleSet;
import com.gridnine.xtrip.common.rules.elements.RuleProxy;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.hotels2.ibus.HotelsAggregatorRequestData;
import com.gridnine.xtrip.server.hotels2.ibus.IBusHotelsContextKeys;
import com.gridnine.xtrip.server.hotels2.ibus.helpers.HotelsHelper;
import com.gridnine.xtrip.server.hotels2.ibus.helpers.HotelsReservationHelper;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.model.helpers.SysLogHelper;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CreateReservationRequestBuilder
extends BaseProcessor {
    private static final String METHOD = "createReservation";
    private static final Locale SEND_PAYER_LOCALE = LocaleHelper.RU_LOCALE;

    public void process(MessageContext ctx) throws Exception {
        EntityContainer bookingCtr = (EntityContainer)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.BOOKING_FILE);
        Reservation reservation = (Reservation)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION);
        SalesContext salesContext = (SalesContext)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.SALES_CONTEXT);
        Card card = (Card)ctx.getObject((Enum)IBusHotelsContextKeys.SABRE_CARD);
        String cirToken = (String)ctx.getObject((Enum)IBusHotelsContextKeys.CIR_TOKEN);
        List list = (List)ctx.getObject((Enum)IBusHotelsContextKeys.PRODUCT_LIST);
        EntityContainer gdsAccount = EntityStorage.get().resolve(reservation.getGdsNameInfo().getOnlineGdsAccount());
        CreateReservationQuery request = CreateReservationRequestBuilder.buildCreateReservationRequest(reservation, list, salesContext, card, cirToken, (EntityReference<BookingFile>)bookingCtr.toReference());
        InvocationContext context = new InvocationContext();
        ArrayList<Object> objects = new ArrayList<Object>();
        objects.add(context);
        objects.add(request);
        ctx.putObject((Enum)IBusMidofficeContextKeys.GDS_ACCOUNT, (Object)gdsAccount);
        ctx.putObject((Enum)IBusHotelsContextKeys.HOTELS_AGGREGATOR_REQUEST_DATA, (Object)new HotelsAggregatorRequestData(objects, METHOD, context));
    }

    private static CreateReservationQuery buildCreateReservationRequest(Reservation reservation, List<HotelProduct> list, SalesContext salesContext, Card card, String cirToken, EntityReference<BookingFile> bookingRef) throws Exception {
        CreateReservationQuery query = new CreateReservationQuery();
        CreateReservationQuery.DictionaryLanguages dictionaryLanguages = new CreateReservationQuery.DictionaryLanguages();
        HotelsHelper.populateDictionaryLanguages(dictionaryLanguages.getEntry());
        query.setDictionaryLanguages(dictionaryLanguages);
        query.setItems(new CreateReservationQuery.Items());
        for (int i = 0; i < list.size(); ++i) {
            query.getItems().getItem().add(HotelsHelper.convert(list.get(i), i));
        }
        query.setMidOfficeOrderId(reservation.getUid());
        HotelsParametersActions hotelActionSet = CreateReservationRequestBuilder.getHotelActionSet(salesContext, reservation);
        query.setAgent(CreateReservationRequestBuilder.buildAgent(salesContext, hotelActionSet));
        query.setAgency(CreateReservationRequestBuilder.buildAgency(salesContext));
        query.setPayer(CreateReservationRequestBuilder.buildPayer(reservation, hotelActionSet, bookingRef));
        query.setCustomer(CreateReservationRequestBuilder.buildCustomer(card, cirToken, reservation));
        return query;
    }

    static HotelsParametersActions getHotelActionSet(SalesContext salesContext, Reservation reservation) throws Exception {
        RuleProxy proxy = new RuleProxy();
        proxy.setProxyType(HotelsTargets.HOTEL_PARAMETERS.getId());
        proxy.setProxyDate(new Date());
        HotelsParametersProperties properties = new HotelsParametersProperties(salesContext, proxy);
        properties.setGdsAccount(reservation.getGdsNameInfo().getOnlineGdsAccount());
        HotelProduct firstProduct = Objects.requireNonNull(HotelsReservationHelper.getFirstProduct(reservation));
        properties.setCountry(firstProduct.getHotelCountry());
        proxy.setPropertySet((Object)properties);
        proxy.setActionSet((Object)new HotelsParametersActions());
        RuleEngine.applyRules(Collections.singletonList(proxy), (RuleSet)SalesContextHandler.get().getRules(salesContext));
        return (HotelsParametersActions)proxy.getActionSet();
    }

    private static AgentInfo buildAgent(SalesContext salesContext, HotelsParametersActions hotelActionSet) {
        AgentInfo agent = new AgentInfo();
        String bookingManagerName = hotelActionSet.getBookingManagerName();
        String bookingManagerEmail = hotelActionSet.getBookingManagerEmail();
        String bookingManagerPhone = hotelActionSet.getBookingManagerPhone();
        EntityContainer agentCtr = EntityStorage.get().resolve(salesContext.getAgent());
        if (TextUtil.nonBlank((String)bookingManagerName)) {
            agent.setName(bookingManagerName);
        } else if (agentCtr != null) {
            agent.setName(L10nStringHelper.getValue((L10nString)((Person)agentCtr.getEntity()).getFirstName(), (Locale)LocaleHelper.RU_LOCALE, (boolean)false) + " " + L10nStringHelper.getValue((L10nString)((Person)agentCtr.getEntity()).getLastName(), (Locale)LocaleHelper.RU_LOCALE, (boolean)false));
        }
        if (TextUtil.nonBlank((String)bookingManagerEmail)) {
            agent.setEmail(bookingManagerEmail);
        } else if (agentCtr != null) {
            agent.setEmail((String)((Person)agentCtr.getEntity()).getCommunications().stream().filter(comm -> CommunicationType.EMAIL == comm.getType()).filter(comm -> TextUtil.nonBlank((String)comm.getSense())).map(Communication::getSense).findFirst().orElse(null));
        }
        if (TextUtil.nonBlank((String)bookingManagerPhone)) {
            agent.setPhone(bookingManagerPhone);
        } else if (agentCtr != null) {
            agent.setPhone((String)((Person)agentCtr.getEntity()).getCommunications().stream().filter(comm -> CommunicationType.WORK_PHONE == comm.getType()).filter(comm -> TextUtil.nonBlank((String)comm.getSense())).map(Communication::getSense).findFirst().orElse(null));
        }
        return agent;
    }

    private static AgencyInfo buildAgency(SalesContext salesContext) {
        AgencyInfo agencyInfo = new AgencyInfo();
        EntityContainer orgCtr = EntityStorage.get().resolve(salesContext.getAgency());
        if (orgCtr != null) {
            Organization agency = (Organization)orgCtr.getEntity();
            agencyInfo.setName(agency.getFullName().toString());
            ProfileHelper.getPhoneCommunications((List)agency.getCommunications()).stream().map(HotelsReservationHelper::buildPhoneInfo).findFirst().ifPresent(arg_0 -> ((AgencyInfo)agencyInfo).setPhoneInfo(arg_0));
        }
        return agencyInfo;
    }

    static PayerInfo buildPayer(Reservation reservation, HotelsParametersActions hotelActionSet, EntityReference<BookingFile> bookingRef) {
        if (!hotelActionSet.isSendPayerInfo()) {
            return null;
        }
        HotelProduct firstProduct = Objects.requireNonNull(HotelsReservationHelper.getFirstProduct(reservation));
        EntityReference payerRef = GeneralProductHelper.getClientFops((BaseProduct)firstProduct).stream().map(GeneralProductFop::getPayer).filter(Objects::nonNull).findFirst().orElse(null);
        EntityContainer payerCnt = EntityStorage.get().resolve(payerRef);
        if (payerCnt != null && !ProfileHelper.isRetailProfile((EntityContainer)payerCnt) && !((Organization)payerCnt.getEntity()).isForeign()) {
            PayerInfo payerInfo = new PayerInfo();
            Organization payer = (Organization)payerCnt.getEntity();
            ArrayList<String> emptyFields = new ArrayList<String>();
            String fullName = L10nStringHelper.getValue((L10nString)payer.getFullName(), (Locale)SEND_PAYER_LOCALE, (boolean)true);
            if (TextUtil.nonBlank((String)fullName)) {
                payerInfo.setName(fullName);
            } else {
                emptyFields.add(MetaRegistryHelper.getDisplayName(OrganizationIndex.class, (String)OrganizationIndex.Property.name.name()));
            }
            String shortName = L10nStringHelper.getValue((L10nString)payer.getShortName(), (Locale)SEND_PAYER_LOCALE, (boolean)true);
            if (TextUtil.nonBlank((String)shortName)) {
                payerInfo.setShortName(shortName);
            } else {
                emptyFields.add(MetaRegistryHelper.getDisplayName(OrganizationIndex.class, (String)OrganizationIndex.Property.shortName.name()));
            }
            boolean individualEntrepreneur = false;
            if (payer.getLegalForm() != null) {
                LegalForm legalForm = (LegalForm)DictionaryCache.get().resolveReference(payer.getLegalForm());
                if (legalForm != null) {
                    individualEntrepreneur = legalForm.isIndividualEntrepreneur();
                }
                payerInfo.setLegalForm(payer.getLegalForm().toString());
                payerInfo.setIndividualEntrepreneur(individualEntrepreneur);
            } else {
                emptyFields.add(MetaRegistryHelper.getDisplayName(OrganizationIndex.class, (String)OrganizationIndex.Property.legalForm.name()));
            }
            String legalAddress = CreateReservationRequestBuilder.getAddressText(payer, AddressType.LEGAL, firstProduct.getIssueDate());
            if (TextUtil.nonBlank((String)legalAddress)) {
                payerInfo.setLegalAddress(legalAddress);
            } else {
                emptyFields.add(AddressType.LEGAL.toString());
            }
            String factAddress = CreateReservationRequestBuilder.getAddressText(payer, AddressType.FACTUAL, firstProduct.getIssueDate());
            if (TextUtil.nonBlank((String)factAddress)) {
                payerInfo.setActualAddress(factAddress);
            }
            if (TextUtil.nonBlank((String)payer.getRegistrationId())) {
                payerInfo.setInn(payer.getRegistrationId());
            } else {
                emptyFields.add(MetaRegistryHelper.getDisplayName(OrganizationIndex.class, (String)OrganizationIndex.Property.registrationId.name()));
            }
            if (!individualEntrepreneur) {
                if (TextUtil.nonBlank((String)payer.getKpp())) {
                    payerInfo.setKpp(payer.getKpp());
                } else {
                    emptyFields.add(MetaRegistryHelper.getDisplayName(OrganizationIndex.class, (String)OrganizationIndex.Property.kpp.name()));
                }
            }
            if (!emptyFields.isEmpty()) {
                String mes = L10n.getWithParams((String)"HOTELS2_FILL_SEND_PAYER_INFO_MANDATORY_FIELDS", (Object[])new Object[]{payer.toString(), String.join((CharSequence)", ", emptyFields)});
                SysLogHelper.audit(bookingRef, (String)"ticket-reservation", (Message[])new Message[]{MessagesHelper.createMessage((MessageType)MessageType.ERROR, (String)mes, (Object[])new Object[0])});
                throw Xeption.forAdmin((String)mes, (Object[])new Object[0]);
            }
            return payerInfo;
        }
        return null;
    }

    private static String getAddressText(Organization payer, AddressType addressType, Date date) {
        return ProfileHelper.getOrganizationAddresses((Organization)payer, (Date)date).stream().filter(address -> address.getAddressType() == addressType).map(address -> ProfileHelper.buildShortAddress((Address)address, (Locale)SEND_PAYER_LOCALE, (boolean)true)).filter(TextUtil::nonBlank).findFirst().orElse(null);
    }

    private static CustomerInfo buildCustomer(Card card, String cirToken, Reservation reservation) {
        CustomerInfo customerInfo = new CustomerInfo();
        Customer customer = reservation.getBookingFile().getCustomer();
        if (null == customer) {
            return customerInfo;
        }
        customerInfo.setName(customer.getName());
        if (TextUtil.isBlank((String)customerInfo.getName())) {
            throw Xeption.forEndUser((String)"\u041d\u0435 \u0437\u0430\u043f\u043e\u043b\u043d\u0435\u043d\u043d\u043e \u0438\u043c\u044f \u043a\u043b\u044e\u0447\u0435\u0432\u043e\u0433\u043e \u043a\u043e\u043d\u0442\u0430\u043a\u0442\u043d\u043e\u0433\u043e \u043b\u0438\u0446\u0430", (Object[])new Object[0]);
        }
        Optional.ofNullable(ProfileHelper.filterCommunications((Collection)customer.getCommunications(), (CommunicationType)CommunicationType.EMAIL)).ifPresent(email -> customerInfo.setEmail(email.getSense()));
        if (TextUtil.isBlank((String)customerInfo.getEmail())) {
            throw Xeption.forEndUser((String)"\u041d\u0435 \u0437\u0430\u043f\u043e\u043b\u043d\u0435\u043d email \u043a\u043b\u044e\u0447\u0435\u0432\u043e\u0433\u043e \u043a\u043e\u043d\u0442\u0430\u043a\u0442\u043d\u043e\u0433\u043e \u043b\u0438\u0446\u0430", (Object[])new Object[0]);
        }
        ProfileHelper.getPhoneCommunications((List)customer.getCommunications()).stream().map(HotelsReservationHelper::buildPhoneInfo).findFirst().ifPresent(arg_0 -> ((CustomerInfo)customerInfo).setPhoneInfo(arg_0));
        if (card != null) {
            CreditCardInfo cardInfo = new CreditCardInfo();
            customerInfo.setCreditCardInfo(cardInfo);
            PCIDSSServerExchangeSettings settings = CirHelper.getSettings();
            if (!CirHelper.cirEnabled((PCIDSSServerExchangeSettings)settings)) {
                throw Xeption.forAdmin((String)"CIR \u043d\u0435 \u043d\u0430\u0441\u0442\u0440\u043e\u0435\u043d. \u041d\u0435\u043b\u044c\u0437\u044f \u043f\u043e\u043b\u0443\u0447\u0438\u0442\u044c \u0434\u0430\u043d\u043d\u044b\u0435 \u043f\u043e \u043a\u0430\u0440\u0442\u0435.", (Object[])new Object[0]);
            }
            Calendar calendar = Calendar.getInstance();
            calendar.clear();
            calendar.setTime(card.getExpiration());
            cardInfo.setCirAddress(settings.getServerAddress());
            cardInfo.setAgencyToken(cirToken);
            cardInfo.setId(card.getCirUid());
            cardInfo.setType(CreateReservationRequestBuilder.getCardType(card.getVendor()));
            cardInfo.setExpiryMonth(calendar.get(2) + 1);
            cardInfo.setExpiryYear(calendar.get(1));
            Matcher matcher = Pattern.compile("\\A(.*)\\s+(\\S+)\\z").matcher(card.getNameOnCard());
            if (matcher.matches()) {
                cardInfo.setFirstName(matcher.group(1));
                cardInfo.setLastName(matcher.group(2));
            } else {
                cardInfo.setFirstName("");
                cardInfo.setLastName(card.getNameOnCard());
            }
        }
        return customerInfo;
    }

    private static CreditCardTypeWS getCardType(CardVendor vendor) {
        if (null == vendor) {
            throw new NullPointerException("\u0422\u0438\u043f \u043a\u0430\u0440\u0442\u044b \u043d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d");
        }
        switch (vendor) {
            case VISA: {
                return CreditCardTypeWS.VISA;
            }
            case MASTERCARD: {
                return CreditCardTypeWS.MASTER_CARD;
            }
            case AMEX: {
                return CreditCardTypeWS.AMERICAN_EXPRESS;
            }
            case DINERS_CLUB: {
                return CreditCardTypeWS.DINERS_CLUB;
            }
        }
        throw Xeption.forDeveloper((String)("\u041d\u0435 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u043c\u044b\u0439 \u0430\u0433\u0440\u0435\u0433\u0430\u0442\u043e\u0440\u043e\u043c \u0442\u0438\u043f \u043a\u0430\u0440\u0442\u044b " + vendor.name()), (Object[])new Object[0]);
    }
}

