/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.hotels2.ibus.createReservation;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.hotels.web.ws.ReservationItem;
import com.gridnine.hotels.web.ws.ReservationResult;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProduct;
import com.gridnine.xtrip.common.model.booking.xtriphotels.Room;
import com.gridnine.xtrip.common.model.booking.xtriphotels.service.HotelsServiceAvailability;
import com.gridnine.xtrip.common.model.helpers.BookingStreamHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.rules.standard.hotelProductSettings.HotelProductSettingsActionSet;
import com.gridnine.xtrip.common.rules.elements.RuleProxy;
import com.gridnine.xtrip.server.hotels2.ibus.IBusHotelsContextKeys;
import com.gridnine.xtrip.server.hotels2.ibus.helpers.HotelsHelper;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.model.handlers.rules.hotel.HotelRulesHelper;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang.BooleanUtils;

public class CreateReservationResultParser
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        Reservation reservation = (Reservation)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION);
        List list = (List)ctx.getMandatoryObject((Enum)IBusHotelsContextKeys.PRODUCT_LIST);
        ReservationResult reservationResult = (ReservationResult)ctx.getMandatoryObject((Enum)IBusHotelsContextKeys.HOTELS_AGGREGATOR_RESPONSE);
        boolean immediateConfirmation = BookingStreamHelper.getProductsStream((Reservation)reservation, HotelProduct.class).map(HotelProduct::getRooms).flatMap(Collection::stream).map(Room::getAvailability).filter(Objects::nonNull).map(HotelsServiceAvailability::getImmediateConfirmation).anyMatch(BooleanUtils::isTrue);
        HotelsHelper.updateReservation(reservation, reservationResult);
        for (ReservationItem item : reservationResult.getReservationItems().getReservationItems()) {
            HotelProduct hp = (HotelProduct)list.get(Integer.parseInt(item.getRequestItemId()));
            Integer standardCheckInTime = ((Room)hp.getRooms().get(0)).getStandardCheckInTime();
            Integer standardCheckOutTime = ((Room)hp.getRooms().get(0)).getStandardCheckOutTime();
            HotelsHelper.updateReservedHotelProduct(hp, item, reservationResult, null, HotelsHelper.convertTime(standardCheckInTime), HotelsHelper.convertTime(standardCheckOutTime), null, arg_0 -> ((MessageContext)ctx).addMessage(arg_0));
            HotelsHelper.updateProductSystemNumber(hp);
            if (reservationResult.getReservationId() != null) {
                hp.setPcc(reservationResult.getReservationId().getPcc());
            }
            RuleProxy ruleProxy = HotelRulesHelper.applyHotelProductSettingsRules((HotelProduct)hp);
            HotelsHelper.fillContractData(hp, (HotelProductSettingsActionSet)ruleProxy.getActionSet());
        }
        Set productStatuses = BookingStreamHelper.getProductsStream((Reservation)reservation, HotelProduct.class).map(GeneralProductHelper::getStatus).collect(Collectors.toSet());
        if (immediateConfirmation && productStatuses.contains(ProductStatus.REQUEST)) {
            reservation.setImmediateConfirmationFailed(true);
        }
    }
}

