/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.hotels2.ibus.createReservation;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProduct;
import com.gridnine.xtrip.common.model.cir.CirHelper;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.l10n.Messages;
import com.gridnine.xtrip.common.model.profile.Card;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.PCIDSSServerExchangeSettings;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.hotels2.ibus.IBusHotelsContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class GetProfileSabreCardProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        MiscUtil.Pair info;
        List products = (List)ctx.getObject((Enum)IBusHotelsContextKeys.PRODUCT_LIST);
        String cardUid = (String)ctx.getObject((Enum)IBusHotelsContextKeys.CARBE_CARD_UID);
        if (TextUtil.isBlank((String)cardUid)) {
            return;
        }
        Card card = null;
        EntityReference ref = null;
        if (!products.isEmpty()) {
            EntityReference clientRef = ((HotelProduct)products.get(0)).getReservation().getBookingFile().getCustomerProfile();
            EntityContainer client = EntityStorage.get().resolve(clientRef);
            card = (Card)CollectionUtil.find((Iterable)((Organization)client.getEntity()).getCards(), (String)cardUid);
            ref = clientRef;
        }
        if (null == card && (info = (MiscUtil.Pair)products.stream().flatMap(p -> p.getTravellers().stream()).map(Traveller::getPassenger).map(p -> {
            EntityContainer person = EntityStorage.get().resolve(p);
            if (null == person) {
                return null;
            }
            Card c = (Card)CollectionUtil.find((Iterable)((Person)person.getEntity()).getCards(), (String)cardUid);
            return c != null ? new MiscUtil.Pair((Object)c, p) : null;
        }).filter(Objects::nonNull).findFirst().orElse(null)) != null) {
            card = (Card)info.getFirst();
            ref = (EntityReference)info.getSecond();
        }
        if (null == card) {
            throw Xeption.forEndUser((String)"\u041a\u0430\u0440\u0442\u0430 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430", (Object[])new Object[0]);
        }
        PCIDSSServerExchangeSettings settings = CirHelper.getSettings();
        if (!CirHelper.cirEnabled((PCIDSSServerExchangeSettings)settings)) {
            throw Xeption.forAdmin((String)Messages.cirSettingsNotEnabled, (Object[])new Object[0]);
        }
        String cirToken = Optional.ofNullable(CirHelper.cirToken((PCIDSSServerExchangeSettings)settings, ref)).map(MiscUtil.Pair::getSecond).orElse(null);
        ctx.putObject((Enum)IBusHotelsContextKeys.SABRE_CARD, (Object)card);
        ctx.putObject((Enum)IBusHotelsContextKeys.CIR_TOKEN, (Object)cirToken);
    }
}

