/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.hotels2.ibus.createReservation;

import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProduct;
import com.gridnine.xtrip.common.model.cir.CirHelper;
import com.gridnine.xtrip.common.model.l10n.Messages;
import com.gridnine.xtrip.common.model.profile.PCIDSSServerExchangeSettings;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.hotels2.ibus.IBusHotelsContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class GetTempSabreCardProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        String cirUid = (String)ctx.getMandatoryObject((Enum)IBusHotelsContextKeys.TEMP_CARD_CIR_UID);
        List products = (List)ctx.getObject((Enum)IBusHotelsContextKeys.PRODUCT_LIST);
        PCIDSSServerExchangeSettings settings = CirHelper.getSettings();
        if (!CirHelper.cirEnabled((PCIDSSServerExchangeSettings)settings)) {
            throw Xeption.forAdmin((String)Messages.cirSettingsNotEnabled, (Object[])new Object[0]);
        }
        String cirToken = null;
        if (!products.isEmpty()) {
            EntityReference clientRef = ((HotelProduct)products.get(0)).getReservation().getBookingFile().getCustomerProfile();
            cirToken = Optional.ofNullable(CirHelper.cirToken((PCIDSSServerExchangeSettings)settings, (EntityReference)clientRef)).map(MiscUtil.Pair::getSecond).orElse(null);
        }
        if (cirToken == null) {
            cirToken = products.stream().flatMap(p -> p.getTravellers().stream()).map(Traveller::getPassenger).filter(Objects::nonNull).map(p -> CirHelper.cirToken((PCIDSSServerExchangeSettings)settings, (EntityReference)p)).filter(Objects::nonNull).map(MiscUtil.Pair::getSecond).filter(Objects::nonNull).findFirst().orElse(null);
        }
        ctx.putObject((Enum)IBusHotelsContextKeys.SABRE_CARD, (Object)CirHelper.getCardByCirUid((String)cirUid, cirToken));
        ctx.putObject((Enum)IBusHotelsContextKeys.CIR_TOKEN, cirToken);
    }
}

