/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.hotels2.ibus.findReservations;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.hotels.web.ws.FindReservationResult;
import com.gridnine.xtrip.common.hotels2.model.HotelsAggregatorGdsAccount;
import com.gridnine.xtrip.common.hotels2.model.ReservationInfo;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProvider;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.server.hotels2.ibus.IBusHotelsContextKeys;
import com.gridnine.xtrip.server.hotels2.ibus.helpers.HotelsBaseHelper;
import com.gridnine.xtrip.server.hotels2.ibus.helpers.HotelsHelper;
import com.gridnine.xtrip.server.hotels2.ibus.helpers.HotelsReservationHelper;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.stream.Collectors;

public class FindReservationsResponseParser
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        FindReservationResult response = (FindReservationResult)ctx.getMandatoryObject((Enum)IBusHotelsContextKeys.HOTELS_AGGREGATOR_RESPONSE);
        EntityContainer account = (EntityContainer)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.GDS_ACCOUNT);
        ctx.putObject((Enum)IBusHotelsContextKeys.HOTELS_FIND_RESERVATIONS_RESULT, CollectionUtil.isEmpty((Collection)response.getItems()) ? new ArrayList() : response.getItems().stream().map(item -> this.convertReservationInfo((com.gridnine.hotels.web.ws.ReservationInfo)item, ((HotelsAggregatorGdsAccount)account.getEntity()).getProvider())).collect(Collectors.toList()));
    }

    private ReservationInfo convertReservationInfo(com.gridnine.hotels.web.ws.ReservationInfo info, HotelProvider provider) {
        int i;
        ReservationInfo result = new ReservationInfo();
        result.setRegistrationDate(HotelsBaseHelper.toLocalDate(info.getRegistrationDate()));
        result.setBasePrice(HotelsBaseHelper.convertMoneyFromGds(info.getPrice()));
        result.setVatAmount(info.getVatAmount());
        result.setPenaltyAmount(HotelsBaseHelper.convertMoneyFromGds(info.getPenaltyAmount()));
        result.setCheckInDate(HotelsBaseHelper.toLocalDate(info.getCheckinDate()));
        result.setCheckOutDate(HotelsBaseHelper.toLocalDate(info.getCheckoutDate()));
        result.setHotelCommission(HotelsReservationHelper.buildHotelCommission(info.getCommission(), result.getBasePrice()));
        if (info.getStatusInfo() != null) {
            result.setStatus(HotelsBaseHelper.convertToProductStatus(info.getStatusInfo()));
            result.setProviderStatusInfo(info.getStatusInfo().getStatusText());
        }
        result.setRecordLocator(info.getReferenceNumber());
        String reservationNumber = info.getReservationNumber();
        if (reservationNumber != null && reservationNumber.contains("-") && (i = reservationNumber.indexOf("-")) > 0) {
            reservationNumber = reservationNumber.substring(0, i);
        }
        result.setRecordLocatorProvider(reservationNumber);
        result.setProvider(provider);
        result.setAccountLogin(info.getAccountLogin());
        result.setContactPerson(info.getContactPerson() != null ? info.getContactPerson().getName() : null);
        if (!CollectionUtil.isEmpty((Collection)info.getGuest())) {
            result.getTravellers().addAll(info.getGuest().stream().map(HotelsReservationHelper::buildTraveller).collect(Collectors.toList()));
        }
        result.setSubProvider(HotelsHelper.findSubProvider(provider, info.getDisplayVendor()));
        return result;
    }
}

