/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.hotels2.ibus.getGeoLocationLogs;

import com.gridnine.hotels.web.ws.GeoLocationLog;
import com.gridnine.hotels.web.ws.GeoLocationLogsResult;
import com.gridnine.hotels.web.ws.Operation;
import com.gridnine.xtrip.common.hotels2.model.HotelAggregatorGeoLocationLogs;
import com.gridnine.xtrip.common.hotels2.model.HotelAggregatorGeoLocationLogsDeletedItem;
import com.gridnine.xtrip.common.hotels2.model.HotelAggregatorGeoLocationLogsMovedItem;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.hotels2.ibus.IBusHotelsContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import javax.xml.datatype.XMLGregorianCalendar;

public class GetGeoLocationLogsResponseParser
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        GeoLocationLogsResult response = (GeoLocationLogsResult)ctx.getMandatoryObject((Enum)IBusHotelsContextKeys.HOTELS_AGGREGATOR_RESPONSE);
        ctx.putObject((Enum)IBusHotelsContextKeys.HOTELS_GET_GEOLOCATION_LOGS_RESULT, (Object)this.buildGeoLocationLogs(response));
    }

    private HotelAggregatorGeoLocationLogs buildGeoLocationLogs(GeoLocationLogsResult response) {
        HotelAggregatorGeoLocationLogs result = new HotelAggregatorGeoLocationLogs();
        for (GeoLocationLog logItem : response.getGeoLocationLogs()) {
            if (logItem.getOperation() == Operation.DELETE) {
                result.getDeleted().add(this.buildDeletedItem(logItem));
                continue;
            }
            if (logItem.getOperation() != Operation.MOVE) continue;
            result.getMoved().add(this.buildMovedItem(logItem));
        }
        return result;
    }

    private HotelAggregatorGeoLocationLogsDeletedItem buildDeletedItem(GeoLocationLog logItem) {
        HotelAggregatorGeoLocationLogsDeletedItem result = new HotelAggregatorGeoLocationLogsDeletedItem();
        this.fillCommonValues(logItem, result);
        return result;
    }

    private void fillCommonValues(GeoLocationLog logItem, HotelAggregatorGeoLocationLogsDeletedItem result) {
        result.setSystemCode(logItem.getSystemCode());
        result.setOperationDate(MiscUtil.toDateWithoutTimeZone((XMLGregorianCalendar)logItem.getOperationDate()));
    }

    private HotelAggregatorGeoLocationLogsMovedItem buildMovedItem(GeoLocationLog logItem) {
        HotelAggregatorGeoLocationLogsMovedItem result = new HotelAggregatorGeoLocationLogsMovedItem();
        this.fillCommonValues(logItem, (HotelAggregatorGeoLocationLogsDeletedItem)result);
        result.setTargetSystemCode(logItem.getTargetSystemCode());
        return result;
    }
}

