/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.hotels2.ibus.getHotelFolder;

import com.gridnine.hotels.web.ws.GeoLocation;
import com.gridnine.hotels.web.ws.GetHotelFolderInfoResponse;
import com.gridnine.hotels.web.ws.GetHotelFolderInfoResponseMessage;
import com.gridnine.hotels.web.ws.TranslationEntry;
import com.gridnine.xtrip.common.hotels2.model.HotelsFolderInfo;
import com.gridnine.xtrip.common.l10n.model.L10nString;
import com.gridnine.xtrip.common.l10n.model.L10nStringHelper;
import com.gridnine.xtrip.common.l10n.model.LocaleHelper;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProvider;
import com.gridnine.xtrip.common.model.profile.Address;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.hotels2.ibus.IBusHotelsContextKeys;
import com.gridnine.xtrip.server.hotels2.ibus.helpers.HotelsBaseHelper;
import com.gridnine.xtrip.server.hotels2.ibus.helpers.HotelsHelper;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class GetHotelFolderInfoResponseParser
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        GetHotelFolderInfoResponseMessage response = (GetHotelFolderInfoResponseMessage)ctx.getMandatoryObject((Enum)IBusHotelsContextKeys.HOTELS_AGGREGATOR_RESPONSE);
        ctx.putObject((Enum)IBusHotelsContextKeys.HOTELS_HOTEL_FOLDER, (Object)this.buildHotelFoldersInfo(response.getResponse()));
    }

    private HotelsFolderInfo buildHotelFoldersInfo(GetHotelFolderInfoResponse response) {
        HotelsFolderInfo result = new HotelsFolderInfo();
        response.getHotelNameTranslations().forEach(te -> this.putTranslationEntryToL10n(result.getName(), (TranslationEntry)te));
        result.setHotelStars(HotelsBaseHelper.convertHotelCategoryFromGds(response.getCategory()));
        result.setDefaultCheckInTime(HotelsBaseHelper.toLocalTime(response.getDefaultCheckInTime()));
        result.setDefaultCheckOutTime(HotelsBaseHelper.toLocalTime(response.getDefaultCheckOutTime()));
        result.setAddress(this.buildAddress(response.getLocation(), response.getAdressTranslations()));
        HotelsHelper.fillContacts(result.getContacts(), response.getContact());
        if (response.getVendorCodeMap() != null) {
            response.getVendorCodeMap().getEntry().forEach(entry -> this.putVendorCode(result.getVendorCodes(), (GetHotelFolderInfoResponse.VendorCodeMap.Entry)entry));
        }
        return result;
    }

    private Address buildAddress(GeoLocation wsLocation, List<TranslationEntry> wsAddressTranslations) {
        Address result = HotelsHelper.convertToAddress(wsLocation);
        wsAddressTranslations.forEach(te -> this.putTranslationEntryToL10n(result.getAddress(), (TranslationEntry)te));
        return result;
    }

    private void putTranslationEntryToL10n(L10nString l10nStr, TranslationEntry wsTranslationEntry) {
        if (TextUtil.isBlank((String)wsTranslationEntry.getValue())) {
            return;
        }
        Locale locale = LocaleHelper.parse((String)wsTranslationEntry.getLang());
        if (locale == null) {
            return;
        }
        L10nStringHelper.setValue((L10nString)l10nStr, (String)wsTranslationEntry.getValue(), (Locale)locale);
    }

    private void putVendorCode(Map<HotelProvider, String> vendorCodeMap, GetHotelFolderInfoResponse.VendorCodeMap.Entry entry) {
        if (TextUtil.isBlank((String)entry.getValue())) {
            return;
        }
        HotelProvider provider = HotelsBaseHelper.convertProviderFromGds(entry.getKey());
        if (provider == null) {
            return;
        }
        vendorCodeMap.put(provider, entry.getValue());
    }
}

