/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.hotels2.ibus.getImage;

import com.gridnine.xtrip.common.hotels2.HotelAggregatorSettings;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.util.Base64;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.hotels2.ibus.IBusHotelsContextKeys;
import com.gridnine.xtrip.server.hotels2.ibus.helpers.HotelsHelper;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import org.apache.commons.io.IOUtils;

public class GetImageProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        byte[] result;
        String uid = (String)ctx.getMandatoryObject((Enum)IBusHotelsContextKeys.HOTELS_GET_IMAGES_PARAM);
        EntityContainer<HotelAggregatorSettings> settingsCtr = (EntityContainer<HotelAggregatorSettings>)ctx.getObject((Enum)IBusHotelsContextKeys.HOTELS_AGGREGATOR_SETTINGS);
        if (settingsCtr == null) {
            settingsCtr = HotelsHelper.getHotelAggregatorSettings();
        }
        HotelAggregatorSettings settings = (HotelAggregatorSettings)settingsCtr.getEntity();
        String authString = settings.getUser() + ":" + settings.getPassword();
        String authEncBytes = Base64.encode((byte[])authString.getBytes());
        URL url = new URL(settings.getDocumentsUrl() + "?uid=" + uid);
        URLConnection urlConnection = url.openConnection();
        urlConnection.setRequestProperty("Authorization", "Basic " + authEncBytes);
        try (InputStream strm = urlConnection.getInputStream();){
            result = IOUtils.toByteArray((InputStream)strm);
        }
        catch (Exception t) {
            this.log.error("GET " + url + TextUtil.getExceptionStackTrace((Throwable)t));
            result = new byte[]{};
        }
        ctx.putObject((Enum)IBusHotelsContextKeys.HOTELS_AGGREGATOR_RESPONSE, (Object)result);
    }
}

