/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.hotels2.ibus.getLocations;

import com.gridnine.hotels.web.ws.GeoLocationDictionary;
import com.gridnine.hotels.web.ws.GeoLocationExtInfo;
import com.gridnine.xtrip.common.model.dict.Country;
import com.gridnine.xtrip.common.model.dict.GeoLocation;
import com.gridnine.xtrip.server.hotels2.ibus.IBusHotelsContextKeys;
import com.gridnine.xtrip.server.hotels2.ibus.helpers.HotelsBaseHelper;
import com.gridnine.xtrip.server.hotels2.ibus.tasks.getGeoLocations.GetGeoLocationsResponseProcessor;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class GetLocationsResponseParser
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        GeoLocationDictionary response = (GeoLocationDictionary)ctx.getMandatoryObject((Enum)IBusHotelsContextKeys.HOTELS_AGGREGATOR_RESPONSE);
        ctx.putObject((Enum)IBusHotelsContextKeys.HOTELS_GEO_LOCATIONS, this.parseLocations(response));
    }

    private List<GeoLocation> parseLocations(GeoLocationDictionary response) {
        return response.getGeolocations().getGeolocation().stream().map(gl -> {
            GeoLocation result = new GeoLocation();
            Optional.ofNullable(gl.getLocation()).map(GeoLocationExtInfo::getLocation).ifPresent(loc -> {
                result.setLongitude(loc.getLongitude());
                result.setLatitude(loc.getLatitude());
                result.setType(HotelsBaseHelper.convertGeoLocationTypeFromGds(loc.getType()));
                result.setCountry(HotelsBaseHelper.getDictReference(Country.class, loc.getCountry().getCode()));
            });
            GetGeoLocationsResponseProcessor.updateTranslations(gl.getLocation(), result);
            return result;
        }).collect(Collectors.toList());
    }
}

