/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.hotels2.ibus.helpers;

import com.gridnine.hotels.web.ws.CancellationPeriodWS;
import com.gridnine.hotels.web.ws.CancellationPolicyWS;
import com.gridnine.hotels.web.ws.HotelOffer;
import com.gridnine.hotels.web.ws.HotelsDateTimeSpecialValue;
import com.gridnine.hotels.web.ws.HotelsMoney;
import com.gridnine.hotels.web.ws.LocalDateTimeWS;
import com.gridnine.hotels.web.ws.PricedItem;
import com.gridnine.hotels.web.ws.PricingItem;
import com.gridnine.hotels.web.ws.Provider;
import com.gridnine.xtrip.common.hotels2.model.CancellablePolicy;
import com.gridnine.xtrip.common.hotels2.model.CancellationChargeHolder;
import com.gridnine.xtrip.common.hotels2.model.CancellationPolicy;
import com.gridnine.xtrip.common.hotels2.model.NonCancellablePolicy;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.xtriphotels.CancellationCharge;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProduct;
import com.gridnine.xtrip.common.model.booking.xtriphotels.Room;
import com.gridnine.xtrip.common.model.helpers.CancellationChargeHelper;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.util.BooleanUtil;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.ExceptionUtil;
import com.gridnine.xtrip.common.util.HotelsTimeUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.XCloneHelper;
import com.gridnine.xtrip.common.util.XCloneable;
import com.gridnine.xtrip.server.hotels2.ibus.helpers.HotelsBaseHelper;
import com.gridnine.xtrip.server.hotels2.ibus.helpers.VatHelper;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.TimeZone;
import java.util.stream.Collectors;
import javax.xml.datatype.XMLGregorianCalendar;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;

public class CancellationPolicyHelper {
    private static final ZoneOffset SYSTEM_ZONE_OFFSET = OffsetDateTime.now(ZoneId.systemDefault()).getOffset();

    public static CancellationPolicy cancellationPolicy(HotelOffer wsOffer, TimeZone hotelCityTimeZone) {
        ZoneId zoneId = CancellationPolicyHelper.getZoneId(hotelCityTimeZone);
        OffsetDateTime now = OffsetDateTime.now(zoneId);
        return CancellationPolicyHelper.cancellationPolicy(now, wsOffer);
    }

    public static CancellationPolicy cancellationPolicy(PricingItem wsPricingItem, TimeZone hotelCityTimeZone, Provider provider) {
        ZoneId zoneId = CancellationPolicyHelper.getZoneId(hotelCityTimeZone);
        OffsetDateTime now = OffsetDateTime.now(zoneId);
        return CancellationPolicyHelper.cancellationPolicy(now, wsPricingItem, provider);
    }

    private static CancellationPolicy cancellationPolicy(OffsetDateTime now, HotelOffer wsOffer) {
        CancellationPolicy cancellationPolicy = null;
        try {
            cancellationPolicy = CancellationPolicyHelper.convertHotelsCancellationPolicy(wsOffer.getCancellationPolicy(), wsOffer.getStayPolicy().getCheckIn().getDate(), now, BooleanUtils.isTrue((Boolean)VatHelper.isVatIncluded(wsOffer)));
        }
        catch (NullPointerException ex) {
            throw new NullPointerException(String.format("provider: %s, hotelCardNumber: %s, error stack: %s", wsOffer.getProvider(), wsOffer.getHotelCardNumber(), TextUtil.getExceptionStackTrace((Throwable)ex)));
        }
        catch (IllegalArgumentException ex) {
            throw new IllegalArgumentException("Hotel id: " + wsOffer.getHotelCardNumber() + " Provider: " + wsOffer.getProvider().name() + " RoomName: " + wsOffer.getRoomName(), ex);
        }
        return cancellationPolicy;
    }

    private static CancellationPolicy cancellationPolicy(OffsetDateTime now, PricingItem wsPricingItem, Provider provider) {
        CancellationPolicy cancellationPolicy = null;
        try {
            cancellationPolicy = CancellationPolicyHelper.convertHotelsCancellationPolicy(wsPricingItem.getCancellationPolicy(), wsPricingItem.getStayPolicy().getCheckIn().getDate(), now, BooleanUtils.isTrue((Boolean)VatHelper.isVatIncluded((PricedItem)wsPricingItem)));
        }
        catch (NullPointerException ex) {
            throw new NullPointerException(String.format("provider: %s, hotelCardNumber: %s, error stack: %s", provider, wsPricingItem.getHotelCardNumber(), TextUtil.getExceptionStackTrace((Throwable)ex)));
        }
        catch (IllegalArgumentException ex) {
            throw new IllegalArgumentException("Hotel id: " + wsPricingItem.getHotelCardNumber() + " Provider: " + provider.name() + " RoomName: " + wsPricingItem.getRoomName(), ex);
        }
        return cancellationPolicy;
    }

    private static CancellationPolicy convertHotelsCancellationPolicy(CancellationPolicyWS source, XMLGregorianCalendar checkInDate, OffsetDateTime now, boolean includeVat) {
        boolean isNonCancellablePresent;
        if (source == null) {
            return null;
        }
        boolean bl = isNonCancellablePresent = source.getPeriod() != null && source.getPeriod().stream().anyMatch(period -> period.isCancellable() == false);
        if (isNonCancellablePresent) {
            List validPeriods = source.getPeriod().stream().filter(period -> {
                OffsetDateTime periodOffsetDateTime;
                return period.getTo().getValue() != null || !(periodOffsetDateTime = CancellationPolicyHelper.toOffsetDateTime(period.getTo(), now.getOffset())).isBefore(now);
            }).collect(Collectors.toList());
            boolean hasNonCancellable = false;
            boolean hasCancellable = false;
            for (CancellationPeriodWS period2 : validPeriods) {
                if (period2.isCancellable().booleanValue() || period2.getPenalty() != null && !BooleanUtil.nullAsFalse((Boolean)period2.getPenalty().isUnknown())) {
                    hasCancellable = true;
                    continue;
                }
                hasNonCancellable = true;
            }
            if (!hasCancellable && hasNonCancellable) {
                return new NonCancellablePolicy();
            }
            if (!hasCancellable && !hasNonCancellable) {
                throw Xeption.forDeveloper((String)"No policies at all???", (Object[])new Object[0]);
            }
        }
        CancellablePolicy result = new CancellablePolicy();
        if (!CancellationPolicyHelper.isUnknown(source)) {
            CancellationChargeHolder holder = new CancellationChargeHolder();
            Date checkIn = HotelsBaseHelper.toDate(checkInDate);
            Date nowDate = new Date(now.toInstant().toEpochMilli());
            for (CancellationPeriodWS period2 : source.getPeriod()) {
                if (period2.getFrom().getValue() == HotelsDateTimeSpecialValue.NEGATIVE_INFINITY && period2.getTo().getValue() == null && CancellationPolicyHelper.noPenalty(period2)) {
                    Date date = CancellationPolicyHelper.convertDateTimeToOld(period2.getTo());
                    holder.setFreeCancellationTerm(date);
                    continue;
                }
                CancellationCharge charge = CancellationPolicyHelper.convertHotelsCancellationPeriodToCharge(period2, includeVat);
                if (charge == null) continue;
                CancellationPolicyHelper.fixDates(charge, nowDate, checkIn);
                holder.getCancellationCharges().add(charge);
            }
            result.setCancellationChargesHolder(holder);
        }
        result.setCancellableNow(source.isCancellableNow());
        result.setText(source.getText());
        return result;
    }

    private static boolean isUnknown(CancellationPolicyWS wsValue) {
        return CollectionUtil.isEmpty((Collection)wsValue.getPeriod());
    }

    public static boolean isWithTime(LocalDateTimeWS wsValue) {
        if (wsValue.getValue() != null) {
            return false;
        }
        LocalDateTime dateTime = CancellationPolicyHelper.toLocalDateTime(wsValue);
        return dateTime.getHour() > 0 || dateTime.getMinute() > 0;
    }

    private static OffsetDateTime toOffsetDateTime(LocalDateTimeWS wsValue, ZoneOffset defaultZoneOffset) {
        OffsetDateTime result;
        String dateString = wsValue.getDate();
        if (CancellationPolicyHelper.hasOffsetData(wsValue)) {
            result = OffsetDateTime.parse(dateString, CancellationPolicyHelper.formatter(true));
        } else {
            LocalDateTime dateTime = LocalDateTime.parse(dateString, CancellationPolicyHelper.formatter(false));
            result = OffsetDateTime.of(dateTime, defaultZoneOffset);
        }
        return result;
    }

    private static LocalDateTime toLocalDateTime(LocalDateTimeWS wsValue) {
        DateTimeFormatter formatter = CancellationPolicyHelper.formatter(CancellationPolicyHelper.hasOffsetData(wsValue));
        return LocalDateTime.parse(wsValue.getDate(), formatter);
    }

    private static DateTimeFormatter formatter(boolean hasOffsetData) {
        return hasOffsetData ? DateTimeFormatter.ISO_OFFSET_DATE_TIME : DateTimeFormatter.ISO_LOCAL_DATE_TIME;
    }

    public static boolean hasOffsetData(LocalDateTimeWS wsValue) {
        String dateString = wsValue.getDate();
        return dateString != null && dateString.length() > 19;
    }

    private static CancellationCharge convertHotelsCancellationPeriodToCharge(CancellationPeriodWS source, boolean includeVat) {
        Objects.requireNonNull(source, "source");
        Objects.requireNonNull(source.getFrom(), "source.from");
        Objects.requireNonNull(source.getTo(), "source.to");
        if (source.getPenalty() == null || CancellationPolicyHelper.noPenalty(source)) {
            return null;
        }
        boolean withTime = CancellationPolicyHelper.isWithTime(source.getFrom()) || CancellationPolicyHelper.isWithTime(source.getTo());
        boolean timeZoneIsUnknown = !CancellationPolicyHelper.hasOffsetData(source.getFrom()) && !CancellationPolicyHelper.hasOffsetData(source.getTo());
        HotelsMoney sourcePenalty = source.getPenalty();
        CancellationCharge result = new CancellationCharge();
        result.setEndDate(CancellationPolicyHelper.convertDateTimeToOld(source.getTo()));
        if (!BooleanUtil.nullAsFalse((Boolean)sourcePenalty.isUnknown())) {
            Money money = HotelsBaseHelper.convertMoneyFromGds(source.getPenalty());
            CancellationChargeHelper.fillCancellationCharge((CancellationCharge)result, (Money)money, (boolean)includeVat);
        }
        result.setStartDate(CancellationPolicyHelper.convertDateTimeToOld(source.getFrom()));
        result.setTimeZoneIsUnknown(Boolean.valueOf(timeZoneIsUnknown));
        result.setWithTime(withTime);
        if (!BooleanUtil.nullAsFalse((Boolean)source.isCancellable())) {
            result.setNotAvailableViaAPI(Boolean.TRUE);
        }
        return result;
    }

    private static boolean noPenalty(CancellationPeriodWS source) {
        HotelsMoney sourcePenalty = source.getPenalty();
        return !BooleanUtil.nullAsFalse((Boolean)sourcePenalty.isUnknown()) && sourcePenalty.getAmount().compareTo(BigDecimal.ZERO) == 0;
    }

    public static void fixDates(CancellationCharge cc, Date bookingDate, Date checkIn) {
        if (cc.getStartDate() == null) {
            cc.setStartDate(MiscUtil.minimum((Date[])new Date[]{bookingDate, checkIn}));
        }
        if (cc.getEndDate() == null) {
            cc.setEndDate(MiscUtil.maximum((Date[])new Date[]{bookingDate, checkIn}));
        }
    }

    public static ZoneId getZoneId(TimeZone defaultTimeZone) {
        return defaultTimeZone != null ? defaultTimeZone.toZoneId() : ZoneId.systemDefault();
    }

    private static Date convertDateTimeToOld(LocalDateTimeWS source) {
        if (source.getValue() != null) {
            return null;
        }
        OffsetDateTime dateTime = CancellationPolicyHelper.toOffsetDateTime(source, SYSTEM_ZONE_OFFSET);
        return HotelsTimeUtil.offsetDateTimeToDate((OffsetDateTime)dateTime);
    }

    public static CancellationPolicy buildHotelsCancellationPolicy(HotelProduct product) {
        try {
            if (!product.isCancellable()) {
                return new NonCancellablePolicy();
            }
            CancellablePolicy result = new CancellablePolicy();
            if (!product.getCancellationCharges().isEmpty() || !StringUtils.isBlank((String)product.getCancellationPolicyText())) {
                CancellationChargeHolder holder = new CancellationChargeHolder();
                Date checkIn = ((Room)product.getRooms().get(0)).getCheckInDate();
                for (CancellationCharge charge : product.getCancellationCharges()) {
                    CancellationCharge charge2 = (CancellationCharge)XCloneHelper.clone((XCloneable)charge, (boolean)false);
                    if (charge2 == null) continue;
                    CancellationPolicyHelper.fixDates(charge2, product.getIssueDate() != null ? product.getIssueDate() : new Date(), checkIn);
                    holder.getCancellationCharges().add(charge2);
                }
                holder.setFreeCancellationTerm(product.getFreeCancellationTerm());
                result.setCancellableNow(BooleanUtil.nullAsFalse((Boolean)product.getCancellableNow()));
                result.setCancellationChargesHolder(holder);
            }
            result.setText(product.getCancellationPolicyText());
            return result;
        }
        catch (Exception e) {
            ExceptionUtil.throwException((Throwable)e);
            return null;
        }
    }
}

