/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.hotels2.ibus.helpers;

import com.gridnine.xtrip.common.hotels2.model.CancellablePolicy;
import com.gridnine.xtrip.common.hotels2.model.CancellationChargeHolder;
import com.gridnine.xtrip.common.hotels2.model.CancellationPolicy;
import com.gridnine.xtrip.common.hotels2.model.Facility;
import com.gridnine.xtrip.common.hotels2.model.HotelCard;
import com.gridnine.xtrip.common.hotels2.model.HotelOffer;
import com.gridnine.xtrip.common.hotels2.model.HotelsStayPolicy;
import com.gridnine.xtrip.common.hotels2.model.ProviderVatInfo;
import com.gridnine.xtrip.common.l10n.model.L10nString;
import com.gridnine.xtrip.common.l10n.model.L10nStringHelper;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.StatisticalData;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.TravellerCostCodes;
import com.gridnine.xtrip.common.model.booking.xtriphotels.CancellationCharge;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProduct;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProductTax;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProvider;
import com.gridnine.xtrip.common.model.booking.xtriphotels.Location;
import com.gridnine.xtrip.common.model.booking.xtriphotels.Room;
import com.gridnine.xtrip.common.model.booking.xtriphotels.TaxInfo;
import com.gridnine.xtrip.common.model.booking.xtriphotels.service.HotelsStayType;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.CancellationChargeHelper;
import com.gridnine.xtrip.common.model.helpers.HotelProductHelper;
import com.gridnine.xtrip.common.model.helpers.MoneyHelper;
import com.gridnine.xtrip.common.model.profile.Address;
import com.gridnine.xtrip.common.model.profile.CostCode;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.model.system.RateMoney;
import com.gridnine.xtrip.common.util.BooleanUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.hotels2.ibus.helpers.HotelsBaseHelper;
import com.gridnine.xtrip.server.hotels2.ibus.helpers.HotelsHelper;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class FakeHotelProductHelper {
    public static HotelProduct buildFakeHotelProduct(HotelOffer offer, Reservation reservation, HotelCard hotelCard, SalesContext salesContext, Map<Traveller, List<CostCode>> travellersCostCodes) {
        HotelProduct product = new HotelProduct();
        BookingHelper.addProduct((Reservation)reservation, (BaseProduct)product);
        Date issueDate = new Date();
        product.setIssueDate(issueDate);
        String gdsCurrency = HotelsHelper.getCurrency(offer);
        product.setGdsCurrency(gdsCurrency);
        product.setStatus(ProductStatus.BOOKING);
        product.setProvider(offer.getProvider());
        product.setProviderHotelCode(offer.getProviderHotelCode());
        product.setSubProvider(offer.getSubProvider());
        product.setGdsSubProvider(offer.getVendor());
        product.setClientTariffCode(offer.getClientTariffCode());
        product.setBlankOwnerCode(offer.getBlankOwnerCode());
        product.setVendorContract(offer.getContract());
        product.setTripartiteAgreement(offer.isTripartiteContract());
        HotelProductHelper.setAgency((HotelProduct)product, (EntityReference)salesContext.getAgency());
        HotelProductHelper.setSubagency((HotelProduct)product, (EntityReference)salesContext.getSubagency());
        product.setSalesPoint(salesContext.getSalesPoint());
        product.setCashier(salesContext.getAgent());
        HotelProductHelper.setSupplier((HotelProduct)product, (EntityReference)HotelProductHelper.getSupplierFor((HotelProvider)product.getProvider(), (DictionaryReference)product.getSubProvider()));
        product.setBlankOwnerRef(HotelProductHelper.getBlankOwnerFor((String)product.getBlankOwnerCode(), (DictionaryReference)product.getSubProvider()));
        HotelProductHelper.setOnHold((HotelProduct)product, (boolean)true);
        if (!offer.getEssentialInfo().isEmpty()) {
            product.getEssentialInfoData().add(HotelProductHelper.getDefaultEssentialInfoData((List)offer.getEssentialInfo()));
        }
        product.setCotsGuaranteed(FakeHotelProductHelper.isCotsGuaranteed(offer));
        product.setTicketType(HotelsHelper.getTicketType(offer.getAvailability()));
        FakeHotelProductHelper.fillRoom(product, offer);
        FakeHotelProductHelper.fillProductFromHotelCard(product, hotelCard);
        FakeHotelProductHelper.fillProductFromCancellationPolicy(product, offer.getCancellationPolicy(), issueDate, gdsCurrency);
        product.getAdditionalServices().clear();
        product.getAdditionalServices().addAll(offer.getAdditionalServices());
        FakeHotelProductHelper.fillTaxes(product, offer.getTaxInfoList());
        product.setStatisticalData(FakeHotelProductHelper.buildStatisticalData(travellersCostCodes));
        return product;
    }

    private static boolean isCotsGuaranteed(HotelOffer offer) {
        return false;
    }

    private static void fillRoom(HotelProduct product, HotelOffer offer) {
        Money baseRate;
        Room room = new Room();
        product.getRooms().add(room);
        room.setId(offer.getId());
        room.setNumberOfPeople(Integer.valueOf(offer.getRoomInfo().getTravellers().size()));
        room.setHotelCardNumber(offer.getHotelCardNumber());
        room.setRateType(offer.getRateType());
        room.setAdditionalInfo(offer.getAdditionalInfo());
        room.setCheckInDate(MiscUtil.toDate((LocalDate)offer.getStayPolicy().getCheckInDate()));
        room.setCheckOutDate(MiscUtil.toDate((LocalDate)offer.getStayPolicy().getCheckOutDate()));
        room.setCheckInTime(HotelsBaseHelper.localTime2Integer(offer.getStayPolicy().getCheckInTime()));
        room.setCheckOutTime(HotelsBaseHelper.localTime2Integer(offer.getStayPolicy().getCheckOutTime()));
        room.setStandardCheckInTime(HotelsBaseHelper.localTime2Integer(offer.getStayPolicy().getStandardCheckInTime()));
        room.setStandardCheckOutTime(HotelsBaseHelper.localTime2Integer(offer.getStayPolicy().getStandardCheckOutTime()));
        if (offer.getBasePrice() != null) {
            FakeHotelProductHelper.setPrice(product, room, offer.getBasePrice());
        }
        if ((baseRate = FakeHotelProductHelper.getBaseRate(offer)) != null) {
            room.setBaseRate(baseRate);
        }
        room.setRackRate(MoneyHelper.getEquivalentAmount((Money)offer.getRackRate()));
        FakeHotelProductHelper.setRoomVatInfo(room, offer.getProviderVatInfo());
        HotelsHelper.setHotelCommission(product, offer.getHotelCommission());
        room.setRoomName(offer.getRoomName());
        FakeHotelProductHelper.setTravellers(room, product, offer.getRoomInfo().getTravellers());
        room.setAvailability(offer.getAvailability());
        room.setMeal(HotelsHelper.buildMeal(offer.getMealIncluded()));
    }

    public static void fillProductFromCancellationPolicy(HotelProduct product, CancellationPolicy cancellationPolicy, Date issueDate, String equivalentCurrency) {
        if (cancellationPolicy != null) {
            if (cancellationPolicy instanceof CancellablePolicy) {
                product.setCancellableNow(((CancellablePolicy)cancellationPolicy).isCancellableNow() ? Boolean.TRUE : Boolean.FALSE);
                CancellablePolicy cancellablePolicy = (CancellablePolicy)cancellationPolicy;
                CancellationChargeHolder chargesHolder = cancellablePolicy.getCancellationChargesHolder();
                if (chargesHolder != null) {
                    boolean isCancellable = false;
                    for (CancellationCharge charge : chargesHolder.getCancellationCharges()) {
                        isCancellable = isCancellable || !BooleanUtil.nullAsFalse((Boolean)charge.getNotAvailableViaAPI());
                        product.getCancellationCharges().add(charge);
                    }
                    product.setCancellable(isCancellable || chargesHolder.getFreeCancellationTerm() != null);
                    product.setFreeCancellationTerm(chargesHolder.getFreeCancellationTerm());
                } else {
                    product.setCancellable(true);
                }
            } else {
                product.setCancellable(false);
                product.getCancellationCharges().add(FakeHotelProductHelper.fullCharge(product, issueDate, equivalentCurrency));
            }
            product.setCancellationPolicyText(cancellationPolicy.getText());
        }
    }

    private static CancellationCharge fullCharge(HotelProduct hp, Date issueDate, String equivCurrCode) {
        CancellationCharge result = new CancellationCharge();
        result.setStartDate(issueDate);
        RateMoney allRateMoney = null;
        if (equivCurrCode != null) {
            BigDecimal total = BigDecimal.ZERO;
            for (Room room : hp.getRooms()) {
                total = MiscUtil.sum((BigDecimal[])new BigDecimal[]{total, room.getEquivalentPrice()});
            }
            Money allMoney = MoneyHelper.moneyOrNull((BigDecimal)total, (String)equivCurrCode);
            if (allMoney != null) {
                CancellationChargeHelper.fillCancellationCharge((CancellationCharge)result, (Money)allMoney, (String)equivCurrCode, (boolean)HotelProductHelper.includeVat((HotelProduct)hp));
                allRateMoney = result.getPenalty();
                result.setPolicyText(allRateMoney.toString());
            }
        }
        if (allRateMoney == null) {
            allRateMoney = new RateMoney();
            result.setPenalty(allRateMoney);
        }
        if (allRateMoney.getMoney() == null) {
            allRateMoney.setRate(Double.valueOf(100.0));
            result.setPolicyText("100%");
        }
        result.setWithTime(true);
        return result;
    }

    private static void fillProductFromHotelCard(HotelProduct product, HotelCard hotelCard) {
        product.setHotelPropertyId(hotelCard.getNumber());
        product.setHotelName(hotelCard.getName());
        product.setHotelType(hotelCard.getHotelType());
        product.setHotelStars(hotelCard.getHotelStars());
        product.setDescription(hotelCard.getDescription());
        if (hotelCard.getLatitude() != null && hotelCard.getLongitude() != null) {
            Location loc = new Location();
            loc.setLatitude(hotelCard.getLatitude().doubleValue());
            loc.setLongitude(hotelCard.getLongitude().doubleValue());
            product.setLoc(loc);
        }
        if (hotelCard.getAddress() != null) {
            Address address = hotelCard.getAddress();
            product.setHotelAddress(L10nStringHelper.getValue((L10nString)address.getAddress()));
            product.setHotelLocation(address.getCity());
            product.setHotelCountry(address.getCountry());
        }
        product.setHotelFax(HotelsHelper.getFax(hotelCard.getContacts()));
        product.setHotelPhone(HotelsHelper.getPhone(hotelCard.getContacts()));
        hotelCard.getFacilities().stream().map(Facility::getCaption).filter(Objects::nonNull).forEach(facility -> product.getFacilities().add(facility));
        hotelCard.getBaseFacilities().stream().map(Facility::getCaption).filter(Objects::nonNull).forEach(facility -> product.getFacilities().add(facility));
    }

    private static void setPrice(HotelProduct product, Room room, Money basePrice) {
        room.setBasePrice(basePrice);
        String gdsCurrency = product.getGdsCurrency();
        if (gdsCurrency == null) {
            product.setGdsCurrency(basePrice.getCurrency());
        } else if (!MoneyHelper.currencyMatches((String)gdsCurrency, (Money)basePrice)) {
            throw Xeption.forDeveloper((String)String.format("Room price currency (%s) doesn't match reservation system currency (%s)", basePrice.getCurrency(), gdsCurrency), (Object[])new Object[0]);
        }
        room.setEquivalentPrice(basePrice.getValue());
    }

    private static Money getBaseRate(HotelOffer offer) {
        HotelsStayPolicy stayPolicy = offer.getStayPolicy();
        return stayPolicy != null && HotelsStayType.DEFAULT.equals((Object)stayPolicy.getType()) ? HotelProductHelper.calculateRawPriceRatePerNight((LocalDate)stayPolicy.getCheckInDate(), (LocalDate)stayPolicy.getCheckOutDate(), (Money)offer.getBasePrice()) : offer.getBasePrice();
    }

    private static void setRoomVatInfo(Room room, ProviderVatInfo providerVatInfo) {
        room.setVat(providerVatInfo.getIncluded());
        room.setVatAmount(providerVatInfo.getAmount());
        room.setEquivalentVatPrice(providerVatInfo.getAmount());
        room.setEquivVatRate(providerVatInfo.getRate());
    }

    private static void setTravellers(Room room, HotelProduct product, List<Traveller> travellers) {
        for (Traveller traveller : travellers) {
            product.getTravellers().add(traveller);
            room.getRoomTravellersUids().add(traveller.getUid());
        }
    }

    private static void fillTaxes(HotelProduct product, List<TaxInfo> taxInfoList) {
        BigDecimal sum = BigDecimal.ZERO;
        for (TaxInfo taxInfo : taxInfoList) {
            if (!taxInfo.isIncludedInTariff()) continue;
            HotelProductTax tax = new HotelProductTax();
            tax.setCode(taxInfo.getName());
            tax.setAmount(taxInfo.getAmount());
            if (tax.getAmount() != null) {
                BigDecimal amount = tax.getAmount().getValue();
                tax.setEquivalentAmount(amount);
                sum = sum.add(amount);
            }
            product.getTaxes().add(tax);
        }
        if (BigDecimal.ZERO.compareTo(sum) != 0) {
            Room room = (Room)product.getRooms().get(0);
            if (room.getBasePrice() != null) {
                room.setBasePrice(MoneyHelper.buildMoney((BigDecimal)room.getBasePrice().getValue().subtract(sum), (String)room.getBasePrice().getCurrency()));
            }
            if (room.getEquivalentPrice() != null) {
                room.setEquivalentPrice(room.getEquivalentPrice().subtract(sum));
            }
        }
    }

    private static StatisticalData buildStatisticalData(Map<Traveller, List<CostCode>> travellersCostCodes) {
        if (travellersCostCodes == null) {
            return null;
        }
        StatisticalData result = new StatisticalData();
        travellersCostCodes.forEach((tr, costCodes) -> {
            TravellerCostCodes tcc = new TravellerCostCodes();
            tcc.setTraveller(tr);
            tcc.getCostCodes().addAll(costCodes);
            result.getTravellerCostCodes().add(tcc);
        });
        return result;
    }
}

