/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.hotels2.ibus.helpers;

import com.gridnine.xtrip.common.hotels2.model.CancellablePolicy;
import com.gridnine.xtrip.common.hotels2.model.CancellationPolicy;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.booking.GeneralProductContractRelationData;
import com.gridnine.xtrip.common.model.helpers.CancellationChargeHelper;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.HotelsTimeUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;

public class HotelCancellationRulesHelper {
    public static String buildCancellationRules(CancellationPolicy cancellationPolicy, Money basePrice, LocalDate checkInDate, List<GeneralProductContractRelationData> contractRelations, String gdsCurrency, LocalDateTime viewpoint) {
        boolean isCancellable;
        List cancellationCharges;
        Date freeCancellationTerm = null;
        if (cancellationPolicy instanceof CancellablePolicy) {
            CancellablePolicy cp = (CancellablePolicy)cancellationPolicy;
            if (cp.getCancellationChargesHolder() == null) {
                return null;
            }
            cancellationCharges = cp.getCancellationChargesHolder().getCancellationCharges();
            freeCancellationTerm = cp.getCancellationChargesHolder().getFreeCancellationTerm();
            isCancellable = true;
        } else {
            cancellationCharges = Collections.emptyList();
            isCancellable = false;
        }
        LocalDate viewpointDate = viewpoint != null ? viewpoint.toLocalDate() : LocalDate.of(2000, 1, 1);
        Date now = HotelsTimeUtil.localDateToDate((LocalDate)viewpointDate);
        if (!isCancellable) {
            return L10nResourcesManager.getStr((String)"HOTELS_BOOKING_CANCELLATION_IMPOSSIBLE", (Object[])new Object[0]);
        }
        String text = cancellationPolicy.getText();
        List sortedCharges = CancellationChargeHelper.normalize((Date)now, (List)cancellationCharges, (LocalDate)checkInDate);
        if (CollectionUtil.isEmpty((Collection)sortedCharges)) {
            StringBuilder buf = new StringBuilder();
            if (freeCancellationTerm != null) {
                buf.append(CancellationChargeHelper.freeCancellationBefore((Date)freeCancellationTerm, (boolean)true, null));
            }
            if (TextUtil.nonBlank((String)text)) {
                buf.append('\n').append(text);
            }
            return buf.toString();
        }
        Money hiddenNotRefundedFees = CancellationChargeHelper.calcHiddenNotRefundedFeesAmount(contractRelations, (String)gdsCurrency);
        return CancellationChargeHelper.buildCancellationPolicy((List)sortedCharges, (Money)basePrice, (Money)hiddenNotRefundedFees, (String)text, null);
    }
}

