/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.hotels2.ibus.helpers;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.GeneralProductContractRelationData;
import com.gridnine.xtrip.common.model.booking.SalesChain;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProduct;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProvider;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.l10n.Messages;
import com.gridnine.xtrip.common.model.profile.Contract;
import com.gridnine.xtrip.common.model.profile.ContractRelationDescription;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.server.model.handlers.rules.GeneralProductRulesHelper;
import com.gridnine.xtrip.server.model.handlers.rules.ProductRelatedOrganizations;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HotelRulesHelper {
    private static final Logger log = LoggerFactory.getLogger(HotelRulesHelper.class);

    public static EntityContainer<Contract> getVendorContract(HotelProduct product, List<Message> messages) {
        try {
            ArrayList vm = new ArrayList();
            ProductRelatedOrganizations organizations = com.gridnine.xtrip.server.model.handlers.rules.hotel.HotelRulesHelper.collectOrganizations((HotelProduct)product, vm);
            com.gridnine.xtrip.server.model.handlers.rules.hotel.HotelRulesHelper.addMessages(messages, vm);
            GeneralProductContractRelationData vcr = GeneralProductHelper.getVendorContractRelation((BaseProduct)product);
            EntityContainer contract = EntityStorage.get().resolve(vcr.getGeneralData().getContractData().getManualContract());
            if (contract == null) {
                EntityContainer entityContainer = contract = product.getProvider() == HotelProvider.INTERNAL ? EntityStorage.get().resolve(product.getVendorContract()) : null;
            }
            if (contract != null) {
                return contract;
            }
            EntityReference blankOwner = organizations.blankOwner;
            ContractRelationDescription description = (ContractRelationDescription)EntityStorage.get().resolve(vcr.getDescription()).getEntity();
            EntityReference supplier = GeneralProductHelper.getContractor((SalesChain)organizations.salesChain, (EntityReference)description.getSupplier());
            EntityReference customer = GeneralProductHelper.getContractor((SalesChain)organizations.salesChain, (EntityReference)description.getCustomer());
            List contracts = GeneralProductRulesHelper.getContracts((ContractType)ContractType.VENDOR, (BaseProduct)product, (EntityReference)blankOwner, (EntityReference)supplier, (EntityReference)customer, (List)product.getValidationMessages(), (Date)product.getIssueDate(), (Enum)product.getProvider());
            return HotelRulesHelper.selectContract(contracts);
        }
        catch (Exception e) {
            if (messages != null) {
                messages.add(SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.AirRulesHelper_applyRulesError, (Throwable)e, (Object[])new Object[0]));
            }
            log.error("unable to get contract", (Throwable)e);
            return null;
        }
    }

    private static EntityContainer<Contract> selectContract(List<EntityContainer<Contract>> contracts) {
        if (CollectionUtil.isEmpty(contracts)) {
            return null;
        }
        if (contracts.size() == 1) {
            return contracts.get(0);
        }
        return ProfileHelper.getDefaultContract(contracts);
    }
}

