/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.hotels2.ibus.helpers;

import com.gridnine.hotels.web.ws.CodeSystem;
import com.gridnine.hotels.web.ws.ContactType;
import com.gridnine.hotels.web.ws.GeoLocation;
import com.gridnine.hotels.web.ws.GeoLocationType;
import com.gridnine.hotels.web.ws.HotelCategory;
import com.gridnine.hotels.web.ws.HotelsCheckInOutOptionType;
import com.gridnine.hotels.web.ws.HotelsCustomOptionType;
import com.gridnine.hotels.web.ws.HotelsDateTime;
import com.gridnine.hotels.web.ws.HotelsExtraBedOptionType;
import com.gridnine.hotels.web.ws.HotelsMoney;
import com.gridnine.hotels.web.ws.HotelsPccFilter;
import com.gridnine.hotels.web.ws.HotelsReference;
import com.gridnine.hotels.web.ws.HotelsServiceOptionStatus;
import com.gridnine.hotels.web.ws.LocalDateTimeWS;
import com.gridnine.hotels.web.ws.Money;
import com.gridnine.hotels.web.ws.OfferOptionType;
import com.gridnine.hotels.web.ws.Provider;
import com.gridnine.hotels.web.ws.RateType;
import com.gridnine.hotels.web.ws.ReservationItemStatusInfo;
import com.gridnine.hotels.web.ws.ReservationStatus;
import com.gridnine.hotels.web.ws.ReservationStatusInfo;
import com.gridnine.hotels.web.ws.Title;
import com.gridnine.xtrip.common.hotels2.model.HotelsAggregatorGdsAccount;
import com.gridnine.xtrip.common.incidents.IncidentsLog;
import com.gridnine.xtrip.common.midoffice.helper.CodeTranslator;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.xtriphotels.AdditionalServiceStatus;
import com.gridnine.xtrip.common.model.booking.xtriphotels.AdditionalServiceType;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProductStatus;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProvider;
import com.gridnine.xtrip.common.model.booking.xtriphotels.service.HotelsPayee;
import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.model.dict.CommunicationType;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.Gender;
import com.gridnine.xtrip.common.model.dict.LocationType;
import com.gridnine.xtrip.common.model.helpers.MoneyHelper;
import com.gridnine.xtrip.common.util.DateUtils;
import com.gridnine.xtrip.common.util.EnumUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.joda.time.DateTime;

public class HotelsBaseHelper {
    private static final CodeTranslator translator = new CodeTranslator(new String[]{com.gridnine.xtrip.common.model.dict.CodeSystem.IATA.name(), com.gridnine.xtrip.common.model.dict.CodeSystem.CRT.name(), com.gridnine.xtrip.common.model.dict.CodeSystem.HOTEL_AGGREGATOR.name()});
    private static final CodeTranslator haTranslator = new CodeTranslator(new String[]{com.gridnine.xtrip.common.model.dict.CodeSystem.HOTEL_AGGREGATOR.name()});
    private static Map<HotelCategory, Integer> hotelCategoryMap = new HashMap<HotelCategory, Integer>();
    private static Map<ContactType, CommunicationType> contactTypeMap;
    private static Map<HotelsCheckInOutOptionType, AdditionalServiceType> checkInOutOptionTypeMap;
    private static Map<HotelsExtraBedOptionType, AdditionalServiceType> extraBedOptionTypeMap;
    private static Map<HotelsCustomOptionType, AdditionalServiceType> customOptionTypeMap;
    private static Map<OfferOptionType, AdditionalServiceType> offerOptionTypeMap;
    private static Map<CodeSystem, com.gridnine.xtrip.common.model.dict.CodeSystem> codeSystemMap;

    public static <D extends BaseDictionary> String getNativeCode(DictionaryReference<D> dictRef) {
        return haTranslator.getNativeCode(dictRef, false);
    }

    public static <D extends BaseDictionary> DictionaryReference<D> resolveNativeCode(Class<D> cls, String code) {
        return translator.resolveNativeCode(cls, code, false);
    }

    public static <D extends BaseDictionary> DictionaryReference<D> getDictReference(Class<D> cls, String code) {
        DictionaryReference result = translator.resolveNativeCode(cls, code, false);
        if (result == null) {
            throw Xeption.forDeveloper((String)"can't resolve dict code {0} for {1}", (Object[])new Object[]{code, cls});
        }
        return result;
    }

    public static DictionaryReference<com.gridnine.xtrip.common.model.dict.GeoLocation> resolveCity(String wsCode) {
        return translator.resolveNativeCode(com.gridnine.xtrip.common.model.dict.GeoLocation.class, wsCode, LocationType.CITY, false);
    }

    public static Integer convertHotelCategoryFromGds(HotelCategory wsValue) {
        return hotelCategoryMap.get(wsValue);
    }

    public static CommunicationType convertContactTypefromGds(ContactType wsValue) {
        return contactTypeMap.get(wsValue);
    }

    public static AdditionalServiceType convertAdditionalServiceType(HotelsCheckInOutOptionType wsValue) {
        return checkInOutOptionTypeMap.get(wsValue);
    }

    public static AdditionalServiceType convertAdditionalServiceType(HotelsExtraBedOptionType wsValue) {
        return extraBedOptionTypeMap.get(wsValue);
    }

    public static AdditionalServiceType convertAdditionalServiceType(HotelsCustomOptionType wsValue) {
        return customOptionTypeMap.get(wsValue);
    }

    public static AdditionalServiceType convertAdditionalServiceType(OfferOptionType wsValue) {
        return offerOptionTypeMap.get(wsValue);
    }

    public static com.gridnine.xtrip.common.model.dict.CodeSystem convertCodeSystemFromGds(CodeSystem codeSystem) {
        return codeSystemMap.get(codeSystem);
    }

    public static Gender convertGenderFromGds(Title wsValue) {
        if (wsValue == null) {
            return null;
        }
        switch (wsValue) {
            case MR: {
                return Gender.MALE;
            }
            case MRS: 
            case MS: {
                return Gender.FEMALE;
            }
        }
        return null;
    }

    public static Title convertTitleFromGender(Gender gender) {
        if (gender == null) {
            return null;
        }
        return gender == Gender.MALE ? Title.MR : Title.MRS;
    }

    public static ProductStatus convertToProductStatus(ReservationStatusInfo wsStatusInfo) {
        if (wsStatusInfo == null) {
            return null;
        }
        return HotelsBaseHelper.convertToProductStatus(wsStatusInfo.getStatus());
    }

    public static ProductStatus convertToProductStatus(ReservationItemStatusInfo wsStatusInfo) {
        if (wsStatusInfo == null) {
            return null;
        }
        return HotelsBaseHelper.convertToProductStatus(wsStatusInfo.getStatus());
    }

    private static ProductStatus convertToProductStatus(ReservationStatus wsStatus) {
        if (wsStatus == null) {
            return null;
        }
        switch (wsStatus) {
            case WAITING_CONFIRMATION: 
            case WAITING_CANCELLATION: 
            case REQUEST_SENT: {
                return ProductStatus.REQUEST;
            }
            case CONFIRMED: 
            case NOT_IN_DEMAND: {
                return ProductStatus.SELL;
            }
            case CANCELLED: 
            case CANCELLED_WITH_PENALTY: {
                return ProductStatus.REFUND;
            }
            case REJECTED: {
                return ProductStatus.REJECT;
            }
        }
        return null;
    }

    public static Provider convertProviderToGds(HotelProvider hotelProvider) {
        return (Provider)EnumUtil.recodeSafe((Enum)hotelProvider, Provider.class);
    }

    public static HotelProvider convertProviderFromGds(Provider wsValue) {
        return (HotelProvider)EnumUtil.recodeSafe((Enum)wsValue, HotelProvider.class);
    }

    public static HotelProductStatus convertToHotelProductStatus(ReservationItemStatusInfo wsStatusInfo) {
        if (wsStatusInfo == null) {
            return null;
        }
        return (HotelProductStatus)EnumUtil.recodeSafe((Enum)wsStatusInfo.getStatus(), HotelProductStatus.class);
    }

    public static String convertToProviderStatusInfo(ReservationItemStatusInfo wsStatusInfo) {
        if (wsStatusInfo == null) {
            return null;
        }
        return wsStatusInfo.getStatusText();
    }

    public static AdditionalServiceStatus convertAdditionalServiceStatus(HotelsServiceOptionStatus wsValue) {
        return (AdditionalServiceStatus)EnumUtil.recodeSafe((Enum)wsValue, AdditionalServiceStatus.class);
    }

    public static com.gridnine.xtrip.common.model.booking.xtriphotels.RateType convertRateTypeFromGds(RateType wsValue) {
        return (com.gridnine.xtrip.common.model.booking.xtriphotels.RateType)EnumUtil.recodeSafe((Enum)wsValue, com.gridnine.xtrip.common.model.booking.xtriphotels.RateType.class);
    }

    public static com.gridnine.xtrip.common.model.booking.xtriphotels.OfferOptionType convertOfferOptionTypeFromGds(OfferOptionType wsValue) {
        return (com.gridnine.xtrip.common.model.booking.xtriphotels.OfferOptionType)EnumUtil.recodeSafe((Enum)wsValue, com.gridnine.xtrip.common.model.booking.xtriphotels.OfferOptionType.class);
    }

    public static HotelsPayee convertHotelsPayeeFromGds(com.gridnine.hotels.web.ws.HotelsPayee wsValue) {
        return (HotelsPayee)EnumUtil.recodeSafe((Enum)wsValue, HotelsPayee.class);
    }

    public static LocationType convertGeoLocationTypeFromGds(GeoLocationType type) {
        return (LocationType)EnumUtil.recodeSafe((Enum)type, LocationType.class);
    }

    public static HotelsReference convertToHotelsReference(DictionaryReference<? extends BaseDictionary> dictRef) {
        if (dictRef == null) {
            return null;
        }
        HotelsReference result = new HotelsReference();
        result.setHotelsCode(HotelsBaseHelper.getNativeCode(dictRef));
        return result;
    }

    public static Integer time2Integer(int value) {
        return value < 0 ? null : Integer.valueOf(value);
    }

    public static LocalTime toLocalTime(Integer minutes) {
        if (minutes == null) {
            return null;
        }
        return LocalTime.ofSecondOfDay(minutes * 60);
    }

    public static Integer localTime2Integer(LocalTime localTime) {
        return localTime != null ? Integer.valueOf(localTime.toSecondOfDay() / 60) : null;
    }

    public static Date toDate(HotelsDateTime wsDateTime) {
        if (wsDateTime == null || wsDateTime.getDate() == null) {
            return null;
        }
        XMLGregorianCalendar date = wsDateTime.getDate();
        XMLGregorianCalendar cloneDate = (XMLGregorianCalendar)date.clone();
        XMLGregorianCalendar time = wsDateTime.getTime();
        if (time == null) {
            cloneDate.setTimezone(Integer.MIN_VALUE);
            return cloneDate.toGregorianCalendar().getTime();
        }
        cloneDate.setTime(time.getHour(), time.getMinute(), time.getSecond(), time.getMillisecond());
        if (wsDateTime.getOffset() == null) {
            cloneDate.setTimezone(Integer.MIN_VALUE);
        } else {
            cloneDate.setTimezone(wsDateTime.getOffset());
        }
        return cloneDate.toGregorianCalendar().getTime();
    }

    public static Date toDate(XMLGregorianCalendar cal) {
        if (cal == null) {
            return null;
        }
        XMLGregorianCalendar clone = (XMLGregorianCalendar)cal.clone();
        clone.setTimezone(Integer.MIN_VALUE);
        return clone.toGregorianCalendar().getTime();
    }

    public static Date toDate(LocalDateTimeWS wsDatetime) {
        if (wsDatetime == null) {
            return null;
        }
        return HotelsBaseHelper.toDate(wsDatetime.getDate());
    }

    private static Date toDate(String datetimeStr) {
        if (TextUtil.isBlank((String)datetimeStr)) {
            return null;
        }
        if (datetimeStr.length() > 19) {
            ZonedDateTime dt = ZonedDateTime.parse(datetimeStr);
            return DateUtils.toJavaDate((ZonedDateTime)dt);
        }
        LocalDateTime dt = LocalDateTime.parse(datetimeStr);
        return DateUtils.toJavaDate((LocalDateTime)dt);
    }

    public static LocalDate toLocalDate(DateTime dateTime) {
        if (dateTime == null) {
            return null;
        }
        return LocalDate.of(dateTime.getYear(), dateTime.getMonthOfYear(), dateTime.getDayOfMonth());
    }

    public static LocalDate toLocalDate(XMLGregorianCalendar calendar) {
        if (calendar == null) {
            return null;
        }
        return LocalDate.of(calendar.getYear(), calendar.getMonth(), calendar.getDay());
    }

    public static LocalTime toLocalTime(XMLGregorianCalendar calendar) {
        if (calendar == null) {
            return null;
        }
        return LocalTime.of(calendar.getHour(), calendar.getMinute(), calendar.getSecond());
    }

    public static DateTime toDateTime(LocalDate localDate) {
        return HotelsBaseHelper.toDateTime(localDate, false);
    }

    public static DateTime toDateTime(LocalDate localDate, boolean toEndOfDay) {
        if (localDate == null) {
            return null;
        }
        DateTime result = new DateTime().withDate(localDate.getYear(), localDate.getMonthValue(), localDate.getDayOfMonth());
        return toEndOfDay ? result.withTime(23, 59, 59, 59) : result.withTime(0, 0, 0, 0);
    }

    public static XMLGregorianCalendar toXMLGregorianCalendar(DateTime dateTime) {
        return HotelsBaseHelper.toXMLGregorianCalendar(dateTime, 0);
    }

    public static XMLGregorianCalendar toXMLGregorianCalendar(DateTime dateTime, int mode) {
        if (dateTime == null) {
            return null;
        }
        GregorianCalendar ci = new GregorianCalendar();
        switch (mode) {
            case 0: {
                ci.setTimeInMillis(dateTime.getMillis());
                break;
            }
            case 1: {
                ci.setTimeInMillis(dateTime.withTime(0, 0, 0, 0).getMillis());
                break;
            }
            case 2: {
                ci.setTimeInMillis(dateTime.withTime(23, 59, 59, 999).getMillis());
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported mode: " + mode);
            }
        }
        try {
            return DatatypeFactory.newInstance().newXMLGregorianCalendar(ci);
        }
        catch (DatatypeConfigurationException e) {
            IncidentsLog.reportException((String)"Failed to configure data type", (Throwable)e);
            return null;
        }
    }

    public static XMLGregorianCalendar toXMLGregorianCalendar(LocalDate localDate) {
        if (localDate == null) {
            return null;
        }
        return HotelsBaseHelper.toXMLGregorianCalendar(new DateTime().withDate(localDate.getYear(), localDate.getMonthValue(), localDate.getDayOfMonth()), 0);
    }

    public static XMLGregorianCalendar toXMLGregorianCalendar(LocalDate localDate, int mode) {
        if (localDate == null) {
            return null;
        }
        return HotelsBaseHelper.toXMLGregorianCalendar(new DateTime().withDate(localDate.getYear(), localDate.getMonthValue(), localDate.getDayOfMonth()), mode);
    }

    public static XMLGregorianCalendar toXMLGregorianCalendar(Date date) {
        if (date == null) {
            return null;
        }
        return HotelsBaseHelper.toXMLGregorianCalendar(new DateTime(date.getTime()), 0);
    }

    public static XMLGregorianCalendar toXMLGregorianCalendar(Date date, int mode) {
        if (date == null) {
            return null;
        }
        return HotelsBaseHelper.toXMLGregorianCalendar(new DateTime(date.getTime()), mode);
    }

    public static com.gridnine.xtrip.common.model.system.Money convertMoneyFromGds(HotelsMoney wsMoney) {
        if (wsMoney == null) {
            return null;
        }
        return MoneyHelper.moneyOrNull((BigDecimal)wsMoney.getAmount(), (String)wsMoney.getCurrency());
    }

    public static com.gridnine.xtrip.common.model.system.Money convertMoneyFromGds(Money wsMoney) {
        if (wsMoney == null) {
            return null;
        }
        return MoneyHelper.moneyOrNull((BigDecimal)wsMoney.getAmount(), (String)wsMoney.getCurrencyCode());
    }

    public static GeoLocation convertLocationToGds(DictionaryReference<com.gridnine.xtrip.common.model.dict.GeoLocation> loc) {
        if (loc == null) {
            return null;
        }
        GeoLocation result = new GeoLocation();
        com.gridnine.xtrip.common.model.dict.GeoLocation dictItem = (com.gridnine.xtrip.common.model.dict.GeoLocation)DictionaryCache.get().resolveReference(loc);
        if (dictItem == null) {
            result.setCode(loc.getCode());
            result.setCodeSystem(CodeSystem.IATA);
            result.setType(GeoLocationType.CITY);
            result.setLongitude(0.0);
            result.setLatitude(0.0);
        } else {
            boolean found = false;
            for (com.gridnine.xtrip.common.model.dict.CodeSystem cs : Arrays.asList(com.gridnine.xtrip.common.model.dict.CodeSystem.HOTEL_AGGREGATOR, com.gridnine.xtrip.common.model.dict.CodeSystem.IATA, com.gridnine.xtrip.common.model.dict.CodeSystem.CRT)) {
                String code = (String)dictItem.getCodeVariants().get(cs.name());
                if (code == null) continue;
                result.setCode(code);
                switch (cs) {
                    case HOTEL_AGGREGATOR: {
                        result.setCodeSystem(CodeSystem.SYSTEM);
                        break;
                    }
                    case CRT: {
                        result.setCodeSystem(CodeSystem.CRT);
                        break;
                    }
                    default: {
                        result.setCodeSystem(CodeSystem.IATA);
                    }
                }
                found = true;
                break;
            }
            if (!found) {
                result.setCode(loc.getCode());
                result.setCodeSystem(CodeSystem.IATA);
            }
            switch (dictItem.getType()) {
                case CITY: {
                    result.setType(GeoLocationType.CITY);
                    break;
                }
                case AIRPORT: {
                    result.setType(GeoLocationType.AIRPORT);
                    break;
                }
                case DISTRICT: {
                    result.setType(GeoLocationType.DISTRICT);
                    break;
                }
                case STATION: {
                    result.setType(GeoLocationType.RAILWAY_STATION);
                    break;
                }
                case REGION: {
                    result.setType(GeoLocationType.REGION);
                    break;
                }
            }
            result.setLongitude(dictItem.getLongitude());
            result.setLatitude(dictItem.getLatitude());
        }
        return result;
    }

    public static boolean isChild(int fullAge) {
        return fullAge < 18;
    }

    public static HotelsPccFilter buildHotelsPccFilter(List<EntityContainer<HotelsAggregatorGdsAccount>> gdsAccounts) {
        HotelsPccFilter filter = new HotelsPccFilter();
        gdsAccounts.stream().filter(Objects::nonNull).map(EntityContainer::getEntity).map(HotelsAggregatorGdsAccount::getPcc).filter(Objects::nonNull).forEach(pcc -> filter.getPcc().add(pcc));
        return filter;
    }

    static {
        hotelCategoryMap.put(HotelCategory.ONE, 1);
        hotelCategoryMap.put(HotelCategory.TWO, 2);
        hotelCategoryMap.put(HotelCategory.THREE, 3);
        hotelCategoryMap.put(HotelCategory.FOUR, 4);
        hotelCategoryMap.put(HotelCategory.FIVE, 5);
        contactTypeMap = new HashMap<ContactType, CommunicationType>();
        contactTypeMap.put(ContactType.EMAIL, CommunicationType.EMAIL);
        contactTypeMap.put(ContactType.FAX, CommunicationType.FAX);
        contactTypeMap.put(ContactType.MOBILE, CommunicationType.MOBILE);
        contactTypeMap.put(ContactType.PHONE, CommunicationType.WORK_PHONE);
        contactTypeMap.put(ContactType.WEB, CommunicationType.WEB);
        checkInOutOptionTypeMap = new HashMap<HotelsCheckInOutOptionType, AdditionalServiceType>();
        checkInOutOptionTypeMap.put(HotelsCheckInOutOptionType.CHECK_IN, AdditionalServiceType.EARLIER_CHECKIN);
        checkInOutOptionTypeMap.put(HotelsCheckInOutOptionType.CHECK_OUT, AdditionalServiceType.LATER_CHECKOUT);
        extraBedOptionTypeMap = new HashMap<HotelsExtraBedOptionType, AdditionalServiceType>();
        extraBedOptionTypeMap.put(HotelsExtraBedOptionType.ADULT, AdditionalServiceType.EXTRA_BED_ADULT);
        extraBedOptionTypeMap.put(HotelsExtraBedOptionType.CHILD, AdditionalServiceType.EXTRA_BED_CHILD);
        extraBedOptionTypeMap.put(HotelsExtraBedOptionType.INFANT, AdditionalServiceType.EXTRA_BED_INFANT);
        customOptionTypeMap = new HashMap<HotelsCustomOptionType, AdditionalServiceType>();
        customOptionTypeMap.put(HotelsCustomOptionType.EXTRA_BED, AdditionalServiceType.EXTRA_BED_ADULT);
        customOptionTypeMap.put(HotelsCustomOptionType.EXTRA_MEAL, AdditionalServiceType.MEAL);
        customOptionTypeMap.put(HotelsCustomOptionType.EARLY_CHECK_IN, AdditionalServiceType.EARLIER_CHECKIN);
        customOptionTypeMap.put(HotelsCustomOptionType.LATE_CHECK_OUT, AdditionalServiceType.LATER_CHECKOUT);
        customOptionTypeMap.put(HotelsCustomOptionType.INTERNET, AdditionalServiceType.OTHER);
        customOptionTypeMap.put(HotelsCustomOptionType.PARKING, AdditionalServiceType.OTHER);
        customOptionTypeMap.put(HotelsCustomOptionType.TAX, AdditionalServiceType.OTHER);
        customOptionTypeMap.put(HotelsCustomOptionType.VISA, AdditionalServiceType.OTHER);
        customOptionTypeMap.put(HotelsCustomOptionType.INSURANCE, AdditionalServiceType.OTHER);
        customOptionTypeMap.put(HotelsCustomOptionType.TRANSFER, AdditionalServiceType.OTHER);
        customOptionTypeMap.put(HotelsCustomOptionType.VEHICLE, AdditionalServiceType.OTHER);
        customOptionTypeMap.put(HotelsCustomOptionType.EXCURSION, AdditionalServiceType.OTHER);
        customOptionTypeMap.put(HotelsCustomOptionType.AVIA, AdditionalServiceType.OTHER);
        customOptionTypeMap.put(HotelsCustomOptionType.TRAIN, AdditionalServiceType.OTHER);
        customOptionTypeMap.put(HotelsCustomOptionType.GUIDE, AdditionalServiceType.OTHER);
        customOptionTypeMap.put(HotelsCustomOptionType.EVENT_TICKET, AdditionalServiceType.OTHER);
        customOptionTypeMap.put(HotelsCustomOptionType.ASSISTANT, AdditionalServiceType.OTHER);
        customOptionTypeMap.put(HotelsCustomOptionType.OTHER, AdditionalServiceType.OTHER);
        offerOptionTypeMap = new HashMap<OfferOptionType, AdditionalServiceType>();
        offerOptionTypeMap.put(OfferOptionType.EARLY_CHECKIN, AdditionalServiceType.EARLIER_CHECKIN);
        offerOptionTypeMap.put(OfferOptionType.LATE_CHECKOUT, AdditionalServiceType.LATER_CHECKOUT);
        offerOptionTypeMap.put(OfferOptionType.EXTRA_MEAL, AdditionalServiceType.MEAL);
        offerOptionTypeMap.put(OfferOptionType.EXTRA_BED_ADULT, AdditionalServiceType.EXTRA_BED_ADULT);
        offerOptionTypeMap.put(OfferOptionType.EXTRA_BED_CHILDREN, AdditionalServiceType.EXTRA_BED_CHILD);
        offerOptionTypeMap.put(OfferOptionType.EXTRA_BED_INFANTS, AdditionalServiceType.EXTRA_BED_INFANT);
        codeSystemMap = new HashMap<CodeSystem, com.gridnine.xtrip.common.model.dict.CodeSystem>();
        codeSystemMap.put(CodeSystem.IATA, com.gridnine.xtrip.common.model.dict.CodeSystem.IATA);
        codeSystemMap.put(CodeSystem.ISO, com.gridnine.xtrip.common.model.dict.CodeSystem.ISO);
        codeSystemMap.put(CodeSystem.CRT, com.gridnine.xtrip.common.model.dict.CodeSystem.CRT);
        codeSystemMap.put(CodeSystem.SYSTEM, com.gridnine.xtrip.common.model.dict.CodeSystem.HOTEL_AGGREGATOR);
    }
}

