/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.hotels2.ibus.helpers;

import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProvider;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.profile.ContractIndex;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class HotelsDirectContractHelper {
    public static Set<EntityReference<Organization>> getDirectContractSuppliers(SalesContext salesContext) {
        SearchQuery query = new SearchQuery();
        HotelsDirectContractHelper.buildBasicCriterions(query, salesContext);
        List contractIndexes = EntityStorage.get().search(ContractIndex.class, query).getData();
        return contractIndexes.stream().map(ContractIndex::getSupplier).collect(Collectors.toSet());
    }

    public static void buildBasicCriterions(SearchQuery query, SalesContext salesContext) {
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ContractIndex.Property.newModel.name(), (Object)true));
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ContractIndex.Property.contractType.name(), (Object)ContractType.VENDOR));
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ContractIndex.Property.provider.name(), (Object)HotelProvider.INTERNAL));
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ContractIndex.Property.transferProvider.name(), null));
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ContractIndex.Property.customer.name(), (Object)salesContext.getAgency()));
    }
}

