/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.hotels2.ibus.helpers;

import com.gridnine.xtrip.common.hotels2.model.HotelsAggregatorGdsAccount;
import com.gridnine.xtrip.common.hotels2.rules.HotelsParametersActions;
import com.gridnine.xtrip.common.hotels2.rules.HotelsParametersProperties;
import com.gridnine.xtrip.common.hotels2.rules.HotelsTargets;
import com.gridnine.xtrip.common.midoffice.helper.SalesContextHandler;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.rules.RuleEngine;
import com.gridnine.xtrip.common.rules.RuleSet;
import com.gridnine.xtrip.common.rules.elements.RuleProxy;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.LoggerFactory;

public class HotelsGdsHelper {
    public static List<EntityContainer<HotelsAggregatorGdsAccount>> getGdsAccounts(SalesContext salesContext) throws Exception {
        HotelsParametersActions actions = HotelsGdsHelper.calcHotelsParametersActions(salesContext);
        return actions.getApplicableGdsAccounts().stream().map(accountRef -> EntityStorage.get().resolve(accountRef)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public static boolean isSearchByRadiusEnabled(SalesContext salesContext) throws Exception {
        HotelsParametersActions actions = HotelsGdsHelper.calcHotelsParametersActions(salesContext);
        return actions.isSearchByRadius();
    }

    private static HotelsParametersActions calcHotelsParametersActions(SalesContext salesContext) throws Exception {
        if (salesContext.getClient() == null) {
            salesContext.setClient(ProfileHelper.findRetailProfileReference());
        }
        RuleSet rules = SalesContextHandler.get().getRules(salesContext);
        RuleProxy proxy = new RuleProxy();
        proxy.getTracer().setDisabled(!LoggerFactory.getLogger((String)"com.gridnine.xtrip.server.gds.GDSConnector.RULES_TRACE").isDebugEnabled());
        proxy.setProxyType(HotelsTargets.HOTEL_PARAMETERS.getId());
        proxy.setProxyDate(new Date());
        proxy.setPropertySet((Object)new HotelsParametersProperties(salesContext, proxy));
        proxy.setActionSet((Object)new HotelsParametersActions());
        RuleEngine.applyRules(Collections.singletonList(proxy), (RuleSet)rules);
        return (HotelsParametersActions)proxy.getActionSet();
    }
}

