/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.hotels2.ibus.helpers;

import com.gridnine.hotels.web.ws.CancellationPeriodWS;
import com.gridnine.hotels.web.ws.CancellationPolicyWS;
import com.gridnine.hotels.web.ws.Commission;
import com.gridnine.hotels.web.ws.Contact;
import com.gridnine.hotels.web.ws.CountryData;
import com.gridnine.hotels.web.ws.CreditCardTypeWS;
import com.gridnine.hotels.web.ws.DoPricingQuery;
import com.gridnine.hotels.web.ws.DocumentReference;
import com.gridnine.hotels.web.ws.EssentialInfo;
import com.gridnine.hotels.web.ws.Facility;
import com.gridnine.hotels.web.ws.GeoLocation;
import com.gridnine.hotels.web.ws.GeoLocationType;
import com.gridnine.hotels.web.ws.GuaranteeTypeWS;
import com.gridnine.hotels.web.ws.GuaranteeWS;
import com.gridnine.hotels.web.ws.HotelCard;
import com.gridnine.hotels.web.ws.HotelInfo;
import com.gridnine.hotels.web.ws.HotelsCheckInOutOption;
import com.gridnine.hotels.web.ws.HotelsCheckInOutOptionType;
import com.gridnine.hotels.web.ws.HotelsCustomOption;
import com.gridnine.hotels.web.ws.HotelsDateTimeSpecialValue;
import com.gridnine.hotels.web.ws.HotelsExtraBedOption;
import com.gridnine.hotels.web.ws.HotelsMealplanOption;
import com.gridnine.hotels.web.ws.HotelsMoney;
import com.gridnine.hotels.web.ws.HotelsOption;
import com.gridnine.hotels.web.ws.HotelsOptionAvailability;
import com.gridnine.hotels.web.ws.HotelsOptionAvailabilityType;
import com.gridnine.hotels.web.ws.HotelsOptionList;
import com.gridnine.hotels.web.ws.HotelsProviderCodeEntry;
import com.gridnine.hotels.web.ws.HotelsRoom;
import com.gridnine.hotels.web.ws.HotelsStayPolicy;
import com.gridnine.hotels.web.ws.LoadReservationQuery;
import com.gridnine.hotels.web.ws.LocationData;
import com.gridnine.hotels.web.ws.OfferOption;
import com.gridnine.hotels.web.ws.OfferOptionSet;
import com.gridnine.hotels.web.ws.OfferOptionType;
import com.gridnine.hotels.web.ws.PolicyDescription;
import com.gridnine.hotels.web.ws.PricedItem;
import com.gridnine.hotels.web.ws.PricingItem;
import com.gridnine.hotels.web.ws.PricingResultItem;
import com.gridnine.hotels.web.ws.RateType;
import com.gridnine.hotels.web.ws.Remark;
import com.gridnine.hotels.web.ws.RemarkType;
import com.gridnine.hotels.web.ws.ReservationID;
import com.gridnine.hotels.web.ws.ReservationItem;
import com.gridnine.hotels.web.ws.ReservationQueryItem;
import com.gridnine.hotels.web.ws.ReservationResult;
import com.gridnine.hotels.web.ws.RoomInfo;
import com.gridnine.hotels.web.ws.RoomSize;
import com.gridnine.hotels.web.ws.SubProvider;
import com.gridnine.xtrip.common.hotels2.HotelAggregatorSettings;
import com.gridnine.xtrip.common.hotels2.model.AdultExtraBedOption;
import com.gridnine.xtrip.common.hotels2.model.CancellablePolicy;
import com.gridnine.xtrip.common.hotels2.model.CancellationChargeHolder;
import com.gridnine.xtrip.common.hotels2.model.CancellationPolicy;
import com.gridnine.xtrip.common.hotels2.model.CheckInOption;
import com.gridnine.xtrip.common.hotels2.model.CheckOutOption;
import com.gridnine.xtrip.common.hotels2.model.ChildExtraBedOption;
import com.gridnine.xtrip.common.hotels2.model.DocumentCategory;
import com.gridnine.xtrip.common.hotels2.model.ExtraBedsVariant;
import com.gridnine.xtrip.common.hotels2.model.Guarantee;
import com.gridnine.xtrip.common.hotels2.model.GuestField;
import com.gridnine.xtrip.common.hotels2.model.HotelCard;
import com.gridnine.xtrip.common.hotels2.model.HotelOffer;
import com.gridnine.xtrip.common.hotels2.model.HotelOptions;
import com.gridnine.xtrip.common.hotels2.model.HotelSummary;
import com.gridnine.xtrip.common.hotels2.model.HotelsAggregatorGdsAccount;
import com.gridnine.xtrip.common.hotels2.model.HotelsServiceOption;
import com.gridnine.xtrip.common.hotels2.model.HotelsServiceOptionAvailability;
import com.gridnine.xtrip.common.hotels2.model.HotelsServiceOptionAvailabilityType;
import com.gridnine.xtrip.common.hotels2.model.HotelsServiceOptionStatus;
import com.gridnine.xtrip.common.hotels2.model.InfantExtraBedOption;
import com.gridnine.xtrip.common.hotels2.model.MealOption;
import com.gridnine.xtrip.common.hotels2.model.MealPlan;
import com.gridnine.xtrip.common.hotels2.model.NonCancellablePolicy;
import com.gridnine.xtrip.common.hotels2.model.ProviderInfo;
import com.gridnine.xtrip.common.hotels2.model.ProviderVatInfo;
import com.gridnine.xtrip.common.hotels2.model.RemarkDataType;
import com.gridnine.xtrip.common.hotels2.model.RoomCard;
import com.gridnine.xtrip.common.hotels2.model.RoomInfo;
import com.gridnine.xtrip.common.hotels2.model.SearchOffersParameters;
import com.gridnine.xtrip.common.hotels2.model.ServiceType;
import com.gridnine.xtrip.common.incidents.IncidentsHelper;
import com.gridnine.xtrip.common.incidents.IncidentsLog;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.l10n.model.L10nString;
import com.gridnine.xtrip.common.l10n.model.L10nStringHelper;
import com.gridnine.xtrip.common.l10n.model.LocaleHelper;
import com.gridnine.xtrip.common.midoffice.helper.ReservationGdsNameInfoHelper;
import com.gridnine.xtrip.common.midoffice.helper.SalesContextHandler;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.CurrencyRateType;
import com.gridnine.xtrip.common.model.booking.GeneralProductCommission;
import com.gridnine.xtrip.common.model.booking.PassengerType;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.RecordLocatorType;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.ReservationRemark;
import com.gridnine.xtrip.common.model.booking.ReservationStatus;
import com.gridnine.xtrip.common.model.booking.StatisticalData;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.xtriphotels.AdditionalService;
import com.gridnine.xtrip.common.model.booking.xtriphotels.AdditionalServiceType;
import com.gridnine.xtrip.common.model.booking.xtriphotels.AvailableOption;
import com.gridnine.xtrip.common.model.booking.xtriphotels.CancellationCharge;
import com.gridnine.xtrip.common.model.booking.xtriphotels.DailyRate;
import com.gridnine.xtrip.common.model.booking.xtriphotels.EssentialInfoData;
import com.gridnine.xtrip.common.model.booking.xtriphotels.EssentialInfoDataType;
import com.gridnine.xtrip.common.model.booking.xtriphotels.GuaranteeType;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProduct;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProductCommission;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProductContractRelationData;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProductTax;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProvider;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProviderDictData;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelSubProvider;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelType;
import com.gridnine.xtrip.common.model.booking.xtriphotels.Location;
import com.gridnine.xtrip.common.model.booking.xtriphotels.Meal;
import com.gridnine.xtrip.common.model.booking.xtriphotels.PassengerTypeReference;
import com.gridnine.xtrip.common.model.booking.xtriphotels.Penalty;
import com.gridnine.xtrip.common.model.booking.xtriphotels.Room;
import com.gridnine.xtrip.common.model.booking.xtriphotels.TaxInfo;
import com.gridnine.xtrip.common.model.booking.xtriphotels.service.HotelsPayee;
import com.gridnine.xtrip.common.model.booking.xtriphotels.service.HotelsServiceAvailability;
import com.gridnine.xtrip.common.model.booking.xtriphotels.service.HotelsStayType;
import com.gridnine.xtrip.common.model.booking.xtriphotels.service.HotelsTimeUnit;
import com.gridnine.xtrip.common.model.dict.AddressType;
import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.model.dict.CommunicationType;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.dict.Country;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.dict.Hotel;
import com.gridnine.xtrip.common.model.dict.HotelTariffType;
import com.gridnine.xtrip.common.model.dict.RoomSizeDict;
import com.gridnine.xtrip.common.model.dict.TariffType;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.CancellationChargeHelper;
import com.gridnine.xtrip.common.model.helpers.CommonReservationGdsNameInfoHelper;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.FinanceHelper;
import com.gridnine.xtrip.common.model.helpers.GeoLocationHelper;
import com.gridnine.xtrip.common.model.helpers.HotelProductHelper;
import com.gridnine.xtrip.common.model.helpers.MoneyHelper;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.helpers.vat.hotel.HotelProductVatFiller;
import com.gridnine.xtrip.common.model.profile.Address;
import com.gridnine.xtrip.common.model.profile.CalculatedStatisticType;
import com.gridnine.xtrip.common.model.profile.Communication;
import com.gridnine.xtrip.common.model.profile.Contract;
import com.gridnine.xtrip.common.model.rules.standard.hotelProductSettings.HotelProductSettingsActionSet;
import com.gridnine.xtrip.common.model.standard.helpers.MessagesHelper;
import com.gridnine.xtrip.common.model.system.CardVendor;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.model.system.VatAmount;
import com.gridnine.xtrip.common.rules.elements.RuleProxy;
import com.gridnine.xtrip.common.statistic.helpers.CommonStatisticsHelper;
import com.gridnine.xtrip.common.util.BooleanUtil;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.Consumers;
import com.gridnine.xtrip.common.util.EnumUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.hotels2.ibus.IBusHotelsContextKeys;
import com.gridnine.xtrip.server.hotels2.ibus.helpers.CancellationPolicyHelper;
import com.gridnine.xtrip.server.hotels2.ibus.helpers.HotelsBaseHelper;
import com.gridnine.xtrip.server.hotels2.ibus.helpers.HotelsReservationHelper;
import com.gridnine.xtrip.server.hotels2.ibus.helpers.PenaltyHelper;
import com.gridnine.xtrip.server.hotels2.ibus.helpers.VatHelper;
import com.gridnine.xtrip.server.model.handlers.rules.hotel.HotelRulesHelper;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.EnumSet;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.xml.datatype.XMLGregorianCalendar;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;

public class HotelsHelper {
    public static final String HB_PRO_CODE = "HOTELBOOK_HBPro";
    private static final String NO_CODE_NAME = "NO-CODE";
    private static final String NO_NAME_NAME = "NO-NAME";
    private static final EntityReference<HotelAggregatorSettings> settingsRef = new EntityReference("ibecorp-HOTEL-AGGREGATOR-SETTINGS", HotelAggregatorSettings.class, null);

    public static EntityContainer<HotelAggregatorSettings> getHotelAggregatorSettings() {
        return EntityStorage.get().resolve(settingsRef);
    }

    public static DictionaryReference<HotelSubProvider> findSubProvider(HotelProvider provider, SubProvider subProvider) {
        if (subProvider == null) {
            return null;
        }
        return HotelsHelper.findSubProvider(provider, subProvider.getProviderName());
    }

    public static DictionaryReference<HotelSubProvider> findSubProvider(HotelProvider provider, String subProviderName) {
        String subProviderCode = HotelsHelper.buildSubProviderCode(provider, subProviderName);
        HotelSubProvider subProvider = (HotelSubProvider)DictionaryCache.get().findByCode(HotelSubProvider.class, subProviderCode);
        return subProvider != null ? subProvider.toReference() : null;
    }

    private static Address convertAddress(GeoLocation wslocation, String address) {
        Address result = HotelsHelper.convertToAddress(wslocation);
        HotelsHelper.putStringToL10n(result.getAddress(), address);
        return result;
    }

    private static String buildSubProviderCode(HotelProvider provider, String subProviderName) {
        if (provider == null || TextUtil.isBlank((String)subProviderName)) {
            return null;
        }
        return provider.name().concat("_").concat(subProviderName);
    }

    public static String getSubProviderNameFromCode(DictionaryReference<HotelSubProvider> subProvider) {
        if (subProvider == null || TextUtil.isBlank((String)subProvider.getCode())) {
            return null;
        }
        String[] names = subProvider.getCode().split("_");
        if (names.length > 1) {
            return names[names.length - 1];
        }
        return null;
    }

    public static LoadReservationQuery.DictionaryLanguages buildDefaultDictionaryLanguages() {
        LoadReservationQuery.DictionaryLanguages result = new LoadReservationQuery.DictionaryLanguages();
        HotelsHelper.populateDictionaryLanguages(result.getEntry());
        return result;
    }

    private static boolean isOptionSetContains(OfferOptionSet offerOptionSet, OfferOptionType optionType) {
        if (offerOptionSet == null || offerOptionSet.getGuarantee() == null || CollectionUtil.isEmpty((Collection)offerOptionSet.getGuarantee().getEntry())) {
            return false;
        }
        return offerOptionSet.getGuarantee().getEntry().stream().filter(Objects::nonNull).anyMatch(entry -> entry.getKey() == optionType && BooleanUtils.isTrue((Boolean)entry.isValue()));
    }

    public static HotelCard convertHotelCard(com.gridnine.hotels.web.ws.HotelCard wsCard) {
        if (wsCard == null) {
            return null;
        }
        HotelCard result = new HotelCard();
        result.setNumber(StringUtils.trim((String)wsCard.getNumber()));
        result.setName(StringUtils.trim((String)wsCard.getName()));
        result.setDescription(StringUtils.trim((String)wsCard.getDescription()));
        result.setProvider(HotelsBaseHelper.convertProviderFromGds(wsCard.getProvider()));
        result.setHotelStars(HotelsBaseHelper.convertHotelCategoryFromGds(wsCard.getCategory()));
        result.setSabreRating(wsCard.getSabreRating());
        result.setLatitude(Double.valueOf(wsCard.getLatitude()));
        result.setLongitude(Double.valueOf(wsCard.getLongitude()));
        result.setDirectContract(BooleanUtils.isTrue((Boolean)wsCard.isDirectContract()));
        result.setHotelResolved(wsCard.isHotelResolved());
        if (wsCard.getHotelType() != null) {
            result.setHotelType((HotelType)EnumUtil.fromNameSafe(HotelType.class, (String)wsCard.getHotelType().name(), null));
        }
        result.setCheckInTime(HotelsBaseHelper.toLocalTime(wsCard.getCheckinTime()));
        result.setCheckOutTime(HotelsBaseHelper.toLocalTime(wsCard.getCheckoutTime()));
        result.setAddress(HotelsHelper.convertToAddress(wsCard.getAddress(), wsCard.getCity()));
        if (wsCard.getNearLocations() != null) {
            HotelsHelper.fillStringList(result.getNearLocations(), wsCard.getNearLocations().getLocation());
        }
        if (wsCard.getContacts() != null) {
            HotelsHelper.fillContacts(result.getContacts(), wsCard.getContacts().getContact());
        }
        ProviderInfo providerInfo = result.getProviderInfo().computeIfAbsent(HotelsBaseHelper.convertProviderFromGds(wsCard.getProvider()), provider -> new ProviderInfo());
        providerInfo.setStandardCheckInTime(HotelsHelper.convertTime(wsCard.getCheckinTime()));
        providerInfo.setStandardCheckOutTime(HotelsHelper.convertTime(wsCard.getCheckoutTime()));
        if (wsCard.getEssentialInfo() != null && wsCard.getEssentialInfo().getInfoMap() != null) {
            providerInfo.getEssentialInfo().addAll(HotelsHelper.buildEssentialInfoList(wsCard.getEssentialInfo().getInfoMap().getEntry()));
        }
        if (wsCard.getRooms() != null) {
            HotelsHelper.fillRooms(providerInfo.getRooms(), wsCard.getRooms().getRoom());
        }
        if (wsCard.getBaseFacility() != null) {
            HotelsHelper.fillFacilities(result.getBaseFacilities(), wsCard.getBaseFacility().getBaseFacility());
        }
        if (wsCard.getFacilities() != null) {
            HotelsHelper.fillFacilities(result.getFacilities(), wsCard.getFacilities().getFacility());
        }
        if (wsCard.getDocuments() != null) {
            HotelsHelper.fillDocumentRefs(result.getDocuments(), wsCard.getDocuments().getDocument());
        }
        HotelsHelper.fillVendorCodes(result.getVendorCodes(), wsCard.getProviderCodes());
        if (wsCard.getPolicyDescriptions() != null && wsCard.getPolicyDescriptions().getPolicyDescription() != null) {
            for (PolicyDescription pd : wsCard.getPolicyDescriptions().getPolicyDescription()) {
                com.gridnine.xtrip.common.hotels2.model.PolicyDescription item = new com.gridnine.xtrip.common.hotels2.model.PolicyDescription();
                item.setTitle(pd.getTitle());
                item.setDescription(pd.getDescription());
                result.getPolicyDescriptions().add(item);
            }
        }
        return result;
    }

    public static void convertToHotelCard(List<RoomInfo> roomInfos, Collection<com.gridnine.hotels.web.ws.HotelOffer> hotelOffers, HotelCard hotelCard, EntityContainer<HotelsAggregatorGdsAccount> gdsAccountCtr) {
        ArrayList<com.gridnine.hotels.web.ws.HotelOffer> hotelOffersClone = new ArrayList<com.gridnine.hotels.web.ws.HotelOffer>(hotelOffers);
        for (RoomInfo rf : roomInfos) {
            if (hotelOffers.isEmpty()) break;
            Iterator<com.gridnine.hotels.web.ws.HotelOffer> iterOffer = hotelOffersClone.iterator();
            long nonChildTravellers = rf.getTravellers().stream().filter(traveller -> !HotelsReservationHelper.isChild(traveller.getBirthday())).count();
            while (iterOffer.hasNext()) {
                com.gridnine.hotels.web.ws.HotelOffer offer = iterOffer.next();
                if ((long)offer.getRoomInfo().getStandardNumberOfGuests() != nonChildTravellers) continue;
                try {
                    HotelOffer hotelOfferRes = HotelsHelper.convertHotelOffer(offer, hotelCard, gdsAccountCtr, rf);
                    hotelCard.getHotelOffers().add(hotelOfferRes);
                }
                catch (Throwable ex) {
                    IncidentsHelper.addStackTraceElement((Throwable)ex, (StackTraceElement[])new StackTraceElement[]{IncidentsHelper.getContextStackTraceElement((String)"GdsAccount", (String)((HotelsAggregatorGdsAccount)gdsAccountCtr.getEntity()).toString()), IncidentsHelper.getContextStackTraceElement((String)"Vendor", (String)offer.getVendor()), IncidentsHelper.getContextStackTraceElement((String)"HotelCardNumber", (String)offer.getHotelCardNumber()), IncidentsHelper.getContextStackTraceElement((String)"RoomName", (String)offer.getRoomName())});
                    IncidentsLog.reportException((String)"convertToHotelCard failed", (Throwable)ex);
                }
                iterOffer.remove();
            }
        }
    }

    private static HotelOffer convertHotelOffer(com.gridnine.hotels.web.ws.HotelOffer wsOffer, HotelCard hotelCard, EntityContainer<HotelsAggregatorGdsAccount> gdsAccountCtr, RoomInfo rf) {
        ProviderInfo providerInfo;
        HotelOffer result = new HotelOffer();
        result.setGdsAccount(gdsAccountCtr.toReference());
        result.setHotelCardNumber(wsOffer.getHotelCardNumber() != null ? wsOffer.getHotelCardNumber() : hotelCard.getNumber());
        HotelProvider provider = (HotelProvider)EnumUtil.recodeSafe((Enum)wsOffer.getProvider(), HotelProvider.class);
        result.setProvider(provider);
        result.setProviderHotelCode((String)hotelCard.getVendorCodes().get(provider));
        result.setOfferToken(wsOffer.getOfferToken());
        result.setId(wsOffer.getRoom().getSignature());
        result.setSearchOfferId(wsOffer.getRoom().getSignature());
        result.setFreeForSale(wsOffer.isFreeForSale());
        result.setRackRate(MoneyHelper.moneyOrNull((BigDecimal)wsOffer.getRackRate(), (String)wsOffer.getRackRateCurrency()));
        result.setRoomName(HotelsHelper.getTopmostRoomName(wsOffer));
        result.setRoomDescription(wsOffer.getRoomDescription());
        if (wsOffer.getEssentialInfo() != null && wsOffer.getEssentialInfo().getInfoMap() != null) {
            result.getEssentialInfoList().addAll(HotelsHelper.buildEssentialInfoList(wsOffer.getEssentialInfo().getInfoMap().getEntry()));
        }
        if ((providerInfo = (ProviderInfo)hotelCard.getProviderInfo().get(result.getProvider())) != null) {
            HotelsHelper.addEssentialInfo(providerInfo.getEssentialInfo(), result.getEssentialInfoList());
            RoomCard roomCard = providerInfo.getRooms().stream().filter(card -> MiscUtil.equals((Object)card.getProviderId(), (Object)wsOffer.getRoom().getSignature(), (boolean)false) || MiscUtil.equals((Object)card.getName(), (Object)wsOffer.getRoom().getProviderName(), (boolean)false)).findFirst().orElse(null);
            if (roomCard != null) {
                if (TextUtil.isBlank((String)result.getRoomDescription())) {
                    result.setRoomDescription(roomCard.getDescription());
                }
                if (CollectionUtil.isNotEmpty((Collection)roomCard.getAmenities())) {
                    EssentialInfoData amenities = HotelsHelper.buildRoomAmenities(roomCard.getAmenities());
                    HotelsHelper.addEssentialInfo(Collections.singletonList(amenities), result.getEssentialInfoList());
                }
            }
        }
        result.setMealIncluded(HotelsHelper.getMealIncluded(wsOffer.getOptions()));
        result.setSubProvider(HotelsHelper.findSubProvider(result.getProvider(), wsOffer.getDisplayVendor()));
        result.setVendor(wsOffer.getDisplayVendor());
        result.setBlankOwnerCode(wsOffer.getVendor());
        result.setAvailability(HotelsHelper.convertAvailabilityFromGds(wsOffer.getAvailability()));
        result.setRoomInfo(HotelsHelper.convertRoomInfoFromGds(wsOffer.getRoomInfo()));
        result.setRoomInfo(rf);
        result.setCancellationPolicy(CancellationPolicyHelper.cancellationPolicy(wsOffer, GeoLocationHelper.timeZone((DictionaryReference)hotelCard.getAddress().getCity())));
        result.setRateType(HotelsHelper.getRateType(result.getCancellationPolicy(), wsOffer.getRateType()));
        result.setAdditionalInfo(wsOffer.getAdditionalInfo());
        result.setRoomsNumber(wsOffer.getRoomsNumber());
        result.setBasePrice(MoneyHelper.buildMoney((BigDecimal)wsOffer.getBasePrice().getAmount(), (String)wsOffer.getBasePrice().getCurrencyCode()));
        result.setMaxPrice(wsOffer.getMaxPrice());
        result.setStayPolicy(HotelsHelper.convertHotelsStayPolicyFromGds(wsOffer.getStayPolicy(), null));
        result.setTripartiteContract(BooleanUtils.isTrue((Boolean)wsOffer.isIsTripartiteAgreement()));
        result.setClientTariffCode(wsOffer.getClientTariffCode());
        com.gridnine.xtrip.common.hotels2.model.HotelsStayPolicy stayPolicy = result.getStayPolicy();
        if (stayPolicy.getCheckInTime() == null) {
            LocalTime checkInTime = Optional.ofNullable(providerInfo).map(ProviderInfo::getStandardCheckInTime).orElseGet(() -> ((HotelCard)hotelCard).getCheckInTime());
            stayPolicy.setCheckInTime(checkInTime);
        }
        if (stayPolicy.getCheckOutTime() == null) {
            LocalTime checkOutTime = Optional.ofNullable(providerInfo).map(ProviderInfo::getStandardCheckOutTime).orElseGet(() -> ((HotelCard)hotelCard).getCheckOutTime());
            stayPolicy.setCheckOutTime(checkOutTime);
        }
        if (stayPolicy.getStandardCheckInTime() == null) {
            LocalTime standardCheckInTime = Optional.ofNullable(providerInfo).map(ProviderInfo::getStandardCheckInTime).orElseGet(() -> ((HotelCard)hotelCard).getCheckInTime());
            stayPolicy.setStandardCheckInTime(standardCheckInTime);
        }
        if (stayPolicy.getStandardCheckOutTime() == null) {
            LocalTime standardCheckOutTime = Optional.ofNullable(providerInfo).map(ProviderInfo::getStandardCheckOutTime).orElseGet(() -> ((HotelCard)hotelCard).getCheckOutTime());
            stayPolicy.setStandardCheckOutTime(standardCheckOutTime);
        }
        wsOffer.getBreakdown().forEach(m -> result.getBreakdowns().add(HotelsBaseHelper.convertMoneyFromGds(m)));
        HotelsHelper.fillOptions(result.getOptions(), wsOffer.getOptions());
        result.getAdditionalServices().addAll(HotelsHelper.buildAdditionalServices(wsOffer.getOptions(), new Date(), true));
        if (wsOffer.getGuarantees() != null) {
            HotelsHelper.fillGuarantees(result.getGuarantees(), wsOffer.getGuarantees().getGuarantee());
        }
        ProviderVatInfo providerVatInfo = result.getProviderVatInfo();
        HotelsHelper.processProviderVatInfo(providerVatInfo, wsOffer);
        result.setHotelCommission(HotelsHelper.getHotelCommission(wsOffer.getCommission(), result.getBasePrice()));
        if (wsOffer.getTaxInfoList() != null) {
            result.getTaxInfoList().addAll(HotelsHelper.buildTaxInfoList(wsOffer.getTaxInfoList().getTaxInfo()));
        }
        return result;
    }

    private static EssentialInfoData buildRoomAmenities(List<String> amenities) {
        EssentialInfoData result = new EssentialInfoData();
        result.setType(EssentialInfoDataType.ROOM_AMENITIES);
        HotelsHelper.addTrimStrings(amenities, result.getInfoValue());
        return result;
    }

    private static List<EssentialInfoData> buildEssentialInfoList(List<EssentialInfo.InfoMap.Entry> infoMapList) {
        ArrayList<EssentialInfoData> result = new ArrayList<EssentialInfoData>();
        if (infoMapList == null) {
            return result;
        }
        for (EssentialInfo.InfoMap.Entry entry : infoMapList) {
            if (entry.getValue() == null || entry.getValue().getInfoValue() == null || !CollectionUtil.isNotEmpty((Collection)entry.getValue().getInfoValue().getInfoValue())) continue;
            EssentialInfoData item = new EssentialInfoData();
            item.setType((EssentialInfoDataType)Optional.ofNullable(EnumUtil.recodeSafe((Enum)entry.getKey(), EssentialInfoDataType.class)).orElse((Enum)EssentialInfoDataType.UNDEFINED));
            HotelsHelper.addTrimStrings(entry.getValue().getInfoValue().getInfoValue(), item.getInfoValue());
            HotelsHelper.addEssentialInfo(Collections.singletonList(item), result);
        }
        return result;
    }

    private static void addTrimStrings(Collection<String> from, Collection<String> to) {
        from.stream().filter(TextUtil::nonBlank).map(TextUtil::trim).forEach(to::add);
    }

    public static void addEssentialInfo(List<EssentialInfoData> src, List<EssentialInfoData> dest) {
        for (EssentialInfoData srcInfo : src) {
            EssentialInfoData info = dest.stream().filter(destInfo -> destInfo.getType() == srcInfo.getType()).findFirst().orElse(null);
            if (info == null) {
                dest.add(srcInfo);
                continue;
            }
            info.getInfoValue().addAll(srcInfo.getInfoValue());
        }
    }

    private static Collection<TaxInfo> buildTaxInfoList(List<com.gridnine.hotels.web.ws.TaxInfo> taxInfoList) {
        if (null == taxInfoList) {
            return Collections.emptyList();
        }
        ArrayList<TaxInfo> result = new ArrayList<TaxInfo>();
        for (com.gridnine.hotels.web.ws.TaxInfo taxInfo : taxInfoList) {
            TaxInfo item = new TaxInfo();
            item.setName(taxInfo.getName());
            item.setAmount(HotelsBaseHelper.convertMoneyFromGds(taxInfo.getMoney()));
            item.setIncludedInTariff(Boolean.TRUE.equals(taxInfo.isIncluded()));
            result.add(item);
        }
        return result;
    }

    public static HotelOffer convertHotelOffer(PricingItem wsPricingItem, HotelCard hotelCard, PricingResultItem pricingResultItem, HotelOffer originalOffer, EntityReference<HotelsAggregatorGdsAccount> gdsAccountRef) {
        Money totalPrice;
        ReservationResult reservationResult = pricingResultItem.getReservationResult();
        ReservationItem reservationItem = reservationResult.getReservationItems().getReservationItems().stream().filter(i -> Objects.equals(i.getRequestItemId(), wsPricingItem.getRequestItemId())).findFirst().orElseThrow(() -> Xeption.forDeveloper((String)"no reservation item with requestItemId = {0}", (Object[])new Object[]{wsPricingItem.getRequestItemId()}));
        HotelOffer result = new HotelOffer();
        result.setGdsAccount(gdsAccountRef);
        result.setHotelCardNumber(wsPricingItem.getHotelCardNumber());
        result.setOfferToken(wsPricingItem.getOfferToken());
        result.setId(wsPricingItem.getRoom().getSignature());
        result.setSearchOfferId(originalOffer.getSearchOfferId());
        result.setFreeForSale(wsPricingItem.isFreeForSale());
        result.setProvider((HotelProvider)EnumUtil.recodeSafe((Enum)reservationResult.getProvider(), HotelProvider.class));
        result.setVendor(originalOffer.getVendor());
        result.setProviderHotelCode(originalOffer.getProviderHotelCode());
        result.setRackRate(MoneyHelper.moneyOrNull((BigDecimal)wsPricingItem.getRackRate(), (String)wsPricingItem.getRackRateCurrency()));
        result.setRoomName(HotelsHelper.getTopmostRoomName(wsPricingItem));
        result.setMealIncluded(HotelsHelper.getMealIncluded(wsPricingItem.getOptions()));
        result.setSubProvider(HotelsHelper.findSubProvider(result.getProvider(), reservationItem.getSubProvider()));
        result.setBlankOwnerCode(reservationResult.getVendor());
        if (reservationItem.getEssentialInfo() != null && reservationItem.getEssentialInfo().getInfo() != null) {
            HotelsHelper.addTrimStrings(reservationItem.getEssentialInfo().getInfo().getInfo(), result.getEssentialInfo());
            result.getEssentialInfoList().addAll(HotelsHelper.buildEssentialInfoList(reservationItem.getEssentialInfo().getInfoMap().getEntry()));
        }
        result.setAvailability(HotelsHelper.convertAvailabilityFromGds(wsPricingItem.getAvailability()));
        result.setRoomInfo(HotelsHelper.convertRoomInfoFromGds(wsPricingItem));
        result.setCancellationPolicy(CancellationPolicyHelper.cancellationPolicy(wsPricingItem, GeoLocationHelper.timeZone((DictionaryReference)hotelCard.getAddress().getCity()), reservationResult.getProvider()));
        result.setRateType(HotelsHelper.getRateType(result.getCancellationPolicy(), wsPricingItem.getRateType()));
        result.setAdditionalInfo(reservationItem.getAdditionalInfo());
        result.setRoomsNumber(wsPricingItem.getRoomsNumber());
        result.setCommentAllowed(Boolean.TRUE.equals(wsPricingItem.isIsCommentAllowed()));
        result.setTripartiteContract(BooleanUtils.isTrue((Boolean)reservationItem.isIsTripartiteAgreement()));
        result.setClientTariffCode(reservationItem.getClientTariffCode());
        if (!wsPricingItem.getPrice().getBreakdown().isEmpty()) {
            BigDecimal amount = wsPricingItem.getPrice().getBreakdown().stream().map(HotelsMoney::getAmount).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
            String currency = wsPricingItem.getPrice().getBreakdown().stream().map(HotelsMoney::getCurrency).findFirst().orElse(null);
            totalPrice = MoneyHelper.buildMoney((BigDecimal)amount, (String)currency);
        } else {
            totalPrice = HotelsBaseHelper.convertMoneyFromGds(wsPricingItem.getPrice());
        }
        result.setBasePrice(totalPrice);
        result.setStayPolicy(HotelsHelper.convertHotelsStayPolicyFromGds(wsPricingItem.getStayPolicy(), originalOffer.getStayPolicy()));
        com.gridnine.xtrip.common.hotels2.model.HotelsStayPolicy stayPolicy = result.getStayPolicy();
        if (stayPolicy.getCheckInTime() == null) {
            if (wsPricingItem.getCheckInTime() != null) {
                stayPolicy.setCheckInTime(HotelsHelper.convertTime(wsPricingItem.getCheckInTime()));
            } else {
                stayPolicy.setCheckInTime(hotelCard.getCheckInTime());
            }
        }
        if (stayPolicy.getCheckOutTime() == null) {
            if (wsPricingItem.getCheckOutTime() != null) {
                stayPolicy.setCheckOutTime(HotelsHelper.convertTime(wsPricingItem.getCheckOutTime()));
            } else {
                stayPolicy.setCheckOutTime(hotelCard.getCheckOutTime());
            }
        }
        if (stayPolicy.getStandardCheckInTime() == null) {
            if (wsPricingItem.getStandardCheckinTime() > 0) {
                stayPolicy.setStandardCheckInTime(HotelsHelper.convertTime(wsPricingItem.getStandardCheckinTime()));
            } else if (originalOffer != null && originalOffer.getStayPolicy() != null && originalOffer.getStayPolicy().getStandardCheckInTime() != null) {
                stayPolicy.setStandardCheckInTime(originalOffer.getStayPolicy().getStandardCheckInTime());
            } else {
                stayPolicy.setStandardCheckInTime(hotelCard.getCheckInTime());
            }
        }
        if (stayPolicy.getStandardCheckOutTime() == null) {
            if (wsPricingItem.getStandardCheckoutTime() > 0) {
                stayPolicy.setStandardCheckOutTime(HotelsHelper.convertTime(wsPricingItem.getStandardCheckoutTime()));
            } else if (originalOffer != null && originalOffer.getStayPolicy() != null && originalOffer.getStayPolicy().getStandardCheckInTime() != null) {
                stayPolicy.setStandardCheckOutTime(originalOffer.getStayPolicy().getStandardCheckOutTime());
            } else {
                stayPolicy.setStandardCheckOutTime(hotelCard.getCheckOutTime());
            }
        }
        ProviderVatInfo providerVatInfo = result.getProviderVatInfo();
        HotelsHelper.processProviderVatInfo(providerVatInfo, wsPricingItem);
        result.setHotelCommission(HotelsHelper.getHotelCommission(wsPricingItem.getCommission(), result.getBasePrice()));
        for (OfferOptionType x : wsPricingItem.getByRemark()) {
            AdditionalServiceType t = HotelsHelper.getAdditionalServiceType(x);
            result.getRequestedByRemark().add(t);
        }
        if (HotelsHelper.contains(wsPricingItem, OfferOptionType.EARLY_CHECKIN)) {
            result.getRequestedByRemark().add(AdditionalServiceType.EARLIER_CHECKIN);
        }
        if (HotelsHelper.contains(wsPricingItem, OfferOptionType.LATE_CHECKOUT)) {
            result.getRequestedByRemark().add(AdditionalServiceType.LATER_CHECKOUT);
        }
        for (OfferOptionType x : wsPricingItem.getExtraBedsVariants()) {
            ExtraBedsVariant v = new ExtraBedsVariant();
            if (x.getAdults() > 0) {
                result.getRequestedByRemark().add(AdditionalServiceType.EXTRA_BED_ADULT);
            }
            if (x.getChildren() > 0) {
                result.getRequestedByRemark().add(AdditionalServiceType.EXTRA_BED_CHILD);
            }
            if (x.getInfants() > 0) {
                result.getRequestedByRemark().add(AdditionalServiceType.EXTRA_BED_INFANT);
            }
            v.setAdults(Integer.valueOf(x.getAdults()));
            v.setChildren(Integer.valueOf(x.getChildren()));
            v.setInfants(Integer.valueOf(x.getInfants()));
            result.getExtraBedsVariants().add(v);
        }
        pricingResultItem.getMandatoryGuestField().forEach(i -> result.getMandatoryGuestField().add(GuestField.valueOf((String)i.name())));
        result.setCancellationPolicyCostsMayChange(Boolean.TRUE.equals(pricingResultItem.isCancellationPolicyCostsMayChange()));
        if (wsPricingItem.getPrice() != null) {
            wsPricingItem.getPrice().getBreakdown().forEach(m -> result.getBreakdowns().add(HotelsBaseHelper.convertMoneyFromGds(m)));
        }
        HotelsHelper.fillOptions(result.getOptions(), wsPricingItem.getOptions());
        result.getAdditionalServices().addAll(HotelsHelper.buildAdditionalServices(wsPricingItem.getOptions(), new Date(), true));
        List<AdditionalService> notConfirmedAdditionalServices = HotelsHelper.buildAdditionalServices(wsPricingItem.getOptions(), new Date(), false);
        if (!notConfirmedAdditionalServices.isEmpty()) {
            throw Xeption.forEndUser((String)L10nResourcesManager.getStr((String)"HOTELS2_PROVIDER_HAS_NOT_CONFIRMED_ADDITIONAL_SERVICES", (Object[])new Object[]{notConfirmedAdditionalServices.stream().map(AdditionalService::getName).collect(Collectors.joining(", "))}), (Object[])new Object[0]);
        }
        if (wsPricingItem.getGuarantees() != null) {
            HotelsHelper.fillGuarantees(result.getGuarantees(), wsPricingItem.getGuarantees().getGuarantee());
        }
        if (reservationItem.getTaxInfoList() != null) {
            result.getTaxInfoList().addAll(HotelsHelper.buildTaxInfoList(reservationItem.getTaxInfoList().getTaxInfo()));
        }
        if (wsPricingItem.getRemarkList() != null) {
            result.getRemarkList().addAll(HotelsHelper.buildRemarks(wsPricingItem.getRemarkList().getRemark()));
        }
        return result;
    }

    private static List<com.gridnine.xtrip.common.hotels2.model.Remark> buildRemarks(List<Remark> remarkList) {
        if (remarkList == null) {
            return Collections.emptyList();
        }
        ArrayList<com.gridnine.xtrip.common.hotels2.model.Remark> result = new ArrayList<com.gridnine.xtrip.common.hotels2.model.Remark>();
        for (Remark remarkWS : remarkList) {
            com.gridnine.xtrip.common.hotels2.model.Remark remark = new com.gridnine.xtrip.common.hotels2.model.Remark();
            remark.setId(remarkWS.getId());
            remark.setDataType((RemarkDataType)EnumUtil.recodeSafe((Enum)remarkWS.getDataType(), RemarkDataType.class));
            remark.setType((com.gridnine.xtrip.common.hotels2.model.RemarkType)EnumUtil.recodeSafe((Enum)remarkWS.getType(), com.gridnine.xtrip.common.hotels2.model.RemarkType.class));
            remark.setTitle(remarkWS.getTitle());
            result.add(remark);
        }
        return result;
    }

    private static void fillOptions(HotelOptions dst, HotelsOptionList src) {
        if (src != null) {
            CheckInOption option;
            HotelsCheckInOutOptionType type;
            block9: for (HotelsCheckInOutOption opt : src.getCheckInOutOption()) {
                type = opt.getType();
                Objects.requireNonNull(type, "HotelsCheckInOutOptionType type required");
                switch (type) {
                    case CHECK_IN: {
                        option = new CheckInOption();
                        HotelsHelper.fillHotelsServiceOption((HotelsServiceOption)option, (HotelsOption)opt);
                        option.setFrom(HotelsHelper.convertTime(opt.getFrom()));
                        option.setTo(HotelsHelper.convertTime(opt.getTo()));
                        option.setPrice(HotelsBaseHelper.convertMoneyFromGds(opt.getPrice()));
                        option.setVat(BooleanUtils.isTrue((Boolean)VatHelper.isVatIncluded((HotelsOption)opt)));
                        dst.getCheckInOptions().add(option);
                        continue block9;
                    }
                    case CHECK_OUT: {
                        option = new CheckOutOption();
                        HotelsHelper.fillHotelsServiceOption((HotelsServiceOption)option, (HotelsOption)opt);
                        option.setFrom(HotelsHelper.convertTime(opt.getFrom()));
                        option.setTo(HotelsHelper.convertTime(opt.getTo()));
                        option.setPrice(HotelsBaseHelper.convertMoneyFromGds(opt.getPrice()));
                        option.setVat(BooleanUtils.isTrue((Boolean)VatHelper.isVatIncluded((HotelsOption)opt)));
                        dst.getCheckOutOptions().add(option);
                        continue block9;
                    }
                }
                throw new RuntimeException("unexpected HotelsCheckInOutOption type: " + type);
            }
            for (HotelsCheckInOutOption opt : src.getMealplanOption()) {
                MealOption option2 = new MealOption();
                HotelsHelper.fillHotelsServiceOption((HotelsServiceOption)option2, (HotelsOption)opt);
                option2.setBaseMealCaption(opt.getBaseMealName());
                option2.setBaseMealCode(opt.getBaseMealCode());
                option2.setExclusive(opt.isExclusive());
                option2.setMealCaption(opt.getMealName());
                option2.setMealCode(opt.getMealCode());
                option2.setProviderCaption(opt.getProviderName());
                option2.setProviderCode(opt.getProviderCode());
                option2.setPrice(HotelsBaseHelper.convertMoneyFromGds(opt.getPrice()));
                option2.setVat(BooleanUtils.isTrue((Boolean)VatHelper.isVatIncluded((HotelsOption)opt)));
                dst.getMealOptions().add(option2);
            }
            block11: for (HotelsCheckInOutOption opt : src.getExtraBedOption()) {
                type = opt.getType();
                Objects.requireNonNull(type, "HotelsExtraBedOptionType type required");
                switch (1.$SwitchMap$com$gridnine$hotels$web$ws$HotelsExtraBedOptionType[type.ordinal()]) {
                    case 1: {
                        option = new AdultExtraBedOption();
                        HotelsHelper.fillHotelsServiceOption((HotelsServiceOption)option, (HotelsOption)opt);
                        option.setPrice(HotelsBaseHelper.convertMoneyFromGds(opt.getPrice()));
                        option.setVat(BooleanUtils.isTrue((Boolean)VatHelper.isVatIncluded((HotelsOption)opt)));
                        dst.setAdultExtraBedOption((AdultExtraBedOption)option);
                        continue block11;
                    }
                    case 2: {
                        option = new ChildExtraBedOption();
                        HotelsHelper.fillHotelsServiceOption((HotelsServiceOption)option, (HotelsOption)opt);
                        option.setPrice(HotelsBaseHelper.convertMoneyFromGds(opt.getPrice()));
                        option.setVat(BooleanUtils.isTrue((Boolean)VatHelper.isVatIncluded((HotelsOption)opt)));
                        dst.setChildExtraBedOption((ChildExtraBedOption)option);
                        continue block11;
                    }
                    case 3: {
                        option = new InfantExtraBedOption();
                        HotelsHelper.fillHotelsServiceOption((HotelsServiceOption)option, (HotelsOption)opt);
                        option.setPrice(HotelsBaseHelper.convertMoneyFromGds(opt.getPrice()));
                        option.setVat(BooleanUtils.isTrue((Boolean)VatHelper.isVatIncluded((HotelsOption)opt)));
                        dst.setInfantExtraBedOption((InfantExtraBedOption)option);
                        continue block11;
                    }
                }
                throw new RuntimeException("unexpected HotelsExtraBedOptionType type: " + type);
            }
        }
    }

    private static void fillHotelsServiceOption(HotelsServiceOption destination, HotelsOption source) {
        HotelsHelper.fillHotelsServiceOptionAvailability(destination.getAvailability(), source.getAvailability());
        destination.setText(source.getText());
        boolean includedInTarrif = BooleanUtil.nullAsFalse((Boolean)source.isIncludedInTariff());
        destination.setIncludedInTariff(Boolean.valueOf(includedInTarrif));
    }

    private static void fillHotelsServiceOptionAvailability(HotelsServiceOptionAvailability destination, HotelsOptionAvailability source) {
        destination.setEnabled(Boolean.valueOf(BooleanUtil.nullAsFalse((Boolean)source.isEnabled())));
        destination.setGuaranteed(Boolean.valueOf(!BooleanUtil.nullAsFalse((Boolean)source.isNotGuaranteed())));
        destination.setStatus((HotelsServiceOptionStatus)EnumUtil.fromEnum(HotelsServiceOptionStatus.class, (Enum)source.getStatus()));
        destination.setType((HotelsServiceOptionAvailabilityType)EnumUtil.fromEnum(HotelsServiceOptionAvailabilityType.class, (Enum)source.getType()));
    }

    private static AdditionalServiceType getAdditionalServiceType(OfferOptionType x) {
        AdditionalServiceType t = null;
        switch (x) {
            case EARLY_CHECKIN: {
                t = AdditionalServiceType.EARLIER_CHECKIN;
                break;
            }
            case LATE_CHECKOUT: {
                t = AdditionalServiceType.LATER_CHECKOUT;
                break;
            }
            case EXTRA_BED_ADULT: {
                t = AdditionalServiceType.EXTRA_BED_ADULT;
                break;
            }
            case EXTRA_BED_CHILDREN: {
                t = AdditionalServiceType.EXTRA_BED_CHILD;
                break;
            }
            case EXTRA_BED_INFANTS: {
                t = AdditionalServiceType.EXTRA_BED_INFANT;
                break;
            }
            case EXTRA_MEAL: {
                t = AdditionalServiceType.MEAL;
                break;
            }
        }
        return t;
    }

    private static boolean contains(PricingItem resItemWs, OfferOptionType type) {
        boolean result = false;
        OfferOptionSet offerOptionSet = resItemWs.getOfferOptionSet();
        if (offerOptionSet != null && offerOptionSet.getOptions() != null) {
            for (OfferOption x : offerOptionSet.getOptions().getOptions()) {
                if (x.getType() != type) continue;
                result = true;
                break;
            }
        }
        return result;
    }

    private static MealPlan getMealIncluded(HotelsOptionList optionList) {
        MealPlan mealIncluded = null;
        if (optionList != null) {
            for (HotelsMealplanOption option : optionList.getMealplanOption()) {
                if (option == null) continue;
                if (option.getAvailability() == null) {
                    throw Xeption.forDeveloper((String)"Missing OptionAvailability", (Object[])new Object[0]);
                }
                if (option.getAvailability().getType() == null) {
                    throw Xeption.forDeveloper((String)"Missing OptionAvailability type", (Object[])new Object[0]);
                }
                if (option.getAvailability().getType() != HotelsOptionAvailabilityType.INCLUDED) continue;
                mealIncluded = new MealPlan();
                mealIncluded.setCode(option.getProviderCode());
                mealIncluded.setCaption(option.getProviderName());
                mealIncluded.setBasemealId(option.getBaseMealCode());
                mealIncluded.setBasemealCaption(option.getBaseMealName());
                mealIncluded.setMealType(option.getMealCode());
                mealIncluded.setMealTypeCaption(option.getMealName());
            }
        }
        return mealIncluded;
    }

    private static HotelProductCommission getHotelCommission(Commission wsCommission, Money basePrice) {
        if (wsCommission == null) {
            return null;
        }
        Money commissionAmount = HotelsBaseHelper.convertMoneyFromGds(wsCommission.getAmount());
        if (commissionAmount != null) {
            return HotelsHelper.getCommissionFromFixedAmount(commissionAmount, wsCommission.getPercentage());
        }
        if (wsCommission.getPercentage() != null) {
            return HotelsHelper.getCommissionFromPercentage(basePrice, wsCommission.getPercentage());
        }
        return null;
    }

    private static HotelProductCommission getCommissionFromFixedAmount(Money fixedAmount, BigDecimal percentage) {
        if (MoneyHelper.isNullMoney((Money)fixedAmount)) {
            return null;
        }
        HotelProductCommission hotelCommission = new HotelProductCommission();
        hotelCommission.setAmount(fixedAmount);
        hotelCommission.setEquivalentAmount(fixedAmount.getValue().setScale(2, RoundingMode.HALF_UP));
        if (percentage != null) {
            hotelCommission.setPercentage(percentage);
        }
        return hotelCommission;
    }

    private static HotelProductCommission getCommissionFromPercentage(Money basePrice, BigDecimal percentage) {
        if (percentage == null || MoneyHelper.isNullMoney((Money)basePrice)) {
            return null;
        }
        HotelProductCommission hotelCommission = new HotelProductCommission();
        BigDecimal rate = percentage.divide(BigDecimal.valueOf(100L));
        Money amount = MoneyHelper.buildMoney((BigDecimal)basePrice.getValue().multiply(rate), (String)basePrice.getCurrency());
        hotelCommission.setAmount(amount);
        hotelCommission.setPercentage(percentage);
        hotelCommission.setEquivalentAmount(amount.getValue().setScale(2, RoundingMode.HALF_UP));
        return hotelCommission;
    }

    public static GeneralProductCommission toHotelGeneralProductCommission(HotelProductCommission hotelCommission) {
        if (hotelCommission == null) {
            return null;
        }
        GeneralProductCommission productComm = new GeneralProductCommission();
        productComm.setCommissionProperties(HotelProductHelper.getVendorCommissionProperties().toReference());
        productComm.setContractType(ContractType.VENDOR);
        productComm.setAmount(hotelCommission.getAmount());
        BigDecimal percentage = hotelCommission.getPercentage();
        if (percentage != null) {
            productComm.setRate(Double.valueOf(percentage.doubleValue()));
            productComm.setPercentage(Double.valueOf(percentage.doubleValue()));
        }
        productComm.setEquivalentAmount(hotelCommission.getEquivalentAmount());
        return productComm;
    }

    private static void processProviderVatInfo(ProviderVatInfo providerVatInfo, com.gridnine.hotels.web.ws.HotelOffer wsOffer) {
        BigDecimal totalPrice = CollectionUtil.isNotEmpty((Collection)wsOffer.getBreakdown()) ? wsOffer.getBreakdown().stream().map(com.gridnine.hotels.web.ws.Money::getAmount).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add) : wsOffer.getBasePrice().getAmount();
        providerVatInfo.setAmount(VatHelper.getVatAmount(totalPrice, wsOffer.getVatComponent(), wsOffer.getVatAmount()));
        providerVatInfo.setRate(VatHelper.getVatRate(totalPrice, wsOffer.getVatComponent(), wsOffer.getVatAmount()));
        providerVatInfo.setIncluded(VatHelper.isVatIncluded(wsOffer));
    }

    private static void processProviderVatInfo(ProviderVatInfo providerVatInfo, PricingItem pricingItem) {
        BigDecimal totalPrice = pricingItem.getPrice() != null && CollectionUtil.isNotEmpty((Collection)pricingItem.getPrice().getBreakdown()) ? pricingItem.getPrice().getBreakdown().stream().map(HotelsMoney::getAmount).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add) : pricingItem.getTotalPrice().getAmount();
        providerVatInfo.setAmount(VatHelper.getVatAmount(totalPrice, pricingItem.getVatComponent(), pricingItem.getVatAmount()));
        providerVatInfo.setRate(VatHelper.getVatRate(totalPrice, pricingItem.getVatComponent(), pricingItem.getVatAmount()));
        providerVatInfo.setIncluded(VatHelper.isVatIncluded((PricedItem)pricingItem));
    }

    private static com.gridnine.xtrip.common.hotels2.model.HotelsStayPolicy convertHotelsStayPolicyFromGds(HotelsStayPolicy wsPolicy, com.gridnine.xtrip.common.hotels2.model.HotelsStayPolicy originalPolicy) {
        com.gridnine.xtrip.common.hotels2.model.HotelsStayPolicy policy = new com.gridnine.xtrip.common.hotels2.model.HotelsStayPolicy();
        if (wsPolicy.getCheckIn() != null) {
            policy.setCheckInDate(HotelsBaseHelper.toLocalDate(wsPolicy.getCheckIn().getDate()));
            if (wsPolicy.getCheckIn().getTime() != null) {
                policy.setCheckInTime(HotelsBaseHelper.toLocalTime(wsPolicy.getCheckIn().getTime()));
            }
        }
        if (wsPolicy.getCheckOut() != null) {
            policy.setCheckOutDate(HotelsBaseHelper.toLocalDate(wsPolicy.getCheckOut().getDate()));
            if (wsPolicy.getCheckOut().getTime() != null) {
                policy.setCheckOutTime(HotelsHelper.convertTime(wsPolicy.getCheckOut().getTime()));
            }
        }
        if (originalPolicy != null) {
            policy.setStandardCheckInTime(originalPolicy.getStandardCheckInTime());
            policy.setStandardCheckOutTime(originalPolicy.getStandardCheckOutTime());
        }
        if (policy.getStandardCheckInTime() == null) {
            policy.setStandardCheckInTime(HotelsHelper.convertTime(wsPolicy.getDefaultCheckIn()));
        }
        if (policy.getStandardCheckOutTime() == null) {
            policy.setStandardCheckOutTime(HotelsHelper.convertTime(wsPolicy.getDefaultCheckOut()));
        }
        if (wsPolicy.getDuration() != null) {
            policy.setDurationLength(wsPolicy.getDuration().getLength());
            policy.setDurationUnit((HotelsTimeUnit)EnumUtil.fromEnum(HotelsTimeUnit.class, (Enum)wsPolicy.getDuration().getUnit()));
        }
        policy.setType((HotelsStayType)EnumUtil.fromEnum(HotelsStayType.class, (Enum)wsPolicy.getType()));
        return policy;
    }

    private static com.gridnine.xtrip.common.model.booking.xtriphotels.RateType getRateType(CancellationPolicy policy, RateType wsRateType) {
        return null;
    }

    private static HotelsServiceAvailability convertAvailabilityFromGds(com.gridnine.hotels.web.ws.HotelsServiceAvailability wsAvailability) {
        if (wsAvailability == null) {
            throw Xeption.forDeveloper((String)"Missing Availability", (Object[])new Object[0]);
        }
        if (wsAvailability.getPayee() == null) {
            throw Xeption.forDeveloper((String)"Missing Payee", (Object[])new Object[0]);
        }
        HotelsServiceAvailability result = new HotelsServiceAvailability();
        result.setImmediateConfirmation(wsAvailability.isImmediateConfirmation());
        result.setPayee(HotelsBaseHelper.convertHotelsPayeeFromGds(wsAvailability.getPayee()));
        return result;
    }

    private static String convertMealPlanFromGds() {
        MealPlan mealPlan = new MealPlan();
        return null;
    }

    private static String getTopmostRoomName(com.gridnine.hotels.web.ws.HotelOffer wsOffer) {
        return HotelsHelper.getTopmostRoomName(wsOffer.getRoom(), wsOffer.getRoomName(), wsOffer.isIsBlockRoom());
    }

    private static String getTopmostRoomName(PricingItem wsPricingItem) {
        return HotelsHelper.getTopmostRoomName(wsPricingItem.getRoom(), wsPricingItem.getRoomName(), wsPricingItem.isIsBlockRoom());
    }

    private static String getTopmostRoomName(HotelsRoom room, String roomName, Boolean blockRoom) {
        String result = room == null ? roomName : TextUtil.firstNonBlank((String[])new String[]{room.getBaseRoomName(), room.getRoomName(), room.getProviderName()});
        if (Boolean.TRUE == blockRoom) {
            result = result + " (\u0431\u043b\u043e\u0447\u043d\u044b\u0439 \u043d\u043e\u043c\u0435\u0440 - \u043e\u0431\u0449\u0438\u0435 \u0443\u0434\u043e\u0431\u0441\u0442\u0432\u0430)";
        }
        return result;
    }

    public static HotelSummary convertHotelSummary(HotelInfo hotelInfo) {
        HotelSummary result = new HotelSummary();
        result.setNumber(StringUtils.trim((String)hotelInfo.getNumber()));
        result.setName(StringUtils.trim((String)hotelInfo.getName()));
        result.setHotelStars(Integer.valueOf(hotelInfo.getStars()));
        result.setAddress(HotelsHelper.convertAddress(hotelInfo.getLocation(), hotelInfo.getAddress()));
        if (hotelInfo.getContacts() != null) {
            HotelsHelper.fillContacts(result.getContacts(), hotelInfo.getContacts().getContact());
        }
        if (hotelInfo.getLocation() != null) {
            result.setLatitude(Double.valueOf(hotelInfo.getLocation().getLatitude()));
            result.setLongitude(Double.valueOf(hotelInfo.getLocation().getLongitude()));
        }
        return result;
    }

    private static void fillStringList(List<String> result, List<String> wsList) {
        if (CollectionUtil.isEmpty(wsList)) {
            return;
        }
        wsList.stream().filter(TextUtil::nonBlank).forEach(result::add);
    }

    public static void fillContacts(List<Communication> result, List<Contact> wsContacts) {
        if (CollectionUtil.isEmpty(wsContacts)) {
            return;
        }
        wsContacts.stream().filter(Objects::nonNull).map(HotelsHelper::convertContact).forEach(result::add);
    }

    private static void fillRooms(List<RoomCard> result, List<com.gridnine.hotels.web.ws.RoomCard> wsRooms) {
        if (CollectionUtil.isEmpty(wsRooms)) {
            return;
        }
        wsRooms.stream().filter(Objects::nonNull).map(HotelsHelper::convertRoomCard).forEach(result::add);
    }

    private static void fillFacilities(List<com.gridnine.xtrip.common.hotels2.model.Facility> result, List<Facility> wsFacilities) {
        if (CollectionUtil.isEmpty(wsFacilities)) {
            return;
        }
        wsFacilities.stream().filter(Objects::nonNull).map(HotelsHelper::convertFacility).forEach(result::add);
    }

    private static void fillDocumentRefs(List<com.gridnine.xtrip.common.hotels2.model.DocumentReference> result, List<DocumentReference> wsDocumentRefs) {
        if (CollectionUtil.isEmpty(wsDocumentRefs)) {
            return;
        }
        wsDocumentRefs.stream().filter(Objects::nonNull).map(HotelsHelper::convertDocumentRef).forEach(result::add);
    }

    private static void fillVendorCodes(Map<HotelProvider, String> result, HotelCard.ProviderCodes wsProviderCodes) {
        if (wsProviderCodes == null || CollectionUtil.isEmpty((Collection)wsProviderCodes.getEntry())) {
            return;
        }
        wsProviderCodes.getEntry().forEach(entry -> HotelsHelper.putVendorCode(result, entry));
    }

    private static void putVendorCode(Map<HotelProvider, String> result, HotelsProviderCodeEntry wsEntry) {
        if (TextUtil.isBlank((String)wsEntry.getCode())) {
            return;
        }
        HotelProvider provider = HotelsBaseHelper.convertProviderFromGds(wsEntry.getProvider());
        if (provider == null) {
            return;
        }
        result.put(provider, wsEntry.getCode());
    }

    private static Address convertToAddress(com.gridnine.hotels.web.ws.Address wsAddress, GeoLocation wsCity) {
        if (wsAddress == null) {
            return null;
        }
        Address result = HotelsHelper.convertToAddress(wsAddress.getLocation());
        if (result.getCity() == null && wsCity != null) {
            result.setCity(HotelsBaseHelper.resolveCity(wsCity.getCode()));
        }
        HotelsHelper.putStringToL10n(result.getAddress(), wsAddress.getAddress());
        result.setZip(wsAddress.getPostCode());
        return result;
    }

    public static Address convertToAddress(GeoLocation wsLocation) {
        Address result = new Address();
        result.setAddressType(AddressType.FACTUAL);
        if (wsLocation != null) {
            if (wsLocation.getType() == GeoLocationType.CITY) {
                result.setCity(HotelsBaseHelper.resolveCity(wsLocation.getCode()));
            }
            if (wsLocation.getCountry() != null) {
                result.setCountry(HotelsBaseHelper.resolveNativeCode(Country.class, wsLocation.getCountry().getCode()));
            }
        }
        return result;
    }

    private static void putStringToL10n(L10nString result, String str) {
        if (TextUtil.isBlank((String)str)) {
            return;
        }
        Locale locale = TextUtil.isCyrillic((String)str, (boolean)true) ? LocaleHelper.RU_LOCALE : LocaleHelper.EN_LOCALE;
        L10nStringHelper.setValue((L10nString)result, (String)str, (Locale)locale);
    }

    private static Communication convertContact(Contact wsContact) {
        if (wsContact == null) {
            return null;
        }
        Communication result = new Communication();
        result.setType(HotelsBaseHelper.convertContactTypefromGds(wsContact.getType()));
        result.setSense(wsContact.getValue());
        return result;
    }

    private static RoomCard convertRoomCard(com.gridnine.hotels.web.ws.RoomCard wsRoomCard) {
        if (wsRoomCard == null) {
            return null;
        }
        RoomCard result = new RoomCard();
        result.setProviderId(wsRoomCard.getProviderIdRoom());
        result.setName(wsRoomCard.getName());
        result.setDescription(wsRoomCard.getDescription());
        result.setRoomSize(EnumUtil.nameOf((Enum)wsRoomCard.getRoomSize()));
        result.setRoomsCount(Integer.valueOf(wsRoomCard.getRoomsCount()));
        if (wsRoomCard.getAmenities() != null) {
            result.getAmenities().addAll(wsRoomCard.getAmenities().getAmenity());
        }
        if (wsRoomCard.getDocuments() != null) {
            HotelsHelper.fillDocumentRefs(result.getDocuments(), wsRoomCard.getDocuments().getDocument());
        }
        return result;
    }

    private static com.gridnine.xtrip.common.hotels2.model.Facility convertFacility(Facility wsFacility) {
        if (wsFacility == null) {
            return null;
        }
        com.gridnine.xtrip.common.hotels2.model.Facility result = new com.gridnine.xtrip.common.hotels2.model.Facility();
        result.setCaption(wsFacility.getCaption());
        result.setCode(wsFacility.getCode());
        result.setCategory((ServiceType)EnumUtil.recodeSafe((Enum)wsFacility.getType(), ServiceType.class));
        return result;
    }

    private static com.gridnine.xtrip.common.hotels2.model.DocumentReference convertDocumentRef(DocumentReference wsDocRef) {
        if (wsDocRef == null) {
            return null;
        }
        com.gridnine.xtrip.common.hotels2.model.DocumentReference result = new com.gridnine.xtrip.common.hotels2.model.DocumentReference();
        result.setGdsId(wsDocRef.getUid());
        result.setCategory((DocumentCategory)EnumUtil.recodeSafe((Enum)wsDocRef.getCategory(), DocumentCategory.class));
        result.setLegalNote(wsDocRef.getLegalNote());
        result.setMimeType(wsDocRef.getMimeType());
        result.setTitle(wsDocRef.getTitle());
        result.setProvider(HotelsBaseHelper.convertProviderFromGds(wsDocRef.getProvider()));
        if (result.getCategory() == null && result.getMimeType().startsWith("image")) {
            result.setCategory(DocumentCategory.IMAGE);
        }
        return result;
    }

    public static Hotel convertToHotel(HotelSummary hotelSummary) {
        if (hotelSummary == null) {
            return null;
        }
        Hotel result = new Hotel();
        HotelsHelper.fillHotelSummaryInfo(result, hotelSummary);
        return result;
    }

    private static void fillHotelSummaryInfo(Hotel result, HotelSummary hotelSummary) {
        result.setCode(hotelSummary.getNumber());
        result.setName(hotelSummary.getName());
        Address address = hotelSummary.getAddress();
        if (address != null) {
            result.setCity(address.getCity());
            result.setCountry(address.getCountry());
            L10nStringHelper.copy((L10nString)address.getAddress(), (L10nString)result.getAddress());
            result.setZip(address.getZip());
        }
        result.setPhone(HotelsHelper.getPhone(hotelSummary.getContacts()));
        result.setFax(HotelsHelper.getFax(hotelSummary.getContacts()));
        result.setStars(hotelSummary.getHotelStars());
    }

    public static Hotel convertToHotel(HotelCard card) {
        if (card == null) {
            return null;
        }
        Hotel result = new Hotel();
        HotelsHelper.fillHotelSummaryInfo(result, (HotelSummary)card);
        String sabreCode = (String)card.getVendorCodes().get(HotelProvider.SABRE);
        if (TextUtil.nonBlank((String)sabreCode)) {
            try {
                result.setSabreHotelPropertyNumber(Integer.valueOf(Integer.parseInt(sabreCode)));
            }
            catch (NumberFormatException e) {
                IncidentsLog.reportException((String)String.format("unable to convert sabre hotel code %s to integer", sabreCode), (Throwable)e);
            }
        }
        result.setLatitude(HotelsHelper.toBigDecimal(card.getLatitude()));
        result.setLongitude(HotelsHelper.toBigDecimal(card.getLongitude()));
        result.setChkIn(HotelsHelper.toDate(card.getCheckInTime()));
        result.setChkOut(HotelsHelper.toDate(card.getCheckOutTime()));
        ProviderInfo providerInfo = (ProviderInfo)card.getProviderInfo().get(card.getProvider());
        if (providerInfo != null) {
            result.setRoomsNumber(Integer.valueOf(providerInfo.getRooms().size()));
        }
        HotelsHelper.putStringToL10n(result.getDescription(), card.getDescription());
        return result;
    }

    public static com.gridnine.hotels.web.ws.RoomInfo convertRoomInfoToGds(RoomInfo roomInfo) {
        if (roomInfo == null) {
            return null;
        }
        com.gridnine.hotels.web.ws.RoomInfo wsRoomInfo = new com.gridnine.hotels.web.ws.RoomInfo();
        for (Traveller traveller : roomInfo.getTravellers()) {
            if (wsRoomInfo.getGuests() == null) {
                wsRoomInfo.setGuests(new RoomInfo.Guests());
            }
            wsRoomInfo.getGuests().getGuest().add(HotelsReservationHelper.buildGuest(traveller));
        }
        wsRoomInfo.setStandardNumberOfGuests(roomInfo.getStandardNumberOfGuests());
        return wsRoomInfo;
    }

    private static RoomInfo convertRoomInfoFromGds(com.gridnine.hotels.web.ws.RoomInfo wsRoomInfo) {
        if (wsRoomInfo == null || wsRoomInfo.getGuests() == null) {
            return null;
        }
        RoomInfo roomInfo = new RoomInfo();
        wsRoomInfo.getGuests().getGuest().stream().map(HotelsReservationHelper::buildTraveller).forEach(guest -> roomInfo.getTravellers().add(guest));
        roomInfo.setStandardNumberOfGuests(wsRoomInfo.getStandardNumberOfGuests());
        return roomInfo;
    }

    private static RoomInfo convertRoomInfoFromGds(PricingItem wsPricingItem) {
        if (wsPricingItem == null || wsPricingItem.getGuests() == null) {
            return null;
        }
        RoomInfo roomInfo = new RoomInfo();
        wsPricingItem.getGuests().getGuest().stream().map(HotelsReservationHelper::buildTraveller).forEach(guest -> roomInfo.getTravellers().add(guest));
        roomInfo.setStandardNumberOfGuests(wsPricingItem.getGuests().getGuest().size());
        return roomInfo;
    }

    public static String getFax(List<Communication> contacts) {
        return HotelsHelper.getCommunicationsSense(contacts, EnumSet.of(CommunicationType.FAX));
    }

    public static String getEmail(List<Communication> contacts) {
        return HotelsHelper.getCommunicationsSense(contacts, EnumSet.of(CommunicationType.EMAIL));
    }

    public static String getPhone(List<Communication> contacts) {
        return HotelsHelper.getCommunicationsSense(contacts, EnumSet.of(CommunicationType.HOME_PHONE, CommunicationType.WORK_PHONE, CommunicationType.MOBILE, CommunicationType.CELL));
    }

    private static String getCommunicationsSense(List<Communication> contacts, Set<CommunicationType> communicationTypes) {
        return ProfileHelper.filterCommunications(contacts, communicationTypes).stream().map(Communication::getSense).filter(TextUtil::nonBlank).findFirst().orElse(null);
    }

    private static BigDecimal toBigDecimal(Double value) {
        if (value == null) {
            return null;
        }
        return BigDecimal.valueOf(value);
    }

    private static Date toDate(LocalTime time) {
        if (time == null) {
            return null;
        }
        GregorianCalendar cal = new GregorianCalendar();
        cal.set(11, time.getHour());
        cal.set(12, time.getMinute());
        cal.set(13, 0);
        return cal.getTime();
    }

    public static Reservation buildProposalReservation(EntityReference<HotelsAggregatorGdsAccount> gdsAccountRef, SalesContext salesContext, HotelCard hotelCard, List<HotelOffer> offers, Consumer<Message> messages) {
        Reservation result = new Reservation();
        result.getGdsNameInfo().setOnlineGdsAccount(gdsAccountRef);
        ReservationGdsNameInfoHelper.setRulesGdsNameFromAccount((Reservation)result, gdsAccountRef);
        SalesContextHandler.get().enforceSalesContext(salesContext, result);
        result.setResDate(new Date());
        for (HotelOffer offer : offers) {
            HotelProduct hp = HotelsHelper.buildProposalHotelProduct(hotelCard, offer, salesContext, messages);
            hp.setReservation(result);
            result.getProducts().add(hp);
        }
        result.setProposal(true);
        return result;
    }

    public static Reservation buildReservation(EntityReference<HotelsAggregatorGdsAccount> gdsAccountRef, SalesContext salesContext, ReservationResult reservationResult, List<PricingItem> pricingItemList, List<HotelOffer> originalOffers, Consumer<Message> messages, Consumers.CheckedBiConsumer<Enum<?>, Object> putInContext) throws Exception {
        Reservation result = new Reservation();
        result.getGdsNameInfo().setOnlineGdsAccount(gdsAccountRef);
        SalesContextHandler.get().enforceSalesContext(salesContext, result);
        HotelsHelper.updateReservation(result, reservationResult);
        for (ReservationItem item : reservationResult.getReservationItems().getReservationItems()) {
            String requestItemId = item.getRequestItemId();
            HotelOffer originalOffer = originalOffers != null ? originalOffers.get(Integer.parseInt(requestItemId)) : null;
            PricingItem pricingItem = pricingItemList != null ? (PricingItem)pricingItemList.stream().filter(pl -> Objects.equals(requestItemId, pl.getRequestItemId())).findFirst().orElse(null) : null;
            HotelProduct hp = HotelsHelper.buildHotelProduct(item, reservationResult, pricingItem, originalOffer, salesContext, messages);
            hp.setReservation(result);
            result.getProducts().add(hp);
            HotelsHelper.updateProductSystemNumber(hp);
            RuleProxy ruleProxy = HotelRulesHelper.applyHotelProductSettingsRules((HotelProduct)hp);
            HotelsHelper.fillContractData(hp, (HotelProductSettingsActionSet)ruleProxy.getActionSet());
            if (hp.getStatus() == ProductStatus.REFUND) {
                HotelProduct sale = new HotelProduct();
                try {
                    HotelProductHelper.copy((HotelProduct)hp, (HotelProduct)sale, (boolean)false);
                }
                catch (Exception e) {
                    throw Xeption.forDeveloper((String)"failed copy hotel product", (Throwable)e, (Object[])new Object[0]);
                }
                sale.setStatus(ProductStatus.SELL);
                sale.setForcedRefund(false);
                sale.getPenalties().clear();
                sale.setNextProduct(hp);
                hp.setPreviousProduct(sale);
                HotelProductVatFiller.updateVat((HotelProduct)sale);
                HotelProductHelper.updateFops((HotelProduct)sale);
                result.getProducts().add(0, sale);
            }
            if (ProductStatus.SELL == hp.getStatus() && BooleanUtils.isTrue((Boolean)item.isFareWithPenalty())) {
                ((Room)hp.getRooms().get(0)).setSellWithPenalty(true);
            }
            if (ProductStatus.SELL == hp.getStatus() && !hp.getPenalties().isEmpty()) {
                result.setStatus(ReservationStatus.ERROR);
                Message wrongStatusMessage = MessagesHelper.createMessage((MessageType)MessageType.ERROR, (String)"\u0414\u043b\u044f \u043f\u0440\u043e\u0434\u0443\u043a\u0442\u0430 \u2116 {0} \u043f\u043e\u043b\u0443\u0447\u0435\u043d \u0441\u0442\u0430\u0442\u0443\u0441: {1}\n\u041f\u0440\u043e\u0434\u0443\u043a\u0442 \u0441 \u0434\u0430\u043d\u043d\u044b\u043c \u0441\u0442\u0430\u0442\u0443\u0441\u043e\u043c \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0438\u043c\u0435\u0442\u044c \u0448\u0442\u0440\u0430\u0444\u043e\u0432.\n\u041e\u0431\u0440\u0430\u0442\u0438\u0442\u0435\u0441\u044c \u043a \u043f\u043e\u0441\u0442\u0430\u0432\u0449\u0438\u043a\u0443 \u0434\u043b\u044f \u0443\u0442\u043e\u0447\u043d\u0435\u043d\u0438\u044f \u0438\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u0438.", (Object[])new Object[]{hp.getSystemNumber(), hp.getStatus()});
                messages.accept(wrongStatusMessage);
            }
            if (originalOffer == null) continue;
            result.getReservationRemarks().addAll(originalOffer.getRemarkList().stream().filter(remark -> remark.getValue() != null).map(remark -> {
                ReservationRemark reservationRemark = new ReservationRemark();
                reservationRemark.setQualifier(remark.getId());
                reservationRemark.setRemarkText(remark.getValue());
                return reservationRemark;
            }).collect(Collectors.toList()));
            if (originalOffer.getAvailability() == null || !BooleanUtils.isTrue((Boolean)originalOffer.getAvailability().getImmediateConfirmation()) || item.getAvailability() == null || !BooleanUtils.isFalse((Boolean)item.getAvailability().isImmediateConfirmation())) continue;
            putInContext.accept((Object)IBusHotelsContextKeys.CONFIRMATION_MODE_CHANGED, (Object)true);
        }
        return result;
    }

    public static void fillContractData(HotelProduct hotelProduct, HotelProductSettingsActionSet hotelProductSettingsActionSet) {
        HotelProductContractRelationData vendorContractRelation = HotelProductHelper.getVendorContractRelation((HotelProduct)hotelProduct);
        if (vendorContractRelation != null) {
            vendorContractRelation.getGeneralData().getContractData().setManualContract(hotelProductSettingsActionSet.getVendorContract());
        }
        if (hotelProductSettingsActionSet.getSupplier() != null) {
            HotelProductHelper.setSupplier((HotelProduct)hotelProduct, (EntityReference)hotelProductSettingsActionSet.getSupplier());
        }
        if (hotelProductSettingsActionSet.getBlankOwner() != null) {
            hotelProduct.setBlankOwnerRef(hotelProductSettingsActionSet.getBlankOwner());
        }
    }

    public static void updateReservation(Reservation reservation, ReservationResult reservationResult) {
        reservation.setResDate((Date)MiscUtil.guarded((Object)HotelsBaseHelper.toDate(reservationResult.getCreatedAt()), Date::new));
        ReservationID resId = reservationResult.getReservationId();
        if (resId != null) {
            reservation.getGdsNameInfo().getSystemInfos().clear();
            CommonReservationGdsNameInfoHelper.setRecordLocator((Reservation)reservation, (GdsName)GdsName.HOTEL_AGGREGATOR, (RecordLocatorType)RecordLocatorType.HOTEL_AGGREGATOR_PNR, (String)resId.getPnr());
            if (TextUtil.nonBlank((String)resId.getReservationNumber())) {
                CommonReservationGdsNameInfoHelper.setRecordLocator((Reservation)reservation, (GdsName)GdsName.HOTEL_AGGREGATOR, (RecordLocatorType)RecordLocatorType.HOTEL_AGGREGATOR_RESERVATION_NUMBER, (String)resId.getReservationNumber());
            }
            if (TextUtil.nonBlank((String)resId.getPnr())) {
                HotelProvider hotelProvider = HotelsBaseHelper.convertProviderFromGds(reservationResult.getProvider());
                GdsName providerGdsName = HotelsHelper.hotelProviderToGdsName(hotelProvider);
                if (providerGdsName == GdsName.OSTROVOK) {
                    CommonReservationGdsNameInfoHelper.setRecordLocator((Reservation)reservation, (GdsName)providerGdsName, (RecordLocatorType)RecordLocatorType.OSTROVOK_ORDER_ID, (String)resId.getPnr());
                    CommonReservationGdsNameInfoHelper.setRecordLocator((Reservation)reservation, (GdsName)providerGdsName, (RecordLocatorType)RecordLocatorType.OSTROVOK_PARTNER_ORDER_ID, (String)resId.getReservationNumber());
                } else if (providerGdsName != null) {
                    CommonReservationGdsNameInfoHelper.setRecordLocator((Reservation)reservation, (GdsName)providerGdsName, (RecordLocatorType)RecordLocatorType.DEFAULT, (String)resId.getPnr());
                }
            }
            CommonReservationGdsNameInfoHelper.setBookingPcc((Reservation)reservation, (GdsName)GdsName.HOTEL_AGGREGATOR, (String)resId.getPcc());
            reservation.setToken(resId.getReservationToken());
        }
    }

    private static GdsName hotelProviderToGdsName(HotelProvider provider) {
        if (provider == null) {
            return null;
        }
        if (provider == HotelProvider.INTERNAL) {
            return GdsName.IBE;
        }
        return (GdsName)EnumUtil.fromNameSafe(GdsName.class, (String)provider.name(), (boolean)true);
    }

    public static ReservationID buildReservationID(Reservation reservation, Boolean discover) {
        ReservationID reservationId = new ReservationID();
        if (HotelsHelper.isHotelAggregatorLocatorsExists(reservation)) {
            reservationId.setPnr(ReservationGdsNameInfoHelper.getOnlineRecordLocator((Reservation)reservation, (RecordLocatorType)RecordLocatorType.HOTEL_AGGREGATOR_PNR));
            reservationId.setReservationNumber(ReservationGdsNameInfoHelper.getOnlineRecordLocator((Reservation)reservation, (RecordLocatorType)RecordLocatorType.HOTEL_AGGREGATOR_RESERVATION_NUMBER));
        } else {
            HotelProduct firstProduct = HotelsReservationHelper.getFirstProduct(reservation);
            GdsName providerGdsName = HotelsReservationHelper.getGdsNameFromProvider(firstProduct.getProvider());
            if (providerGdsName == GdsName.OSTROVOK) {
                reservationId.setPnr(CommonReservationGdsNameInfoHelper.getRecordLocator((Reservation)reservation, (GdsName)providerGdsName, (RecordLocatorType)RecordLocatorType.OSTROVOK_ORDER_ID));
                reservationId.setReservationNumber(CommonReservationGdsNameInfoHelper.getRecordLocator((Reservation)reservation, (GdsName)providerGdsName, (RecordLocatorType)RecordLocatorType.OSTROVOK_PARTNER_ORDER_ID));
            } else if (providerGdsName != null) {
                reservationId.setPnr(CommonReservationGdsNameInfoHelper.getRecordLocator((Reservation)reservation, (GdsName)providerGdsName, (RecordLocatorType)RecordLocatorType.DEFAULT));
            }
        }
        if (TextUtil.isBlank((String)reservationId.getPnr()) && TextUtil.isBlank((String)reservationId.getReservationNumber())) {
            return null;
        }
        reservationId.setReservationToken(reservation.getToken());
        reservationId.setDiscover(discover);
        return reservationId;
    }

    private static boolean isHotelAggregatorLocatorsExists(Reservation reservation) {
        return TextUtil.nonBlank((String)ReservationGdsNameInfoHelper.getOnlineRecordLocator((Reservation)reservation, (RecordLocatorType)RecordLocatorType.HOTEL_AGGREGATOR_PNR)) || TextUtil.nonBlank((String)ReservationGdsNameInfoHelper.getOnlineRecordLocator((Reservation)reservation, (RecordLocatorType)RecordLocatorType.HOTEL_AGGREGATOR_RESERVATION_NUMBER));
    }

    private static HotelProduct buildProposalHotelProduct(HotelCard hotelCard, HotelOffer offer, SalesContext salesContext, Consumer<Message> messages) {
        Money totalPrice;
        HotelProduct hp = HotelsHelper.createHotelProduct(salesContext);
        Date issueDate = new Date();
        hp.setIssueDate(issueDate);
        HotelProductHelper.setOnHold((HotelProduct)hp, (boolean)true);
        HotelProvider provider = offer.getProvider();
        DictionaryReference subProvider = offer.getSubProvider();
        hp.setProvider(provider);
        hp.setSubProvider(subProvider);
        hp.setGdsSubProvider(offer.getVendor());
        hp.setBlankOwnerCode(offer.getBlankOwnerCode());
        if (provider == HotelProvider.INTERNAL) {
            EntityContainer contractCtr = EntityStorage.get().resolve(offer.getContract());
            hp.setVendorContract(contractCtr.toReference());
            Contract contract = (Contract)contractCtr.getEntity();
            EntityReference supplier = contract.getSupplier();
            HotelProductHelper.setSupplier((HotelProduct)hp, (EntityReference)supplier);
            hp.setBlankOwnerRef(supplier);
        } else {
            HotelProductHelper.setSupplier((HotelProduct)hp, (EntityReference)HotelProductHelper.getSupplierFor((HotelProvider)provider, (DictionaryReference)subProvider));
            hp.setBlankOwnerRef(HotelProductHelper.getBlankOwnerFor((String)hp.getBlankOwnerCode(), (DictionaryReference)subProvider));
        }
        String gdsCurrency = HotelsHelper.getCurrency(offer);
        hp.setGdsCurrency(gdsCurrency);
        hp.setHotelByRequest(!offer.isFreeForSale());
        hp.setCancellationPolicyCostsMayChange(Boolean.valueOf(offer.isCancellationPolicyCostsMayChange()));
        hp.setTicketType(HotelsHelper.getTicketType(offer.getAvailability()));
        hp.setGuaranteeType(HotelsHelper.getGuaranteeType(offer.getAvailability()));
        hp.setRoomCount(offer.getRoomsNumber());
        hp.setCommentAllowed(offer.isCommentAllowed());
        hp.setTripartiteAgreement(offer.isTripartiteContract());
        hp.setClientTariffCode(offer.getClientTariffCode());
        HotelsHelper.addEssentialInfo(offer.getEssentialInfoList(), hp.getEssentialInfoData());
        Boolean vatIncluded = offer.getProviderVatInfo().getIncluded();
        if (CollectionUtil.isNotEmpty((Collection)offer.getBreakdowns())) {
            BigDecimal amount = offer.getBreakdowns().stream().map(Money::getValue).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
            String currency = offer.getBreakdowns().stream().map(Money::getCurrency).findFirst().orElse(null);
            totalPrice = MoneyHelper.buildMoney((BigDecimal)amount, (String)currency);
        } else {
            totalPrice = offer.getBasePrice();
        }
        hp.setHotelPropertyId(hotelCard.getNumber() != null ? hotelCard.getNumber() : offer.getHotelCardNumber());
        hp.setProviderHotelCode(offer.getProviderHotelCode());
        hp.setHotelName(hotelCard.getName());
        hp.setHotelType(hotelCard.getHotelType());
        hp.setHotelStars(hotelCard.getHotelStars());
        hp.setDescription(TextUtil.trim((String)hotelCard.getDescription()));
        hp.setHotelResolved(hotelCard.getHotelResolved());
        Address address = hotelCard.getAddress();
        if (address != null) {
            hp.setHotelLocation(address.getCity());
            hp.setHotelCountry(address.getCountry());
            hp.setHotelAddress(address.getAddress().toString());
        }
        if (hotelCard.getLatitude() != null && hotelCard.getLongitude() != null) {
            Location loc = new Location();
            loc.setLatitude(hotelCard.getLatitude().doubleValue());
            loc.setLongitude(hotelCard.getLongitude().doubleValue());
            hp.setLoc(loc);
        }
        List communications = hotelCard.getContacts();
        hp.setHotelFax(HotelsHelper.getFax(communications));
        hp.setHotelEmail(HotelsHelper.getEmail(communications));
        String phone = HotelsHelper.getPhone(communications);
        if (TextUtil.nonBlank((String)phone)) {
            hp.setHotelPhone(phone);
        } else {
            messages.accept(SystemHelper.createMessage((MessageType)MessageType.WARNING, (String)"HOTELS2_MISSING_HOTEL_PHONE_IN_PRODUCT", (Object[])new Object[]{hp.getSystemNumber()}));
        }
        hotelCard.getBaseFacilities().stream().map(com.gridnine.xtrip.common.hotels2.model.Facility::getCaption).filter(TextUtil::nonBlank).forEach(hp.getBaseFacilities()::add);
        hotelCard.getFacilities().stream().map(com.gridnine.xtrip.common.hotels2.model.Facility::getCaption).filter(TextUtil::nonBlank).forEach(hp.getFacilities()::add);
        HotelsHelper.setHotelCommission(hp, offer.getHotelCommission(), totalPrice);
        Room room = (Room)hp.getRooms().get(0);
        HotelsHelper.setTravellers(hp, room, null, offer);
        HotelsHelper.updateRoom(hotelCard, offer, messages, issueDate, vatIncluded, totalPrice, room);
        HotelsHelper.fillCancellationPolicy(hp, offer.getCancellationPolicy());
        hp.getAdditionalServices().addAll(offer.getAdditionalServices());
        HotelsHelper.updateTaxes(hp, offer.getTaxInfoList());
        hp.getTaxInfoList().addAll(offer.getTaxInfoList());
        HotelProductVatFiller.updateVat((HotelProduct)hp);
        HotelProductHelper.updateFops((HotelProduct)hp);
        return hp;
    }

    public static String getCurrency(HotelOffer offer) {
        Money basePrice = offer.getBasePrice();
        return basePrice != null ? basePrice.getCurrency() : null;
    }

    private static void updateRoom(HotelCard hotelCard, HotelOffer offer, Consumer<Message> messages, Date issueDate, Boolean vatIncluded, Money totalPrice, Room room) {
        room.setId(offer.getId());
        room.setSignature(offer.getSearchOfferId());
        room.setNumberOfPeople(Integer.valueOf(offer.getRoomInfo().getTravellers().size()));
        room.setOfferToken(offer.getOfferToken());
        room.setHotelCardNumber(offer.getHotelCardNumber());
        room.setRateType(offer.getRateType());
        room.setAdditionalInfo(offer.getAdditionalInfo());
        room.getRequestedByRemark().addAll(offer.getRequestedByRemark());
        com.gridnine.xtrip.common.hotels2.model.HotelsStayPolicy stayPolicy = offer.getStayPolicy();
        LocalTime checkInTime = stayPolicy != null ? stayPolicy.getCheckInTime() : null;
        LocalTime checkOutTime = stayPolicy != null ? stayPolicy.getCheckOutTime() : null;
        LocalTime standardCheckInTime = stayPolicy != null ? stayPolicy.getStandardCheckInTime() : null;
        LocalTime standardCheckOutTime = stayPolicy != null ? stayPolicy.getStandardCheckOutTime() : null;
        room.setCheckInDate(Optional.ofNullable(offer.getStayPolicy()).map(com.gridnine.xtrip.common.hotels2.model.HotelsStayPolicy::getCheckInDate).map(MiscUtil::toDate).orElseGet(() -> MiscUtil.toDate((LocalTime)checkInTime)));
        room.setCheckOutDate(Optional.ofNullable(offer.getStayPolicy()).map(com.gridnine.xtrip.common.hotels2.model.HotelsStayPolicy::getCheckOutDate).map(MiscUtil::toDate).orElseGet(() -> MiscUtil.toDate((LocalTime)checkOutTime)));
        room.setCheckInTime(checkInTime != null ? HotelsBaseHelper.localTime2Integer(checkInTime) : HotelsBaseHelper.localTime2Integer(standardCheckInTime));
        room.setCheckOutTime(checkOutTime != null ? HotelsBaseHelper.localTime2Integer(checkOutTime) : HotelsBaseHelper.localTime2Integer(standardCheckOutTime));
        room.setStandardCheckInTime(HotelsBaseHelper.localTime2Integer(standardCheckInTime));
        room.setStandardCheckOutTime(HotelsBaseHelper.localTime2Integer(standardCheckOutTime));
        if (room.getCheckInTime() == null) {
            room.setCheckInTime(HotelsBaseHelper.localTime2Integer(hotelCard.getCheckInTime()));
        }
        if (room.getCheckOutTime() == null) {
            room.setCheckOutTime(HotelsBaseHelper.localTime2Integer(hotelCard.getCheckOutTime()));
        }
        if (room.getStandardCheckInTime() == null) {
            room.setStandardCheckInTime(HotelsBaseHelper.localTime2Integer(hotelCard.getCheckInTime()));
        }
        if (room.getStandardCheckOutTime() == null) {
            room.setStandardCheckOutTime(HotelsBaseHelper.localTime2Integer(hotelCard.getCheckOutTime()));
        }
        if (totalPrice != null) {
            room.setBasePrice(totalPrice);
            room.setEquivalentPrice(totalPrice.getValue());
            room.setVat(vatIncluded);
            room.setVatAmount(offer.getProviderVatInfo().getAmount());
            room.setEquivalentVatPrice(offer.getProviderVatInfo().getAmount());
            room.setEquivVatRate(offer.getProviderVatInfo().getRate());
            HotelsHelper.fillDailyRates(room, offer.getBreakdowns());
        }
        room.setBaseRate(HotelProductHelper.calculateRawPriceRatePerNight((LocalDate)stayPolicy.getCheckInDate(), (LocalDate)stayPolicy.getCheckOutDate(), (Money)offer.getBasePrice()));
        if (offer.getRackRate() != null) {
            room.setRackRate(offer.getRackRate().getValue());
        }
        if (TextUtil.isBlank((String)room.getRoomName())) {
            room.setRoomName(offer.getRoomName());
        }
        room.setRoomSize(offer.getRoomSize());
        room.setMeal(HotelsHelper.buildMeal(offer.getMealIncluded()));
        room.setAvailability(offer.getAvailability());
    }

    private static HotelProduct buildHotelProduct(ReservationItem item, ReservationResult reservationResult, PricingItem pricingItem, HotelOffer originalOffer, SalesContext salesContext, Consumer<Message> messages) {
        HotelProduct hp = HotelsHelper.createHotelProduct(salesContext);
        LocalTime standardCheckInTime = null;
        LocalTime standardCheckOutTime = null;
        if (originalOffer != null && originalOffer.getStayPolicy() != null) {
            standardCheckInTime = originalOffer.getStayPolicy().getStandardCheckInTime();
            standardCheckOutTime = originalOffer.getStayPolicy().getStandardCheckOutTime();
        }
        HotelsHelper.updateReservedHotelProduct(hp, item, reservationResult, pricingItem, standardCheckInTime, standardCheckOutTime, originalOffer, messages);
        Room room = (Room)hp.getRooms().get(0);
        HotelsHelper.setTravellers(hp, room, item, originalOffer);
        if (originalOffer != null) {
            if (originalOffer.getMinClientPrice() != null && CommonStatisticsHelper.isCalculatedStatisticRequired((EntityReference)salesContext.getClient(), (CalculatedStatisticType)CalculatedStatisticType.MIN_PRICE_HOTEL)) {
                if (hp.getStatisticalData() == null) {
                    hp.setStatisticalData(new StatisticalData());
                }
                hp.getStatisticalData().setMinPriceHotel(originalOffer.getMinClientPrice());
            }
            if (originalOffer.getMinClientPriceByNight() != null && CommonStatisticsHelper.isCalculatedStatisticRequired((EntityReference)salesContext.getClient(), (CalculatedStatisticType)CalculatedStatisticType.MIN_PRICE_PER_ROOM)) {
                if (hp.getStatisticalData() == null) {
                    hp.setStatisticalData(new StatisticalData());
                }
                hp.getStatisticalData().setMinPricePerRoom(Double.valueOf(originalOffer.getMinClientPriceByNight().doubleValue()));
            }
            if (originalOffer.getRackRate() != null && CommonStatisticsHelper.isCalculatedStatisticRequired((EntityReference)salesContext.getClient(), (CalculatedStatisticType)CalculatedStatisticType.RACK_RATE_PRICE)) {
                if (hp.getStatisticalData() == null) {
                    hp.setStatisticalData(new StatisticalData());
                }
                hp.getStatisticalData().setRackRatePrice(originalOffer.getRackRate().getValue());
            }
            hp.setGdsSubProvider(originalOffer.getVendor());
        }
        HotelProductHelper.updateFops((HotelProduct)hp);
        return hp;
    }

    public static HotelProduct createHotelProduct(SalesContext salesContext) {
        HotelProduct hp = new HotelProduct();
        HotelProductHelper.setAgency((HotelProduct)hp, (EntityReference)salesContext.getAgency());
        HotelProductHelper.setSubagency((HotelProduct)hp, (EntityReference)salesContext.getSubagency());
        hp.setSalesPoint(salesContext.getSalesPoint());
        hp.setCashier(salesContext.getAgent());
        Room room = new Room();
        hp.getRooms().add(room);
        return hp;
    }

    public static void updateReservedHotelProduct(HotelProduct hp, ReservationItem item, ReservationResult reservationResult, PricingItem pricingItem, LocalTime standardCheckInTime, LocalTime standardCheckOutTime, HotelOffer originalOffer, Consumer<Message> messages) {
        Date issueDate;
        ProductStatus oldStatus = hp.getStatus();
        Date oldIssueDate = hp.getIssueDate();
        hp.setStatus(HotelsBaseHelper.convertToProductStatus(item.getItemStatusInfo()));
        ProductStatus status = hp.getStatus();
        hp.setForcedRefund(ProductStatus.REJECT == status);
        hp.setIssueDate((Date)MiscUtil.guarded((Object)HotelsBaseHelper.toDate(item.getCreatedAt()), () -> HotelsBaseHelper.toDate(reservationResult.getCreatedAt())));
        if (hp.getIssueDate() == null) {
            hp.setIssueDate(new Date());
        }
        HotelProductHelper.setOnHold((HotelProduct)hp, (boolean)true);
        HotelsHelper.updateHotelProduct(hp, item, reservationResult, pricingItem, standardCheckInTime, standardCheckOutTime, originalOffer, messages);
        HotelProvider provider = hp.getProvider();
        if ((HotelProvider.ACADEMSERVICE == provider || HotelProvider.HOTELBOOK == provider) && (issueDate = hp.getIssueDate()) != null && issueDate.getTime() == MiscUtil.clearTime((Date)issueDate).getTime()) {
            if (oldStatus == status && oldIssueDate != null && MiscUtil.clearTime((Date)oldIssueDate).getTime() == issueDate.getTime()) {
                hp.setIssueDate(oldIssueDate);
            } else {
                Date now = new Date();
                if (MiscUtil.clearTime((Date)now).getTime() == MiscUtil.clearTime((Date)issueDate).getTime()) {
                    hp.setIssueDate(now);
                }
            }
        }
    }

    public static void updateHotelProduct(HotelProduct hp, ReservationItem item, ReservationResult reservationResult, PricingItem pricingItem, LocalTime standardCheckInTime, LocalTime standardCheckOutTime, HotelOffer originalOffer, Consumer<Message> messages) {
        Money totalPrice;
        Penalty penalty;
        HotelsHelper.fillReservationResultData(hp, reservationResult, item);
        hp.setHotelAggrStatus(HotelsBaseHelper.convertToHotelProductStatus(item.getItemStatusInfo()));
        hp.setProviderStatusInfo(HotelsBaseHelper.convertToProviderStatusInfo(item.getItemStatusInfo()));
        String gdsCurrency = HotelsReservationHelper.getCurrency((PricedItem)item);
        hp.setGdsCurrency(gdsCurrency);
        if (item.getVendorCurrencyRate() != null) {
            hp.setGdsCurrencyRate(Double.valueOf(item.getVendorCurrencyRate().doubleValue()));
        }
        hp.setHotelByRequest(pricingItem != null && !pricingItem.isFreeForSale());
        hp.setCotsGuaranteed(HotelsHelper.isOptionSetContains(item.getOfferOptionSet(), OfferOptionType.EXTRA_BED_INFANTS));
        hp.setCancellationPolicyCostsMayChange(item.isCancellationPolicyCostsMayChange());
        hp.setSharingBedding(item.isSharingBedding());
        hp.setTicketType(HotelsHelper.getTicketType(item.getAvailability()));
        hp.setGuaranteeType(HotelsHelper.getGuaranteeType(item.getAvailability()));
        hp.setTariffType(HotelsHelper.getTariffType(item.getAvailability()));
        hp.setRoomCount(item.getRoomCount());
        hp.setCommentAllowed(BooleanUtils.isTrue((Boolean)item.isIsCommentAllowed()));
        hp.setTripartiteAgreement(BooleanUtils.isTrue((Boolean)item.isIsTripartiteAgreement()));
        hp.setClientTariffCode(item.getClientTariffCode());
        if (item.getSubProvider() != null) {
            hp.setSubProviderId(item.getSubProvider().getProviderId());
        }
        HotelsHelper.fillEssentialInfoData(hp, originalOffer, item);
        hp.getAdditionalServices().clear();
        hp.getAdditionalServices().addAll(HotelsHelper.buildAdditionalServices(item.getOptions(), hp.getIssueDate(), true));
        hp.getNotConfirmedAdditionalServices().addAll(HotelsHelper.buildAdditionalServices(item.getOptions(), hp.getIssueDate(), false));
        hp.getPenalties().clear();
        Money cancellationPenalty = HotelsBaseHelper.convertMoneyFromGds(item.getCancellationPenalty());
        if (cancellationPenalty != null && !MiscUtil.isZero((BigDecimal)cancellationPenalty.getValue(), (boolean)true) && (penalty = PenaltyHelper.createPenalty(cancellationPenalty, gdsCurrency)) != null) {
            hp.getPenalties().add(penalty);
        }
        com.gridnine.hotels.web.ws.HotelCard wsHotelCard = item.getHotelCard();
        Boolean vatIncluded = VatHelper.isVatIncluded((PricedItem)item);
        if (!item.getPrice().getBreakdown().isEmpty()) {
            BigDecimal amount = item.getPrice().getBreakdown().stream().map(HotelsMoney::getAmount).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
            String currency = item.getPrice().getBreakdown().stream().map(HotelsMoney::getCurrency).findFirst().orElse(null);
            totalPrice = MoneyHelper.buildMoney((BigDecimal)amount, (String)currency);
        } else {
            totalPrice = HotelsBaseHelper.convertMoneyFromGds(item.getPrice());
        }
        HotelsHelper.fillHotelCardData(hp, wsHotelCard, messages, item);
        HotelsHelper.setHotelCommission(hp, item.getCommission(), totalPrice);
        Room room = (Room)hp.getRooms().get(0);
        HotelsHelper.updateRoom(room, item, wsHotelCard, hp.getSystemNumber(), hp.getIssueDate(), totalPrice, vatIncluded, pricingItem, standardCheckInTime, standardCheckOutTime, hp.getProvider(), messages);
        HotelsHelper.fillCancellationPolicy(hp, item.getCancellationPolicy(), vatIncluded, room.getEquivVatRate());
        HotelsHelper.updateTaxes(hp, item.getTaxInfoList());
        HotelProductVatFiller.updateVat((HotelProduct)hp);
        hp.getTaxInfoList().clear();
        if (item.getTaxInfoList() != null) {
            hp.getTaxInfoList().addAll(HotelsHelper.buildTaxInfoList(item.getTaxInfoList().getTaxInfo()));
        }
        hp.setComments(item.getRequestItemId());
    }

    private static void updateTaxes(HotelProduct product, ReservationItem.TaxInfoList taxInfoList) {
        BigDecimal sum = BigDecimal.ZERO;
        product.getTaxes().clear();
        if (taxInfoList != null) {
            for (com.gridnine.hotels.web.ws.TaxInfo taxInfo : taxInfoList.getTaxInfo()) {
                if (!Boolean.TRUE.equals(taxInfo.isIncluded())) continue;
                HotelProductTax tax = new HotelProductTax();
                tax.setCode(taxInfo.getName());
                tax.setAmount(HotelsBaseHelper.convertMoneyFromGds(taxInfo.getMoney()));
                if (tax.getAmount() != null) {
                    BigDecimal amount = tax.getAmount().getValue();
                    tax.setEquivalentAmount(amount);
                    sum = sum.add(amount);
                }
                product.getTaxes().add(tax);
            }
        }
        if (BigDecimal.ZERO.compareTo(sum) != 0) {
            Room room = (Room)product.getRooms().get(0);
            if (room.getBasePrice() != null) {
                room.setBasePrice(MoneyHelper.buildMoney((BigDecimal)room.getBasePrice().getValue().subtract(sum), (String)room.getBasePrice().getCurrency()));
            }
            if (room.getEquivalentPrice() != null) {
                room.setEquivalentPrice(room.getEquivalentPrice().subtract(sum));
            }
        }
    }

    private static void updateTaxes(HotelProduct product, List<TaxInfo> taxInfoList) {
        BigDecimal sum = BigDecimal.ZERO;
        product.getTaxes().clear();
        for (TaxInfo taxInfo : taxInfoList) {
            if (!taxInfo.isIncludedInTariff()) continue;
            HotelProductTax tax = new HotelProductTax();
            tax.setCode(taxInfo.getName());
            tax.setAmount(taxInfo.getAmount());
            if (tax.getAmount() != null) {
                BigDecimal amount = tax.getAmount().getValue();
                tax.setEquivalentAmount(amount);
                sum = sum.add(amount);
            }
            product.getTaxes().add(tax);
        }
        if (BigDecimal.ZERO.compareTo(sum) != 0) {
            Room room = (Room)product.getRooms().get(0);
            if (room.getBasePrice() != null) {
                room.setBasePrice(MoneyHelper.buildMoney((BigDecimal)room.getBasePrice().getValue().subtract(sum), (String)room.getBasePrice().getCurrency()));
            }
            if (room.getEquivalentPrice() != null) {
                room.setEquivalentPrice(room.getEquivalentPrice().subtract(sum));
            }
        }
    }

    private static void updateRoom(Room room, ReservationItem item, com.gridnine.hotels.web.ws.HotelCard wsHotelCard, String systemNumber, Date issueDate, Money totalPrice, Boolean vatIncluded, PricingItem pricingItem, LocalTime defaultCheckInTime, LocalTime defaultCheckOutTime, HotelProvider provider, Consumer<Message> messages) {
        String token;
        room.setId(item.getId());
        room.setSignature(item.getRawId());
        room.setAlterId(item.getAlterId());
        if (item.getGuests() != null) {
            room.setNumberOfPeople(Integer.valueOf(item.getGuests().getGuest().size()));
        }
        if (null == (token = item.getToken()) && pricingItem != null) {
            token = pricingItem.getOfferToken();
        }
        room.setOfferToken(token);
        room.setHotelCardNumber(item.getHotelCardNumber());
        room.setUpdateAllowed(item.isIsUpdateAllowed());
        room.setRateType(HotelsBaseHelper.convertRateTypeFromGds(item.getRateType()));
        room.setAdditionalInfo(item.getAdditionalInfo());
        room.getRequestedByRemark().clear();
        HotelsHelper.fillRequestedByRemark(room, item.getByRemark());
        room.setCheckInDate(HotelsBaseHelper.toDate(item.getCheckInDate()));
        room.setCheckOutDate(HotelsBaseHelper.toDate(item.getCheckOutDate()));
        Integer standardCheckInTime = (Integer)MiscUtil.guarded((Object)HotelsBaseHelper.localTime2Integer(defaultCheckInTime), (Object)HotelsBaseHelper.time2Integer(item.getStandardCheckinTime()));
        Integer standardCheckOutTime = (Integer)MiscUtil.guarded((Object)HotelsBaseHelper.localTime2Integer(defaultCheckOutTime), (Object)HotelsBaseHelper.time2Integer(item.getStandardCheckoutTime()));
        room.setCheckInTime((Integer)MiscUtil.guarded((Object)item.getCheckInTime(), (Object)standardCheckInTime));
        room.setCheckOutTime((Integer)MiscUtil.guarded((Object)item.getCheckOutTime(), (Object)standardCheckOutTime));
        room.setStandardCheckInTime(standardCheckInTime);
        room.setStandardCheckOutTime(standardCheckOutTime);
        if (wsHotelCard != null) {
            if (room.getCheckInTime() == null) {
                room.setCheckInTime(wsHotelCard.getCheckinTime());
            }
            if (room.getCheckOutTime() == null) {
                room.setCheckOutTime(wsHotelCard.getCheckoutTime());
            }
            if (room.getStandardCheckInTime() == null) {
                room.setStandardCheckInTime(wsHotelCard.getCheckinTime());
            }
            if (room.getStandardCheckOutTime() == null) {
                room.setStandardCheckOutTime(wsHotelCard.getCheckoutTime());
            }
        }
        if (totalPrice != null) {
            room.setBasePrice(totalPrice);
            room.setEquivalentPrice(totalPrice.getValue());
            room.setVat(vatIncluded);
            BigDecimal vatAmount = VatHelper.getVatAmount(room.getEquivalentPrice(), item.getVatComponent(), item.getVatAmount());
            Double vatRate = VatHelper.getVatRate(room.getEquivalentPrice(), item.getVatComponent(), item.getVatAmount());
            room.setVatAmount(vatAmount);
            room.setEquivalentVatPrice(vatAmount);
            room.setEquivVatRate(vatRate);
            HotelsHelper.fillDailyRates(room, item.getPrice().getBreakdown().stream().map(hotelsMoney -> MoneyHelper.buildMoney((BigDecimal)hotelsMoney.getAmount(), (String)hotelsMoney.getCurrency())).collect(Collectors.toList()));
        }
        room.setBaseRate(HotelsHelper.getBaseRate(item));
        room.setRackRate(item.getRackRate());
        if (TextUtil.isBlank((String)room.getRoomName())) {
            room.setRoomName(item.getRoomName());
        }
        room.setRoomSize(HotelsHelper.getRoomSize(item.getRoomSize()));
        room.setMeal(HotelsHelper.buildMeal(item));
        room.getAvailableOptions().clear();
        HotelsHelper.fillAvailableOptions(room, item.getOfferOptionSet());
        room.setAvailability(HotelsHelper.convertAvailabilityFromGds(item.getAvailability()));
    }

    private static void fillDailyRates(Room room, List<Money> breakdowns) {
        if (CollectionUtil.isNotEmpty(breakdowns)) {
            List dailyRates = room.getDailyRates();
            dailyRates.clear();
            dailyRates.add(HotelsHelper.createDailyRate(breakdowns.get(0), room.getCheckInDate()));
            for (int i = 1; i < breakdowns.size(); ++i) {
                DailyRate lastDailyRate = (DailyRate)CollectionUtil.getLastElement((List)dailyRates);
                if (MoneyHelper.compare((Money)breakdowns.get(i - 1), (Money)breakdowns.get(i)) == 0) {
                    lastDailyRate.setEndDate(MiscUtil.addDaysToDate((Date)lastDailyRate.getEndDate(), (int)1));
                    continue;
                }
                dailyRates.add(HotelsHelper.createDailyRate(breakdowns.get(i), lastDailyRate.getEndDate()));
            }
        }
    }

    private static DailyRate createDailyRate(Money dailyPrice, Date startDate) {
        DailyRate dailyRate = new DailyRate();
        dailyRate.setStartDate(startDate);
        dailyRate.setEndDate(MiscUtil.addDaysToDate((Date)startDate, (int)1));
        dailyRate.setRate(dailyPrice);
        return dailyRate;
    }

    private static void fillReservationResultData(HotelProduct hp, ReservationResult reservationResult, ReservationItem item) {
        if (item.getHotelReference() != null) {
            hp.setProviderHotelCode(item.getHotelReference().getProviderCode());
        }
        hp.setProviderProfileId(reservationResult.getProviderProfileId());
        hp.setUsedPcc(reservationResult.getPcc());
        HotelProvider provider = HotelsBaseHelper.convertProviderFromGds(reservationResult.getProvider());
        DictionaryReference<HotelSubProvider> subProvider = HotelsHelper.findSubProvider(provider, item.getSubProvider());
        hp.setProvider(provider);
        hp.setSubProvider(subProvider);
        hp.setBlankOwnerCode(reservationResult.getVendor());
        HotelProductHelper.setSupplier((HotelProduct)hp, (EntityReference)HotelProductHelper.getSupplierFor((HotelProvider)provider, subProvider));
        hp.setBlankOwnerRef(HotelProductHelper.getBlankOwnerFor((String)hp.getBlankOwnerCode(), subProvider));
        hp.setSystemNumber(HotelsHelper.getSystemNumber(reservationResult.getReservationId(), provider));
        if (reservationResult.getReservationId() != null) {
            hp.setPcc(reservationResult.getReservationId().getPcc());
        }
        hp.setCityProviderData(HotelsHelper.buildDictProviderData(item.getLocationData()));
        hp.setCountryProviderData(HotelsHelper.buildDictProviderData(item.getCountryData()));
    }

    private static String getRoomSize(RoomSize size) {
        String sizeName;
        if (size == null) {
            return null;
        }
        String sizeCode = EnumUtil.nameOf((Enum)size);
        RoomSizeDict roomSize = DictHelper.getRoomSize((String)sizeCode, (boolean)false);
        if (roomSize != null && TextUtil.nonBlank((String)(sizeName = DictHelper.getTranslation((BaseDictionary)roomSize, (Locale)LocaleHelper.RU_LOCALE, (boolean)false)))) {
            return sizeName;
        }
        return sizeCode;
    }

    private static HotelProviderDictData buildDictProviderData(LocationData locationData) {
        if (locationData == null) {
            return null;
        }
        HotelProviderDictData result = new HotelProviderDictData();
        result.setSystemCode(locationData.getSystemCode());
        result.setProviderCode(locationData.getProviderCode());
        result.setProviderName(locationData.getProviderName());
        return result;
    }

    private static HotelProviderDictData buildDictProviderData(CountryData countryData) {
        if (countryData == null) {
            return null;
        }
        HotelProviderDictData result = new HotelProviderDictData();
        result.setSystemCode(countryData.getSystemCode());
        result.setProviderCode(countryData.getProviderCode());
        result.setProviderName(countryData.getProviderName());
        return result;
    }

    private static String getSystemNumber(ReservationID reservationId, HotelProvider provider) {
        if (reservationId == null) {
            return null;
        }
        if ("OKTOGO".equals(provider.name())) {
            return reservationId.getPnr();
        }
        return reservationId.getReservationNumber();
    }

    public static void updateProductSystemNumber(HotelProduct hp) {
        String pnr = ReservationGdsNameInfoHelper.getOnlineRecordLocator((Reservation)hp.getReservation(), (RecordLocatorType)RecordLocatorType.HOTEL_AGGREGATOR_PNR);
        if (null == pnr) {
            return;
        }
        String mainPart = pnr + "-";
        Integer max = HotelsReservationHelper.getProductsStream(hp.getReservation()).map(HotelProduct::getSystemNumber).filter(TextUtil::nonBlank).filter(nmb -> nmb.startsWith(mainPart)).map(nmb -> nmb.substring(mainPart.length())).filter(TextUtil::nonBlank).filter(StringUtils::isNumeric).map(Integer::valueOf).max(Comparator.naturalOrder()).orElse(0);
        int currentIndex = max + 1;
        hp.setSystemNumber(mainPart + currentIndex);
    }

    private static TicketType getTicketType(com.gridnine.hotels.web.ws.HotelsServiceAvailability availability) {
        if (availability != null && availability.getPayee() == com.gridnine.hotels.web.ws.HotelsPayee.HOTEL) {
            return TicketType.REFERRAL;
        }
        return TicketType.OWN;
    }

    public static TicketType getTicketType(HotelsServiceAvailability availability) {
        if (availability != null && availability.getPayee() == HotelsPayee.HOTEL) {
            return TicketType.REFERRAL;
        }
        return TicketType.OWN;
    }

    private static GuaranteeType getGuaranteeType(com.gridnine.hotels.web.ws.HotelsServiceAvailability availability) {
        if (availability != null && availability.getPayee() == com.gridnine.hotels.web.ws.HotelsPayee.HOTEL) {
            return GuaranteeType.CREDIT_CARD;
        }
        return null;
    }

    private static GuaranteeType getGuaranteeType(HotelsServiceAvailability availability) {
        if (availability != null && availability.getPayee() == HotelsPayee.HOTEL) {
            return GuaranteeType.CREDIT_CARD;
        }
        return null;
    }

    private static HotelTariffType getTariffType(com.gridnine.hotels.web.ws.HotelsServiceAvailability availability) {
        if (availability != null && availability.getPayee() == com.gridnine.hotels.web.ws.HotelsPayee.HOTEL) {
            return HotelTariffType.RECEPTION;
        }
        return HotelTariffType.REGULAR;
    }

    private static List<AdditionalService> buildAdditionalServices(HotelsOptionList options, Date issueDate, boolean confirmed) {
        if (options == null) {
            return Collections.emptyList();
        }
        ArrayList<AdditionalService> result = new ArrayList<AdditionalService>();
        if (CollectionUtil.isNotEmpty((Collection)options.getCheckInOutOption())) {
            options.getCheckInOutOption().stream().filter(option -> HotelsHelper.isAdditionalService((HotelsOption)option, confirmed)).map(opt -> HotelsHelper.toAdditionalService(opt, issueDate)).filter(Objects::nonNull).forEach(result::add);
        }
        if (CollectionUtil.isNotEmpty((Collection)options.getMealplanOption())) {
            options.getMealplanOption().stream().filter(option -> HotelsHelper.isAdditionalService((HotelsOption)option, confirmed)).map(opt -> HotelsHelper.toAdditionalService(opt, issueDate)).filter(Objects::nonNull).forEach(result::add);
        }
        if (CollectionUtil.isNotEmpty((Collection)options.getExtraBedOption())) {
            options.getExtraBedOption().stream().filter(option -> HotelsHelper.isAdditionalService((HotelsOption)option, confirmed)).map(opt -> HotelsHelper.toExtraBedAdditionalService(opt, issueDate)).filter(Objects::nonNull).forEach(result::add);
        }
        if (CollectionUtil.isNotEmpty((Collection)options.getCustomOption())) {
            options.getCustomOption().stream().filter(option -> HotelsHelper.isAdditionalService((HotelsOption)option, confirmed)).map(opt -> HotelsHelper.toCustomAdditionalService(opt, issueDate)).filter(Objects::nonNull).forEach(result::add);
        }
        return result;
    }

    private static boolean isAdditionalService(HotelsOption option, boolean confirmed) {
        HotelsOptionAvailability availability = option.getAvailability();
        if (availability.getStatus() == null) {
            return confirmed;
        }
        return confirmed == (availability.getStatus() == com.gridnine.hotels.web.ws.HotelsServiceOptionStatus.CONFIRMED);
    }

    private static AdditionalService toAdditionalService(HotelsCheckInOutOption checkInOutOption, Date issueDate) {
        AdditionalService result = HotelsHelper.buildCommonAdditionalService((HotelsOption)checkInOutOption, issueDate);
        if (result == null) {
            return null;
        }
        result.setType(HotelsBaseHelper.convertAdditionalServiceType(checkInOutOption.getType()));
        if (TextUtil.isBlank((String)result.getName()) && checkInOutOption.getFrom() != null && checkInOutOption.getTo() != null) {
            result.setName(String.format("%02d:%02d - %02d:%02d", checkInOutOption.getFrom().getHour(), checkInOutOption.getFrom().getMinute(), checkInOutOption.getTo().getHour(), checkInOutOption.getTo().getMinute()));
        }
        result.setCount(1);
        return result;
    }

    private static AdditionalService toAdditionalService(HotelsMealplanOption mealOption, Date issueDate) {
        AdditionalService result = HotelsHelper.buildCommonAdditionalService((HotelsOption)mealOption, issueDate);
        if (result == null) {
            return null;
        }
        if (result.isIncludedInTariff()) {
            return null;
        }
        result.setType(AdditionalServiceType.MEAL);
        result.setCode(mealOption.getProviderCode());
        result.setName(HotelsHelper.getMealName(mealOption));
        return result;
    }

    private static AdditionalService toExtraBedAdditionalService(HotelsExtraBedOption wsOption, Date issueDate) {
        AdditionalService result = HotelsHelper.buildCommonAdditionalService((HotelsOption)wsOption, issueDate);
        if (result == null) {
            return null;
        }
        result.setType(HotelsBaseHelper.convertAdditionalServiceType(wsOption.getType()));
        result.setName(wsOption.getName());
        result.setCount(((Integer)MiscUtil.guarded((Object)wsOption.getCount(), (Object)1)).intValue());
        return result;
    }

    private static AdditionalService toCustomAdditionalService(HotelsCustomOption customOption, Date issueDate) {
        AdditionalService result = HotelsHelper.buildCommonAdditionalService((HotelsOption)customOption, issueDate);
        if (result == null) {
            return null;
        }
        result.setType(HotelsBaseHelper.convertAdditionalServiceType(customOption.getType()));
        return result;
    }

    private static AdditionalService buildCommonAdditionalService(HotelsOption wsOption, Date issueDate) {
        boolean includedInTariff;
        HotelsOptionAvailability availability = wsOption.getAvailability();
        if (availability == null) {
            return null;
        }
        boolean bl = includedInTariff = availability.getType() == HotelsOptionAvailabilityType.INCLUDED;
        if (includedInTariff || BooleanUtils.isNotTrue((Boolean)availability.isRequested())) {
            return null;
        }
        String addServiceName = wsOption.getText();
        AdditionalService result = new AdditionalService();
        result.setName(addServiceName);
        result.setIncludedInTariff(includedInTariff);
        result.setStatus(HotelsBaseHelper.convertAdditionalServiceStatus(availability.getStatus()));
        Money baseAmount = HotelsBaseHelper.convertMoneyFromGds(wsOption.getPrice());
        result.setBaseAmount(baseAmount);
        if (baseAmount != null) {
            BigDecimal equivalentAmount = MiscUtil.equals((Object)baseAmount.getCurrency(), (Object)DictHelper.getLocalCurrency()) ? baseAmount.getValue() : FinanceHelper.exchange((BigDecimal)baseAmount.getValue(), (String)baseAmount.getCurrency(), (String)"RUB", (CurrencyRateType)CurrencyRateType.CBR, (TariffType)TariffType.REGULAR, (Date)issueDate, null, (boolean)true);
            result.setEquivalentAmount(equivalentAmount);
            result.setEquivalentVatAmount(VatHelper.getVatAmount(equivalentAmount, wsOption.getVatComponent(), null));
            result.setEquivalentVatRate(VatHelper.getVatRate(equivalentAmount, wsOption.getVatComponent(), null));
        }
        return result;
    }

    private static void fillRequestedByRemark(Room room, List<OfferOptionType> byRemarkList) {
        if (CollectionUtil.isEmpty(byRemarkList)) {
            return;
        }
        byRemarkList.stream().map(HotelsBaseHelper::convertAdditionalServiceType).filter(Objects::nonNull).forEach(room.getRequestedByRemark()::add);
    }

    private static Money getBaseRate(ReservationItem item) {
        HotelsMoney price = item.getPrice();
        if (price == null) {
            return null;
        }
        HotelsStayPolicy stayPolicy = item.getStayPolicy();
        if (!HotelsStayType.FIXED_HOURS.equals((Object)EnumUtil.recodeSafe((Enum)stayPolicy.getType(), HotelsStayType.class)) && stayPolicy.getCheckIn() != null && stayPolicy.getCheckOut() != null) {
            Date checkInDate = HotelsBaseHelper.toDate(stayPolicy.getCheckIn().getDate());
            Date checkOutDate = HotelsBaseHelper.toDate(stayPolicy.getCheckOut().getDate());
            return HotelProductHelper.calculateRawPriceRatePerNight((Date)checkInDate, (Date)checkOutDate, (BigDecimal)price.getAmount(), (String)price.getCurrency());
        }
        return HotelsBaseHelper.convertMoneyFromGds(item.getTotalPrice());
    }

    private static void setHotelCommission(HotelProduct hp, Commission wsCommission, Money totalPrice) {
        HotelsHelper.setHotelCommission(hp, HotelsReservationHelper.buildHotelCommission(wsCommission, totalPrice));
    }

    private static void setHotelCommission(HotelProduct hp, HotelProductCommission commission, Money totalPrice) {
        HotelsHelper.setHotelCommission(hp, HotelsReservationHelper.buildHotelCommission(commission, totalPrice));
    }

    public static void setHotelCommission(HotelProduct hp, HotelProductCommission hotelCommission) {
        hp.setHotelAggrCommission(hotelCommission);
        HotelsReservationHelper.updateVendorContractRelationCommission(hp, hotelCommission);
    }

    private static Meal buildMeal(ReservationItem item) {
        if (item.getOptions() == null || CollectionUtil.isEmpty((Collection)item.getOptions().getMealplanOption())) {
            return null;
        }
        return item.getOptions().getMealplanOption().stream().filter(HotelsHelper::isIncluded).findFirst().map(HotelsHelper::toMeal).orElse(null);
    }

    public static Meal buildMeal(MealPlan mealPlan) {
        if (mealPlan == null) {
            return null;
        }
        Meal result = new Meal();
        result.setCode(mealPlan.getCode());
        result.setCaption((String)MiscUtil.guarded((Object)mealPlan.getCaption(), (Object)mealPlan.getBasemealCaption(), (Object[])new String[]{NO_NAME_NAME}));
        result.setBaseCode(mealPlan.getBasemealId());
        result.setBaseCaption(mealPlan.getBasemealCaption());
        return result;
    }

    private static boolean isIncluded(HotelsOption opt) {
        if (opt == null || opt.getAvailability() == null) {
            return false;
        }
        return opt.getAvailability().getType() == HotelsOptionAvailabilityType.INCLUDED;
    }

    private static Meal toMeal(HotelsMealplanOption mealOpt) {
        if (mealOpt == null) {
            return null;
        }
        Meal result = new Meal();
        String mealCode = (String)MiscUtil.guarded((Object)mealOpt.getProviderCode(), (Object)mealOpt.getMealCode(), (Object[])new String[]{mealOpt.getBaseMealCode()});
        result.setCode(mealCode);
        if (mealCode == null && HotelsHelper.isIncluded((HotelsOption)mealOpt)) {
            result.setCaption(NO_CODE_NAME);
        } else {
            result.setCaption(HotelsHelper.getMealName(mealOpt));
        }
        result.setBaseCode(mealOpt.getBaseMealCode());
        result.setBaseCaption(mealOpt.getBaseMealName());
        return result;
    }

    private static String getMealName(HotelsMealplanOption mealOption) {
        return (String)MiscUtil.guarded((Object)mealOption.getProviderName(), (Object)mealOption.getMealName(), (Object[])new String[]{mealOption.getBaseMealName(), NO_NAME_NAME});
    }

    private static void fillAvailableOptions(Room room, OfferOptionSet offerOptionSet) {
        if (offerOptionSet == null || offerOptionSet.getOptions() == null || CollectionUtil.isEmpty((Collection)offerOptionSet.getOptions().getOptions())) {
            return;
        }
        offerOptionSet.getOptions().getOptions().stream().map(HotelsHelper::convertAvailableOption).filter(Objects::nonNull).forEach(room.getAvailableOptions()::add);
    }

    private static AvailableOption convertAvailableOption(OfferOption offerOption) {
        if (offerOption == null) {
            return null;
        }
        AvailableOption result = new AvailableOption();
        result.setOptionType(HotelsBaseHelper.convertOfferOptionTypeFromGds(offerOption.getType()));
        result.setCode(offerOption.getCode());
        result.setDisplayName(offerOption.getDisplayName());
        return result;
    }

    public static void setTravellers(HotelProduct hp, Room room, ReservationItem item, HotelOffer originalOffer) {
        if (originalOffer != null) {
            originalOffer.getRoomInfo().getTravellers().forEach(t -> HotelsHelper.addTraveller(hp, room, t, HotelsReservationHelper.getTravellerPassengerType(t)));
        } else if (item.getGuests() != null) {
            item.getGuests().getGuest().forEach(g -> HotelsHelper.addTraveller(hp, room, HotelsReservationHelper.buildTraveller(g), HotelsReservationHelper.getPassengerType(g.isChild())));
        }
    }

    public static void addTraveller(HotelProduct hp, Room room, Traveller traveller, DictionaryReference<PassengerType> passengerType) {
        hp.getTravellers().add(traveller);
        room.getRoomTravellersUids().add(traveller.getUid());
        PassengerTypeReference ptr = new PassengerTypeReference();
        ptr.setTravellerUid(traveller.getUid());
        ptr.setPassengerType(passengerType);
        hp.getTravellersPassengerTypes().add(ptr);
    }

    private static void fillHotelCardData(HotelProduct hp, com.gridnine.hotels.web.ws.HotelCard wsCard, Consumer<Message> messages, ReservationItem item) {
        hp.setHotelPropertyId(wsCard.getNumber() != null ? StringUtils.trim((String)wsCard.getNumber()) : StringUtils.trim((String)item.getHotelCardNumber()));
        hp.setHotelName(StringUtils.trim((String)wsCard.getName()));
        if (wsCard.getHotelType() != null) {
            hp.setHotelType((HotelType)EnumUtil.fromNameSafe(HotelType.class, (String)wsCard.getHotelType().name(), null));
        }
        hp.setHotelStars(HotelsBaseHelper.convertHotelCategoryFromGds(wsCard.getCategory()));
        hp.setDescription(StringUtils.trim((String)wsCard.getDescription()));
        hp.setHotelResolved(wsCard.isHotelResolved());
        Address address = HotelsHelper.convertToAddress(wsCard.getAddress(), wsCard.getCity());
        if (address != null) {
            hp.setHotelLocation(address.getCity());
            hp.setHotelCountry(address.getCountry());
            hp.setHotelAddress(wsCard.getAddress().getAddress());
        }
        if (wsCard.getLatitude() != 0.0 && wsCard.getLongitude() != 0.0) {
            Location loc = new Location();
            loc.setLatitude(wsCard.getLatitude());
            loc.setLongitude(wsCard.getLongitude());
            hp.setLoc(loc);
        }
        ArrayList<Communication> communications = new ArrayList<Communication>();
        if (wsCard.getContacts() != null) {
            HotelsHelper.fillContacts(communications, wsCard.getContacts().getContact());
        }
        hp.setHotelFax(HotelsHelper.getFax(communications));
        hp.setHotelEmail(HotelsHelper.getEmail(communications));
        String phone = HotelsHelper.getPhone(communications);
        if (TextUtil.nonBlank((String)phone)) {
            hp.setHotelPhone(phone);
        } else {
            messages.accept(SystemHelper.createMessage((MessageType)MessageType.WARNING, (String)"HOTELS2_MISSING_HOTEL_PHONE_IN_PRODUCT", (Object[])new Object[]{hp.getSystemNumber()}));
        }
        hp.getBaseFacilities().clear();
        if (wsCard.getBaseFacility() != null) {
            HotelsHelper.fillFacilityCaptions(hp.getBaseFacilities(), wsCard.getBaseFacility().getBaseFacility());
        }
        hp.getFacilities().clear();
        if (wsCard.getFacilities() != null) {
            HotelsHelper.fillFacilityCaptions(hp.getFacilities(), wsCard.getFacilities().getFacility());
        }
    }

    private static void fillFacilityCaptions(List<String> result, List<Facility> wsFacilities) {
        if (CollectionUtil.isEmpty(wsFacilities)) {
            return;
        }
        wsFacilities.stream().map(HotelsHelper::convertFacility).filter(Objects::nonNull).map(com.gridnine.xtrip.common.hotels2.model.Facility::getCaption).filter(TextUtil::nonBlank).forEach(result::add);
    }

    private static void fillCancellationPolicy(HotelProduct hp, CancellationPolicyWS wsPolicy, Boolean vatIncluded, Double equivVatRate) {
        Room room;
        Integer checkInTime;
        Date issueDate1;
        if (wsPolicy == null) {
            return;
        }
        hp.setCancellableNow(Boolean.valueOf(wsPolicy.isCancellableNow()));
        hp.getCancellationCharges().clear();
        boolean cancellable = false;
        Date freeCancellationTerm = null;
        Date date = issueDate1 = hp.getIssueDate() != null ? hp.getIssueDate() : new Date();
        Date checkInDate = !hp.getRooms().isEmpty() ? ((checkInTime = (Integer)MiscUtil.guarded((Object)(room = (Room)hp.getRooms().get(0)).getCheckInTime(), (Object)room.getStandardCheckInTime())) != null ? MiscUtil.addMinutesToDate((Date)room.getCheckInDate(), (int)checkInTime) : room.getCheckInDate()) : null;
        for (CancellationPeriodWS wsPeriod : wsPolicy.getPeriod()) {
            if (BooleanUtils.isNotTrue((Boolean)wsPeriod.isCancellable())) continue;
            cancellable = true;
            if (wsPeriod.getPenalty() == null || MiscUtil.isZero((BigDecimal)wsPeriod.getPenalty().getAmount(), (boolean)true)) {
                if (wsPeriod.getFrom().getValue() == HotelsDateTimeSpecialValue.NEGATIVE_INFINITY && wsPeriod.getTo().getValue() == null) {
                    freeCancellationTerm = HotelsBaseHelper.toDate(wsPeriod.getTo());
                    continue;
                }
                if (!TextUtil.nonBlank((String)wsPeriod.getText())) continue;
                hp.getCancellationCharges().add(HotelsHelper.buildCancellationCharge(wsPeriod, vatIncluded, equivVatRate, issueDate1, checkInDate != null ? checkInDate : (!hp.getRooms().isEmpty() ? ((Room)hp.getRooms().get(0)).getCheckInDate() : null)));
                continue;
            }
            hp.getCancellationCharges().add(HotelsHelper.buildCancellationCharge(wsPeriod, vatIncluded, equivVatRate, issueDate1, checkInDate != null ? checkInDate : (!hp.getRooms().isEmpty() ? ((Room)hp.getRooms().get(0)).getCheckInDate() : null)));
        }
        hp.setCancellationPolicyText(!wsPolicy.getPeriod().isEmpty() ? wsPolicy.getText() : null);
        hp.setCancellable(cancellable);
        hp.setFreeCancellationTerm(freeCancellationTerm);
    }

    private static void fillCancellationPolicy(HotelProduct hp, CancellationPolicy policy) {
        Room room;
        Integer checkInTime;
        Date issueDate;
        if (policy == null || policy instanceof NonCancellablePolicy) {
            return;
        }
        CancellablePolicy cancellablePolicy = (CancellablePolicy)policy;
        hp.setCancellableNow(Boolean.valueOf(cancellablePolicy.isCancellableNow()));
        Date date = issueDate = hp.getIssueDate() != null ? hp.getIssueDate() : new Date();
        Date checkInDate = !hp.getRooms().isEmpty() ? ((checkInTime = (Integer)MiscUtil.guarded((Object)(room = (Room)hp.getRooms().get(0)).getCheckInTime(), (Object)room.getStandardCheckInTime())) != null ? MiscUtil.addMinutesToDate((Date)room.getCheckInDate(), (int)checkInTime) : room.getCheckInDate()) : null;
        CancellationChargeHolder cancellationChargeHolder = cancellablePolicy.getCancellationChargesHolder();
        if (cancellationChargeHolder != null) {
            hp.getCancellationCharges().addAll(cancellationChargeHolder.getCancellationCharges().stream().peek(cancellationCharge -> CancellationPolicyHelper.fixDates(cancellationCharge, issueDate, checkInDate)).collect(Collectors.toList()));
            CancellationCharge lastCC = (CancellationCharge)CollectionUtil.getLastElement((List)cancellationChargeHolder.getCancellationCharges());
            if (MiscUtil.compare((Date)lastCC.getEndDate(), (Date)checkInDate) == -1) {
                lastCC.setEndDate(checkInDate);
            }
            hp.setCancellable(CollectionUtil.isNotEmpty((Collection)cancellationChargeHolder.getCancellationCharges()));
            hp.setFreeCancellationTerm(cancellationChargeHolder.getFreeCancellationTerm());
        }
        hp.setCancellationPolicyText(policy.getText());
    }

    private static void fillEssentialInfoData(HotelProduct hp, HotelOffer originalOffer, ReservationItem item) {
        if (originalOffer != null) {
            HotelsHelper.addEssentialInfo(originalOffer.getEssentialInfoList(), hp.getEssentialInfoData());
        } else {
            if (item.getEssentialInfo() != null && item.getEssentialInfo().getInfoMap() != null) {
                HotelsHelper.addEssentialInfo(HotelsHelper.buildEssentialInfoList(item.getEssentialInfo().getInfoMap().getEntry()), hp.getEssentialInfoData());
            }
            if (item.getHotelCard() != null && item.getRoom() != null && item.getHotelCard().getRooms() != null) {
                item.getHotelCard().getRooms().getRoom().stream().filter(card -> MiscUtil.equals((Object)card.getProviderIdRoom(), (Object)item.getRoom().getSignature(), (boolean)false) || MiscUtil.equals((Object)card.getName(), (Object)item.getRoom().getProviderName(), (boolean)false)).findFirst().ifPresent(card -> {
                    if (card.getAmenities() != null && !card.getAmenities().getAmenity().isEmpty()) {
                        EssentialInfoData amenities = HotelsHelper.buildRoomAmenities(card.getAmenities().getAmenity());
                        HotelsHelper.addEssentialInfo(Collections.singletonList(amenities), hp.getEssentialInfoData());
                    }
                });
            }
        }
    }

    private static CancellationCharge buildCancellationCharge(CancellationPeriodWS wsPeriod, Boolean vatIncluded, Double equivVatRate, Date issueDate1, Date checkInDate) {
        CancellationCharge result = new CancellationCharge();
        result.setStartDate(HotelsBaseHelper.toDate(wsPeriod.getFrom()));
        result.setEndDate(HotelsBaseHelper.toDate(wsPeriod.getTo()));
        CancellationPolicyHelper.fixDates(result, issueDate1, checkInDate);
        if (BooleanUtils.isNotTrue((Boolean)wsPeriod.getPenalty().isUnknown())) {
            Money penalty = HotelsBaseHelper.convertMoneyFromGds(wsPeriod.getPenalty());
            BigDecimal vatAmount = equivVatRate == null ? null : VatAmount.of((BigDecimal)penalty.getValue(), (double)equivVatRate).getVatAmount();
            CancellationChargeHelper.fillCancellationCharge((CancellationCharge)result, (Money)penalty, (boolean)(vatIncluded != null ? vatIncluded : false), (BigDecimal)vatAmount);
        }
        boolean withTime = CancellationPolicyHelper.isWithTime(wsPeriod.getFrom()) || CancellationPolicyHelper.isWithTime(wsPeriod.getTo());
        result.setWithTime(withTime);
        boolean timeZoneIsUnknown = !CancellationPolicyHelper.hasOffsetData(wsPeriod.getFrom()) && !CancellationPolicyHelper.hasOffsetData(wsPeriod.getTo());
        result.setTimeZoneIsUnknown(Boolean.valueOf(timeZoneIsUnknown));
        result.setNotAvailableViaAPI(Boolean.valueOf(BooleanUtils.isNotTrue((Boolean)wsPeriod.isCancellable())));
        result.setPolicyText(wsPeriod.getText());
        return result;
    }

    public static DoPricingQuery buildPriceRequest(List<HotelOffer> offers) {
        DoPricingQuery query = new DoPricingQuery();
        for (int i = 0; i < offers.size(); ++i) {
            HotelOffer offer = offers.get(i);
            if (offer.getProvider() == HotelProvider.INTERNAL) continue;
            if (query.getItems() == null) {
                query.setItems(new DoPricingQuery.Items());
            }
            query.getItems().getItem().add(HotelsHelper.convert(offer, i));
        }
        query.setDictionaryLanguages(HotelsHelper.buildDictionaryLanguages());
        return query;
    }

    public static DoPricingQuery buildDoPricingQuery(List<HotelProduct> products) {
        DoPricingQuery query = new DoPricingQuery();
        for (int i = 0; i < products.size(); ++i) {
            if (query.getItems() == null) {
                query.setItems(new DoPricingQuery.Items());
            }
            query.getItems().getItem().add(HotelsHelper.convert(products.get(i), i));
        }
        query.setDictionaryLanguages(HotelsHelper.buildDictionaryLanguages());
        return query;
    }

    private static DoPricingQuery.DictionaryLanguages buildDictionaryLanguages() {
        DoPricingQuery.DictionaryLanguages dictionaryLanguages = new DoPricingQuery.DictionaryLanguages();
        HotelsHelper.populateDictionaryLanguages(dictionaryLanguages.getEntry());
        return dictionaryLanguages;
    }

    public static void populateDictionaryLanguages(Collection<String> entryList) {
        entryList.add("en");
        entryList.add("ru");
    }

    public static DictionaryReference<Country> getSearchParametersCountry(SearchOffersParameters params) {
        return params.getCountry() != null ? params.getCountry() : (DictionaryReference)Optional.ofNullable(DictHelper.resolve((DictionaryReference)params.getCity())).map(city -> city.getCountry()).orElse(null);
    }

    private static ReservationQueryItem convert(HotelOffer offer, int itemId) {
        ReservationQueryItem item = new ReservationQueryItem();
        item.setRequestItemId(Integer.toString(itemId));
        item.setAdditionalInfo(offer.getAdditionalInfo());
        item.setProviderHotelCode(offer.getProviderHotelCode());
        item.setOfferToken(offer.getOfferToken());
        item.setCheckInDate(HotelsBaseHelper.toXMLGregorianCalendar(offer.getStayPolicy().getCheckInDate()));
        item.setCheckOutDate(HotelsBaseHelper.toXMLGregorianCalendar(offer.getStayPolicy().getCheckOutDate()));
        item.setCheckInTime(HotelsHelper.convertTime(offer.getStayPolicy().getCheckInTime()));
        item.setCheckOutTime(HotelsHelper.convertTime(offer.getStayPolicy().getCheckOutTime()));
        item.setStandardCheckInTime(HotelsHelper.convertTime(offer.getStayPolicy().getStandardCheckInTime()));
        item.setStandardCheckOutTime(HotelsHelper.convertTime(offer.getStayPolicy().getStandardCheckOutTime()));
        List meals = offer.getAdditionalServices().stream().filter(s -> s.getType() == AdditionalServiceType.MEAL && !s.isIncludedInTariff()).map(AdditionalService::getCode).collect(Collectors.toList());
        if (!meals.isEmpty()) {
            ReservationQueryItem.RequestedMealplanOptions mealOptions = new ReservationQueryItem.RequestedMealplanOptions();
            mealOptions.getCode().addAll(meals);
            item.setRequestedMealplanOptions(mealOptions);
        }
        item.setExtraBedsAdults(0);
        item.setExtraBedsChildren(0);
        item.setExtraBedsInfants(0);
        item.setGuests(new ReservationQueryItem.Guests());
        offer.getRoomInfo().getTravellers().stream().map(HotelsReservationHelper::buildGuest).forEach(item.getGuests().getGuest()::add);
        return item;
    }

    public static ReservationQueryItem convert(HotelProduct product, int itemId) {
        ReservationQueryItem item = new ReservationQueryItem();
        item.setRequestItemId(Integer.toString(itemId));
        Room room = (Room)product.getRooms().get(0);
        item.setAdditionalInfo(room.getAdditionalInfo());
        item.setProviderHotelCode(product.getProviderHotelCode());
        item.setOfferToken(room.getOfferToken());
        item.setCheckInDate(HotelsBaseHelper.toXMLGregorianCalendar(room.getCheckInDate()));
        item.setCheckOutDate(HotelsBaseHelper.toXMLGregorianCalendar(room.getCheckOutDate()));
        item.setCheckInTime(room.getCheckInTime());
        item.setCheckOutTime(room.getCheckOutTime());
        item.setStandardCheckInTime(room.getStandardCheckInTime());
        item.setStandardCheckOutTime(room.getStandardCheckOutTime());
        List meals = product.getAdditionalServices().stream().filter(s -> s.getType() == AdditionalServiceType.MEAL && !s.isIncludedInTariff()).map(AdditionalService::getCode).collect(Collectors.toList());
        if (!meals.isEmpty()) {
            ReservationQueryItem.RequestedMealplanOptions mealOptions = new ReservationQueryItem.RequestedMealplanOptions();
            mealOptions.getCode().addAll(meals);
            item.setRequestedMealplanOptions(mealOptions);
        }
        item.setExtraBedsAdults(0);
        item.setExtraBedsChildren(0);
        item.setExtraBedsInfants(0);
        String comments = product.getReservation().getNotes();
        if (TextUtil.nonBlank((String)comments)) {
            Remark remark = new Remark();
            remark.setType(RemarkType.COMMENT);
            remark.setValue(comments);
            if (item.getRemarks() != null) {
                item.getRemarks().getRemark().add(remark);
            }
        }
        List remarks = product.getReservation().getReservationRemarks();
        for (ReservationRemark reservationRemark : remarks) {
            Remark remark = new Remark();
            remark.setId(reservationRemark.getQualifier());
            remark.setValue(reservationRemark.getRemarkText());
            if (item.getRemarks() == null) continue;
            item.getRemarks().getRemark().add(remark);
        }
        item.setGuests(new ReservationQueryItem.Guests());
        product.getTravellers().stream().map(HotelsReservationHelper::buildGuest).forEach(item.getGuests().getGuest()::add);
        if (!(product.getProvider() != HotelProvider.OSTROVOK && product.getProvider() != HotelProvider.BRONEVIK && product.getProvider() != HotelProvider.A_AND_A && product.getProvider() != HotelProvider.HOTELBOOK || HotelProductHelper.isPaymentInHotel((HotelProduct)product) || product.isTripartiteAgreement())) {
            item.setSellPrice(HotelsHelper.getSellPrice(product));
        }
        return item;
    }

    private static com.gridnine.hotels.web.ws.Money getSellPrice(HotelProduct product) {
        if (product.getRooms().isEmpty()) {
            return null;
        }
        Room room = (Room)product.getRooms().get(0);
        com.gridnine.hotels.web.ws.Money result = new com.gridnine.hotels.web.ws.Money();
        result.setAmount(room.getEquivalentPrice().add(product.getAdditionalServices().stream().map(AdditionalService::getEquivalentAmount).reduce(BigDecimal.ZERO, BigDecimal::add)));
        result.setCurrencyCode((String)MiscUtil.guarded((Object)product.getGdsCurrency(), (Object)DictHelper.getLocalCurrency()));
        return result;
    }

    public static LocalTime convertTime(XMLGregorianCalendar time) {
        return time != null ? LocalTime.of(time.getHour(), time.getMinute()) : null;
    }

    public static Integer convertTime(LocalTime time) {
        return time != null ? Integer.valueOf(60 * time.getHour() + time.getMinute()) : null;
    }

    public static LocalTime convertTime(Integer time) {
        return time != null ? LocalTime.of(time / 60, time % 60) : null;
    }

    public static void checkRoomsAvailability(Collection<PricingResultItem> pril) {
        HashMap<String, Integer> max = new HashMap<String, Integer>();
        HashMap<String, Integer> off = new HashMap<String, Integer>();
        for (PricingResultItem pri : pril) {
            for (PricingItem pi : pri.getPricingItem()) {
                String offerToken = pi.getOfferToken();
                Integer roomsNumber = pi.getRoomsNumber() != null ? pi.getRoomsNumber() : 0;
                max.putIfAbsent(offerToken, roomsNumber);
                off.put(offerToken, off.getOrDefault(pi.getOfferToken(), 0) + 1);
            }
        }
    }

    private static void fillGuarantees(List<Guarantee> to, List<GuaranteeWS> from) {
        if (null == from) {
            return;
        }
        for (GuaranteeWS ws : from) {
            if (null == ws.getType() || null == ws.getCardTypes() || ws.getCardTypes().getType().isEmpty()) continue;
            Guarantee guarantee = new Guarantee();
            guarantee.setType(HotelsHelper.convertGuaranteeTypeFromGds(ws.getType()));
            ws.getCardTypes().getType().stream().map(HotelsHelper::convertCardTypeFromGds).filter(Objects::nonNull).distinct().forEach(guarantee.getCardTypes()::add);
            to.add(guarantee);
        }
    }

    private static GuaranteeType convertGuaranteeTypeFromGds(GuaranteeTypeWS type) {
        if (null == type) {
            return null;
        }
        try {
            return GuaranteeType.valueOf((String)type.name());
        }
        catch (IllegalArgumentException e) {
            throw Xeption.forDeveloper((String)("\u041d\u0435 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u043c\u044b\u0439 \u0442\u0438\u043f \u0433\u0430\u0440\u0430\u043d\u0442\u0438\u0438 " + type.name()), (Object[])new Object[0]);
        }
    }

    private static CardVendor convertCardTypeFromGds(CreditCardTypeWS cardType) {
        if (null == cardType) {
            return null;
        }
        switch (cardType) {
            case VISA: {
                return CardVendor.VISA;
            }
            case MASTER_CARD: {
                return CardVendor.MASTERCARD;
            }
            case AMERICAN_EXPRESS: {
                return CardVendor.AMEX;
            }
            case DINERS_CLUB: {
                return CardVendor.DINERS_CLUB;
            }
            case JCB: 
            case JAPAN_CREDIT_BUREAU: {
                return CardVendor.JCB;
            }
        }
        return null;
    }
}

