/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.hotels2.ibus.helpers;

import com.gridnine.hotels.web.ws.Commission;
import com.gridnine.hotels.web.ws.Guest;
import com.gridnine.hotels.web.ws.PhoneInfo;
import com.gridnine.hotels.web.ws.PricedItem;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.PassengerType;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProduct;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProductCommission;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProductContractRelationData;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProvider;
import com.gridnine.xtrip.common.model.booking.xtriphotels.Room;
import com.gridnine.xtrip.common.model.dict.CodeSystem;
import com.gridnine.xtrip.common.model.dict.CommunicationType;
import com.gridnine.xtrip.common.model.dict.Country;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.BookingStreamHelper;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.HotelProductHelper;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.profile.Communication;
import com.gridnine.xtrip.common.model.profile.Passport;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.PersonalName;
import com.gridnine.xtrip.common.util.PersonalNameImpl;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.hotels2.ibus.helpers.HotelsBaseHelper;
import com.gridnine.xtrip.server.hotels2.ibus.helpers.HotelsHelper;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.xml.datatype.XMLGregorianCalendar;

public class HotelsReservationHelper {
    private static final Map<HotelProvider, GdsName> hotelProviderGdsNameMap = new HashMap<HotelProvider, GdsName>();

    public static String getCurrency(PricedItem item) {
        if (item.getPrice() != null) {
            return item.getPrice().getCurrency();
        }
        throw Xeption.forDeveloper((String)"currency is undefined in the {0} object", (Object[])new Object[]{item.getClass().getName()});
    }

    public static GdsName getGdsNameFromProvider(HotelProvider provider) {
        return hotelProviderGdsNameMap.get(provider);
    }

    public static String getCaption(HotelProduct hp) {
        return hp.getSystemNumber() + "-" + hp.getStatus().toString();
    }

    public static List<Reservation> getReservations(BookingFile booking) {
        return BookingHelper.getReservationsForProduct((BookingFile)booking, (Class[])new Class[]{HotelProduct.class});
    }

    public static Stream<HotelProduct> getProductsStream(Reservation reservation) {
        return BookingStreamHelper.getProductsStream((Reservation)reservation, HotelProduct.class);
    }

    public static List<HotelProduct> getProducts(Reservation reservation) {
        return HotelsReservationHelper.getProductsStream(reservation).collect(Collectors.toList());
    }

    public static List<HotelProduct> getFinalProducts(Reservation reservation) {
        return HotelsReservationHelper.getProductsStream(reservation).filter(hp -> hp.getNextProduct() == null).collect(Collectors.toList());
    }

    public static HotelProduct getFirstProduct(Reservation reservation) {
        return HotelsReservationHelper.getProductsStream(reservation).findFirst().orElse(null);
    }

    public static Room getFirstRoom(HotelProduct product) {
        if (product.getRooms().isEmpty()) {
            return null;
        }
        return (Room)product.getRooms().get(0);
    }

    public static void relateProducts(HotelProduct previous, HotelProduct next) {
        if (previous == null || next == null) {
            return;
        }
        previous.setNextProduct(next);
        next.setPreviousProduct(previous);
    }

    public static HotelProductCommission buildHotelCommission(Commission wsCommission, Money totalPrice) {
        if (wsCommission == null) {
            return null;
        }
        return HotelsReservationHelper.buildHotelCommission(HotelsBaseHelper.convertMoneyFromGds(wsCommission.getAmount()), null, wsCommission.getPercentage(), totalPrice);
    }

    public static HotelProductCommission buildHotelCommission(Money amount, BigDecimal equivalentAmount, BigDecimal percentage, Money totalPrice) {
        HotelProductCommission result = new HotelProductCommission();
        result.setPercentage(percentage);
        result.setAmount(amount);
        if (equivalentAmount != null) {
            result.setEquivalentAmount(equivalentAmount);
        } else if (amount != null) {
            result.setEquivalentAmount(amount.getValue());
        } else if (totalPrice != null && percentage != null) {
            result.setEquivalentAmount(totalPrice.getValue().multiply(percentage).divide(BigDecimal.valueOf(100L)));
        }
        return result;
    }

    public static HotelProductCommission buildHotelCommission(HotelProductCommission wsCommission, Money totalPrice) {
        if (wsCommission == null) {
            return null;
        }
        return HotelsReservationHelper.buildHotelCommission(wsCommission.getAmount(), wsCommission.getEquivalentAmount(), wsCommission.getPercentage(), totalPrice);
    }

    public static void updateVendorContractRelationCommission(HotelProduct hp, HotelProductCommission hotelCommission) {
        HotelProductContractRelationData vendorContractRelation = HotelProductHelper.getVendorContractRelation((HotelProduct)hp);
        if (vendorContractRelation == null) {
            return;
        }
        HotelProductHelper.removeVendorCommission((HotelProductContractRelationData)vendorContractRelation);
        if (hotelCommission != null) {
            vendorContractRelation.getCommissions().add(HotelsHelper.toHotelGeneralProductCommission(hotelCommission));
        }
    }

    public static Traveller buildTraveller(Guest wsGuest) {
        Traveller result = new Traveller();
        Passport passport = HotelsReservationHelper.buildPassport(wsGuest);
        String fullName = TextUtil.buildFullName((PersonalName)TextUtil.createName((String)passport.getFirstName(), null, (String)passport.getLastName()));
        result.setName(TextUtil.isBlank((String)fullName) ? null : fullName);
        result.setBirthday(passport.getBirthday());
        result.setGender(passport.getGender());
        result.setPassport(passport);
        return result;
    }

    public static boolean isChild(Date birthday) {
        Integer fullAge = ProfileHelper.getFullAge((Date)birthday);
        return fullAge != null && HotelsBaseHelper.isChild(fullAge);
    }

    public static DictionaryReference<PassengerType> getPassengerType(boolean isChild) {
        return isChild ? DictHelper.getChildPassengerType() : DictHelper.getAdultPassengerType();
    }

    private static boolean isTravellerChild(Traveller traveller) {
        return HotelsReservationHelper.isChild(traveller.getBirthday());
    }

    public static DictionaryReference<PassengerType> getTravellerPassengerType(Traveller traveller) {
        return HotelsReservationHelper.getPassengerType(HotelsReservationHelper.isTravellerChild(traveller));
    }

    public static Guest buildGuest(Traveller traveller) {
        if (traveller == null) {
            return null;
        }
        Guest guest = new Guest();
        guest.setBirthDate(HotelsBaseHelper.toXMLGregorianCalendar(traveller.getBirthday()));
        if (traveller.getName() != null) {
            PersonalNameImpl personalName = new PersonalNameImpl();
            TextUtil.splitFullName((String)traveller.getName(), (PersonalName)personalName);
            guest.setFirstName(personalName.getFirstName());
            guest.setLastName(personalName.getLastName());
        }
        guest.setChild(HotelsReservationHelper.isTravellerChild(traveller));
        guest.setTitle(HotelsBaseHelper.convertTitleFromGender(traveller.getGender()));
        String citizenship = HotelsReservationHelper.getCitizenship(traveller);
        if (citizenship != null) {
            guest.setCitizenship(citizenship);
        }
        traveller.getCommunications().stream().filter(comm -> CommunicationType.WORK_PHONE == comm.getType() || CommunicationType.HOME_PHONE == comm.getType()).filter(comm -> TextUtil.nonBlank((String)comm.getSense())).findFirst().ifPresent(phone -> {
            guest.setPhone(ProfileHelper.buildFullPhoneNumber((Communication)phone));
            guest.setPhoneInfo(HotelsReservationHelper.buildPhoneInfo(phone));
        });
        return guest;
    }

    private static String getCitizenship(Traveller traveller) {
        Country citizenship;
        EntityContainer personCtr;
        String result = null;
        Passport passport = traveller.getPassport();
        if (passport == null && (personCtr = EntityStorage.get().resolve(traveller.getPassenger())) != null) {
            passport = ((Person)personCtr.getEntity()).getPassports().stream().filter(p -> p.getCitizenship() != null).findFirst().orElse(null);
        }
        if (passport != null && (citizenship = (Country)DictionaryCache.get().resolveReference(passport.getCitizenship())) != null) {
            result = (String)citizenship.getCodeVariants().get(CodeSystem.IATA.name());
        }
        return result;
    }

    public static PhoneInfo buildPhoneInfo(Communication communication) {
        PhoneInfo phoneInfo = new PhoneInfo();
        phoneInfo.setCountryCode(communication.getCountryCode());
        phoneInfo.setCityCode(communication.getCityCode());
        phoneInfo.setPhoneNumber(communication.getSense());
        phoneInfo.setInternalNumber(communication.getInternalNumber());
        return phoneInfo;
    }

    private static Passport buildPassport(Guest wsGuest) {
        Passport result = new Passport();
        String fullName = wsGuest.getFullName();
        if (TextUtil.nonBlank((String)fullName)) {
            String[] names = fullName.split(" ", 2);
            result.setLastName(names[0]);
            if (names.length > 1) {
                result.setFirstName(names[1]);
            }
        } else {
            result.setLastName(wsGuest.getLastName());
            result.setFirstName(wsGuest.getFirstName());
        }
        result.setBirthday(MiscUtil.toDateWithoutTimeZone((XMLGregorianCalendar)wsGuest.getBirthDate()));
        result.setGender(HotelsBaseHelper.convertGenderFromGds(wsGuest.getTitle()));
        result.setCitizenship(HotelsBaseHelper.resolveNativeCode(Country.class, wsGuest.getCitizenship()));
        return result;
    }

    public static boolean isSameRoom(Room room1, Room room2, boolean defaultValue) {
        String room1Id = HotelsReservationHelper.getRoomId(room1);
        String room2Id = HotelsReservationHelper.getRoomId(room2);
        if (TextUtil.nonBlank((String)room1Id) && TextUtil.nonBlank((String)room2Id)) {
            return MiscUtil.equals((Object)room1Id, (Object)room2Id, (boolean)false);
        }
        return defaultValue;
    }

    public static String getRoomId(Room room) {
        return TextUtil.nonBlank((String)room.getAlterId()) ? room.getAlterId().trim() : TextUtil.trim((String)room.getId());
    }

    public static <T extends BaseProduct> HotelProduct findProduct(List<HotelProduct> products, HotelProduct newProduct) {
        return products.stream().filter(hp -> HotelsReservationHelper.isSameProduct(hp, newProduct)).findFirst().orElse(null);
    }

    private static boolean isSameProduct(HotelProduct hp1, HotelProduct hp2) {
        List rooms1 = hp1.getRooms();
        List rooms2 = hp2.getRooms();
        boolean alternativelyEquals = HotelsReservationHelper.alternativelyEquals(hp1, hp2);
        return CollectionUtil.equals((Collection)rooms1, (Collection)rooms2, (r1, r2) -> HotelsReservationHelper.isSameRoom(r1, r2, alternativelyEquals), (boolean)false);
    }

    public static boolean alternativelyEquals(HotelProduct hp1, HotelProduct hp2) {
        List<EntityReference<Person>> profiles2;
        boolean hasAbsentProfiles;
        boolean isOneProduct = HotelsReservationHelper.isOneProduct(hp1, hp2);
        boolean bl = hasAbsentProfiles = HotelsReservationHelper.hasAbsentProfiles(hp1) || HotelsReservationHelper.hasAbsentProfiles(hp2);
        if (hasAbsentProfiles) {
            return isOneProduct;
        }
        List<EntityReference<Person>> profiles1 = HotelsReservationHelper.collectProfiles(hp1);
        if (!CollectionUtil.isSameContent(profiles1, profiles2 = HotelsReservationHelper.collectProfiles(hp2))) {
            return false;
        }
        if (isOneProduct) {
            return true;
        }
        return CollectionUtil.equals((Collection)hp1.getRooms(), (Collection)hp2.getRooms(), (r1, r2) -> MiscUtil.equals((Object)r1.getCheckInDate(), (Object)r2.getCheckInDate()) && MiscUtil.equals((Object)r1.getCheckOutDate(), (Object)r2.getCheckOutDate()), (boolean)true);
    }

    private static boolean hasAbsentProfiles(HotelProduct hp) {
        return hp.getTravellers().stream().anyMatch(t -> t == null || t.getPassenger() == null);
    }

    private static List<EntityReference<Person>> collectProfiles(HotelProduct hp1) {
        return hp1.getTravellers().stream().filter(Objects::nonNull).map(Traveller::getPassenger).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private static boolean isOneProduct(HotelProduct hp1, HotelProduct hp2) {
        return HotelsReservationHelper.getFinalProducts(hp1.getReservation()).size() == 1 && HotelsReservationHelper.getFinalProducts(hp2.getReservation()).size() == 1;
    }

    public static boolean isDirectContract(Reservation reservation) {
        return HotelsReservationHelper.getProductsStream(reservation).anyMatch(hp -> hp.getProvider() == HotelProvider.INTERNAL);
    }

    public static boolean isRefundAvailable(HotelProduct product) {
        if ((product.getStatus() == ProductStatus.SELL || product.getStatus() == ProductStatus.REQUEST && product.getProvider() == HotelProvider.BRONEVIK || product.getStatus() == ProductStatus.REQUEST && product.getSubProvider() != null && MiscUtil.equals((Object)"HOTELBOOK_HBPro", (Object)product.getSubProvider().getCode())) && product.getNextProduct() == null) {
            return HotelsReservationHelper.checkAgainstCancellationPolicy(product);
        }
        return false;
    }

    private static boolean checkAgainstCancellationPolicy(HotelProduct product) {
        Date now = new Date();
        for (Room room : product.getRooms()) {
            Date checkInDate = room.getCheckInDate();
            if (checkInDate == null || !now.after(checkInDate)) continue;
            return false;
        }
        return true;
    }

    public static void updateTimeLimit(Reservation reservation) {
        if (!reservation.isManualTimeLimit()) {
            reservation.setTimeLimit((Date)reservation.getProducts().stream().filter(p -> p instanceof HotelProduct).map(HotelProduct.class::cast).map(p -> p.getRooms().isEmpty() ? null : ((Room)p.getRooms().get(0)).getCheckInDate()).filter(Objects::nonNull).min(Date::compareTo).map(d -> MiscUtil.addDaysToDate((Date)MiscUtil.clearTime((Date)d), (int)1)).orElse(null));
        }
    }

    static {
        hotelProviderGdsNameMap.put(HotelProvider.INTERNAL, GdsName.IBE);
        hotelProviderGdsNameMap.put(HotelProvider.GTA, GdsName.GTA);
        hotelProviderGdsNameMap.put(HotelProvider.TRAVCO, GdsName.TRAVCO);
        hotelProviderGdsNameMap.put(HotelProvider.OKTOGO, GdsName.OKTOGO);
        hotelProviderGdsNameMap.put(HotelProvider.RCR, GdsName.RCR);
        hotelProviderGdsNameMap.put(HotelProvider.HOTELBOOK, GdsName.HOTELBOOK);
        hotelProviderGdsNameMap.put(HotelProvider.A_AND_A, GdsName.A_AND_A);
        hotelProviderGdsNameMap.put(HotelProvider.EXPEDIA, GdsName.EXPEDIA);
        hotelProviderGdsNameMap.put(HotelProvider.HORSE_21, GdsName.HORSE_21);
        hotelProviderGdsNameMap.put(HotelProvider.BRONEVIK, GdsName.BRONEVIK);
        hotelProviderGdsNameMap.put(HotelProvider.OSTROVOK, GdsName.OSTROVOK);
        hotelProviderGdsNameMap.put(HotelProvider.SUSANIN, GdsName.SUSANIN);
        hotelProviderGdsNameMap.put(HotelProvider.SABRE, GdsName.SABRE);
        hotelProviderGdsNameMap.put(HotelProvider.BOOKING, GdsName.BOOKING);
        hotelProviderGdsNameMap.put(HotelProvider.BEDSONLINE, GdsName.BEDSONLINE);
        hotelProviderGdsNameMap.put(HotelProvider.ACADEMSERVICE, GdsName.ACADEMSERVICE);
        hotelProviderGdsNameMap.put(HotelProvider.HOTELSTAR, GdsName.HOTELSTAR);
    }
}

