/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.hotels2.ibus.helpers;

import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.xtriphotels.CancellationCharge;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProduct;
import com.gridnine.xtrip.common.model.booking.xtriphotels.Penalty;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.helpers.HotelProductHelper;
import com.gridnine.xtrip.common.model.helpers.MoneyHelper;
import com.gridnine.xtrip.common.model.system.Money;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;

public class PenaltyHelper {
    private static final String CANCELLATION_PENALTY_CODE = "cancellation";

    public static Penalty createPenalty(Money value, String equivalentCurrency) {
        if (PenaltyHelper.isInvalid(value)) {
            return null;
        }
        BigDecimal equivalentAmount = equivalentCurrency.equalsIgnoreCase(value.getCurrency()) ? value.getValue() : MoneyHelper.exchange((Money)value, (String)equivalentCurrency);
        return PenaltyHelper.createPenalty(value, equivalentAmount);
    }

    private static boolean isInvalid(Money value) {
        return value == null || value.getCurrency() == null;
    }

    public static Penalty createPenalty(Money baseAmount, BigDecimal equivalentAmount) {
        Penalty result = new Penalty();
        result.setBaseAmount(baseAmount);
        result.setEquivalentAmount(equivalentAmount);
        result.setCode(CANCELLATION_PENALTY_CODE);
        return result;
    }

    public static BigDecimal getPenalty(HotelProduct product) {
        return ProductHandler.of((BaseProduct)product).getPenalty((BaseProduct)product);
    }

    public static Penalty createPenaltyFromPolicy(HotelProduct hp) {
        CancellationCharge charge = PenaltyHelper.findAppropriateCancellationCharge(hp);
        if (charge != null) {
            Money baseAmount = PenaltyHelper.baseAmount(hp, charge);
            return PenaltyHelper.createPenalty(baseAmount, hp.getGdsCurrency());
        }
        return PenaltyHelper.createPenalty(null, BigDecimal.ZERO);
    }

    private static CancellationCharge findAppropriateCancellationCharge(HotelProduct hp) {
        CancellationCharge result = null;
        Date now = new Date();
        Money basePrice = HotelProductHelper.getBasePrice((HotelProduct)hp);
        Money lastCharge = null;
        Date lastChargeEnd = null;
        for (CancellationCharge cc : HotelProductHelper.getAvailableCancellationCharges((HotelProduct)hp)) {
            Money p = PenaltyHelper.calculatePenalty(cc, basePrice);
            if (p == null) continue;
            Date endDate = cc.getEndDate();
            if (lastCharge == null || endDate == null || lastChargeEnd != null && lastChargeEnd.before(endDate)) {
                lastCharge = p;
                lastChargeEnd = endDate;
                if (lastChargeEnd != null && now.after(lastChargeEnd)) {
                    result = cc;
                }
            }
            if (cc.getStartDate() != null && now.before(cc.getStartDate()) || endDate != null && now.after(endDate)) continue;
            result = cc;
            break;
        }
        return result;
    }

    private static Money baseAmount(HotelProduct hp, CancellationCharge charge) {
        Money basePrice = HotelProductHelper.getBasePrice((HotelProduct)hp);
        return PenaltyHelper.calculatePenalty(charge, basePrice);
    }

    private static Money calculatePenalty(CancellationCharge charge, Money basePrice) {
        if (charge == null || charge.getPenalty() == null) {
            return null;
        }
        if (charge.getPenalty().getMoney() != null) {
            return charge.getPenalty().getMoney();
        }
        if (charge.getPenalty().getRate() == null) {
            return null;
        }
        if (charge.getPenalty().getRate() == 0.0) {
            return MoneyHelper.buildMoney((BigDecimal)BigDecimal.ZERO, (String)basePrice.getCurrency());
        }
        BigDecimal amount = basePrice.getValue().multiply(BigDecimal.valueOf(charge.getPenalty().getRate() / 100.0)).divide(BigDecimal.ONE, 2, RoundingMode.HALF_UP);
        return MoneyHelper.buildMoney((BigDecimal)amount, (String)basePrice.getCurrency());
    }
}

